/*
 * Decompiled with CFR 0.152.
 */
package org.melati.poem.prepro;

import java.io.StreamTokenizer;
import org.melati.poem.prepro.FieldDef;

class ParsingDSDException
extends RuntimeException {
    private static final long serialVersionUID = 8913017013506544549L;
    String expected;
    String got;
    int lineNumber;
    String message;
    FieldDef field = null;

    ParsingDSDException() {
    }

    ParsingDSDException(String expected, String got) {
        this.expected = expected;
        this.got = "\"" + got + "\"";
    }

    ParsingDSDException(String expected, StreamTokenizer got) {
        this.expected = expected;
        this.got = "\"" + got.toString() + "\"";
        this.lineNumber = got.lineno();
    }

    ParsingDSDException(String expected, String got, StreamTokenizer context) {
        this.expected = expected;
        this.got = "\"" + got + "\" near " + context.toString();
        this.lineNumber = context.lineno();
    }

    ParsingDSDException(int lineNo, String error) {
        this.message = error;
        this.lineNumber = lineNo;
    }

    public String getMessage() {
        String returnString = "";
        if (this.lineNumber != 0) {
            returnString = "Definition ending on line " + this.lineNumber + ": ";
        }
        if (this.expected != null) {
            returnString = returnString + "Expected \"" + this.expected + "\" but got " + this.got + "\n";
        }
        if (this.message != null) {
            returnString = returnString + this.message;
        }
        return returnString;
    }
}

