/*
 * Decompiled with CFR 0.152.
 */
package org.melati.poem.prepro;

import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.melati.poem.prepro.DSD;
import org.melati.poem.prepro.FieldDef;
import org.melati.poem.prepro.Generator;
import org.melati.poem.prepro.IllegalityException;
import org.melati.poem.prepro.NonAbstractEmptyTableException;
import org.melati.poem.prepro.ParsingDSDException;
import org.melati.poem.prepro.ReferenceFieldDef;
import org.melati.poem.prepro.StringUtils;
import org.melati.poem.prepro.TableNamingInfo;
import org.melati.poem.prepro.TableNamingStore;
import org.melati.poem.prepro.TableQualifier;

public class TableDef {
    DSD dsd;
    final String nameFromDsd;
    final String capitalisedName;
    final String name;
    String displayName;
    String description;
    String category;
    String superclass;
    int displayOrder;
    boolean seqCached;
    int cacheSize = -1;
    private Vector<FieldDef> fields = new Vector();
    boolean isAbstract;
    boolean definesColumns;
    TableNamingInfo tableNamingInfo = null;
    int nextFieldDisplayOrder = 0;
    private final Hashtable<String, String> imports = new Hashtable();
    private final Vector<String> tableBaseImports = new Vector();
    private final Vector<String> persistentBaseImports = new Vector();
    private final TableDef this_ = this;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TableDef(DSD dsd, StreamTokenizer tokens, int displayOrder, boolean isAbstract, TableNamingStore nameStore) throws ParsingDSDException, IOException, IllegalityException {
        this.dsd = dsd;
        this.displayOrder = displayOrder;
        this.isAbstract = isAbstract;
        if (tokens.ttype != -3) {
            throw new ParsingDSDException("<table name>", tokens);
        }
        this.nameFromDsd = tokens.sval;
        this.name = this.nameFromDsd.toLowerCase();
        this.capitalisedName = this.nameFromDsd.substring(0, 1).toUpperCase() + this.nameFromDsd.substring(1);
        if (tokens.nextToken() == -3) {
            if (!tokens.sval.equals("extends")) {
                throw new ParsingDSDException("{", tokens);
            }
            tokens.wordChars(46, 46);
            try {
                if (tokens.nextToken() != -3) {
                    throw new ParsingDSDException("<class name>", tokens);
                }
            }
            finally {
                tokens.ordinaryChar(46);
            }
            this.superclass = tokens.sval;
        } else {
            tokens.pushBack();
        }
        this.tableNamingInfo = nameStore.add(dsd, dsd.packageName, this.nameFromDsd, this.superclass);
        while (tokens.nextToken() == 40) {
            tokens.nextToken();
            TableQualifier.from(tokens).apply(this);
            DSD.expect(tokens, ')');
        }
        DSD.expect(tokens, '{');
        while (tokens.nextToken() != 125) {
            this.fields.addElement(FieldDef.from(this, tokens, this.nextFieldDisplayOrder++));
        }
        tokens.nextToken();
    }

    void addImport(String importName, String destination) {
        if (!(destination.equals("table") || destination.equals("persistent") || destination.equals("both"))) {
            throw new RuntimeException("Destination other than 'table', 'persistent' or 'both' used:" + destination);
        }
        String existing = null;
        existing = this.imports.put(importName, destination);
        if (existing != null && existing != destination) {
            this.imports.put(importName, "both");
        }
    }

    public void generateTableDeclarationJava(Writer w) throws IOException {
        if (!this.isAbstract) {
            w.write("  private " + this.tableNamingInfo.tableMainClassShortName() + "<" + this.tableNamingInfo.mainClassShortName() + ">" + " tab_" + this.name + " = null;\n");
        }
    }

    public void generateTableDefinitionJava(Writer w) throws IOException {
        if (!this.isAbstract) {
            w.write("    redefineTable(tab_" + this.name + " = " + "new " + this.tableNamingInfo.tableMainClassUnambiguous() + (this.tableNamingInfo.tableMainClassRootReturnClass().equals(this.tableNamingInfo.tableMainClassUnambiguous()) ? "<" + this.tableNamingInfo.mainClassUnambiguous() + ">" : "") + "(this, \"" + this.nameFromDsd + "\", " + "DefinitionSource.dsd));\n");
        }
    }

    public void generateTableAccessorJava(Writer w) throws IOException {
        if (this.isAbstract) {
            return;
        }
        this.generateTableAccessorDeclaration(w, false);
        w.write(" {\n    return ");
        if (!this.tableNamingInfo.tableMainClassRootReturnClass().equals(this.tableNamingInfo.tableMainClassUnambiguous())) {
            w.write("(" + this.tableNamingInfo.tableMainClassRootReturnClass() + ")");
        }
        w.write("tab_" + this.name + ";\n  }\n");
        if (this.tableNamingInfo.hidesOther) {
            this.generateSubclassedTableAccessorDeclaration(w, false);
            w.write(" {\n    return ");
            w.write("tab_" + this.name + ";\n  }\n");
        }
    }

    public void generateTableAccessorDefnJava(Writer w) throws IOException {
        if (this.isAbstract) {
            return;
        }
        this.generateTableAccessorDeclaration(w, true);
        w.write(";\n");
        if (this.tableNamingInfo.hidesOther) {
            this.generateSubclassedTableAccessorDeclaration(w, true);
            w.write(";\n");
        }
    }

    private void generateTableAccessorDeclaration(Writer w, boolean inInterface) throws IOException {
        w.write("\n /**\n  * Retrieves the " + this.tableNamingInfo.tableMainClassShortName() + " table.\n" + "  *\n");
        if (!this.tableNamingInfo.tableMainClassRootReturnClass().equals(this.tableNamingInfo.tableMainClassUnambiguous())) {
            w.write("  * Deprecated: use get" + this.tableNamingInfo.projectName + this.tableNamingInfo.tableMainClassShortName() + "\n");
        }
        w.write("  * See org.melati.poem.prepro.TableDef#generateTableAccessorJava \n  * @return the " + this.tableNamingInfo.tableMainClassRootReturnClass() + " from this database\n" + "  */\n");
        if (!inInterface && !this.tableNamingInfo.tableMainClassRootReturnClass().equals(this.tableNamingInfo.tableMainClassUnambiguous())) {
            w.write("  @SuppressWarnings({ \"rawtypes\", \"unchecked\" })\n");
        }
        w.write("  public " + this.tableNamingInfo.tableMainClassRootReturnClass() + "<" + this.tableNamingInfo.mainClassRootReturnClass() + "> get" + this.tableNamingInfo.tableMainClassShortName() + "()");
    }

    private void generateSubclassedTableAccessorDeclaration(Writer w, boolean inInterface) throws IOException {
        w.write("\n /**\n  * Retrieves our (" + this.tableNamingInfo.projectName + ") " + this.tableNamingInfo.tableMainClassShortName() + " table.\n" + "  *\n" + "  * See org.melati.poem.prepro.TableDef#generateSubclassedTableAccessorDeclaration \n" + "  * @return the " + this.tableNamingInfo.tableMainClassRootReturnClass() + " from this database\n" + "  */\n");
        w.write("  public " + this.tableNamingInfo.tableMainClassShortName() + "<" + this.tableNamingInfo.mainClassShortName() + "> " + this.tableNamingInfo.leafTableAccessorName() + "()");
    }

    public void generatePersistentBaseJava(Writer w) throws IOException {
        Enumeration<String> e = this.persistentBaseImports.elements();
        while (e.hasMoreElements()) {
            String importedClassName = e.nextElement();
            TableNamingInfo tni = this.dsd.tableNamingStore.tableInfoByTableOrPersistentFQName.get(importedClassName);
            if (this.tableNamingInfo.extended != null) {
                if (tni != null) {
                    if (tni.equals(this.tableNamingInfo)) {
                        w.write("// ours\n//import " + importedClassName + ";\n");
                        continue;
                    }
                    if (tni.equals(this.tableNamingInfo.extended)) {
                        if (this.tableNamingInfo.extended.extended != null) {
                            w.write("// extends extended\n//import " + importedClassName + ";\n");
                            continue;
                        }
                        w.write("// base extension\nimport " + importedClassName + ";\n");
                        continue;
                    }
                    w.write("import " + importedClassName + ";\n");
                    continue;
                }
                w.write("import " + importedClassName + ";\n");
                continue;
            }
            w.write("import " + importedClassName + ";\n");
        }
        w.write("\n");
        String rootReturnClass = this.tableNamingInfo.tableMainClassRootReturnClass();
        w.write("\n/**\n * Melati POEM generated abstract base class for a <code>Persistent</code> \n * <code>" + this.nameFromDsd + "</code> Object.\n" + " *\n" + " * See org.melati.poem.prepro.TableDef#generatePersistentBaseJava \n" + " */\n");
        w.write("public abstract class " + this.tableNamingInfo.baseClassUnambiguous() + " extends " + this.tableNamingInfo.superclassMainUnambiguous() + " {\n" + "\n");
        w.write("\n /**\n  * Retrieves the Database object.\n  * \n  * See org.melati.poem.prepro.TableDef#generatePersistentBaseJava \n  * @return the database\n  */\n");
        w.write("  public " + this.dsd.databaseTablesClassName + " get" + this.dsd.databaseTablesClassName + "() {\n" + "    return (" + this.dsd.databaseTablesClassName + ")getDatabase();\n" + "  }\n" + "\n");
        w.write("\n /**\n  * Retrieves the  <code>" + this.tableNamingInfo.tableMainClassShortName() + "</code> table \n" + "  * which this <code>Persistent</code> is from.\n" + "  * \n" + "  * See org.melati.poem.prepro.TableDef#generatePersistentBaseJava \n" + "  * @return the " + rootReturnClass + "\n" + "  */\n");
        w.write("  @SuppressWarnings(\"unchecked\")\n");
        w.write("  public " + rootReturnClass + "<" + this.tableNamingInfo.mainClassRootReturnClass() + "> " + this.tableNamingInfo.rootTableAccessorName() + "() {\n" + "    return (" + rootReturnClass + "<" + this.tableNamingInfo.mainClassRootReturnClass() + ">)getTable();\n" + "  }\n\n");
        if (!this.fields.elements().hasMoreElements()) {
            w.write("  // There are no Fields in this table, only in its ancestors \n");
        } else {
            w.write("  @SuppressWarnings(\"unchecked\")\n");
            w.write("  private " + this.tableNamingInfo.tableMainClassUnambiguous() + "<" + this.tableNamingInfo.mainClassUnambiguous() + "> _" + this.tableNamingInfo.rootTableAccessorName() + "() {\n" + "    return (" + this.tableNamingInfo.tableMainClassUnambiguous() + "<" + this.tableNamingInfo.mainClassUnambiguous() + ">)getTable();\n" + "  }\n\n");
            w.write("  // Fields in this table \n");
            Enumeration<FieldDef> f = this.fields.elements();
            while (f.hasMoreElements()) {
                FieldDef fd = f.nextElement();
                w.write(" /**\n");
                w.write(DSD.javadocFormat(2, 1, (fd.displayName != null ? fd.displayName : fd.name) + (fd.description != null ? " - " + fd.description : "")));
                w.write("  */\n");
                w.write("  protected ");
                fd.generateJavaDeclaration(w);
                w.write(";\n");
            }
            f = this.fields.elements();
            while (f.hasMoreElements()) {
                FieldDef field = f.nextElement();
                w.write(10);
                field.generateBaseMethods(w);
                w.write(10);
                field.generateFieldCreator(w);
            }
        }
        for (TableDef t : this.dsd.tablesInDatabase) {
            if (t.isAbstract || t.superclass != null) continue;
            for (FieldDef f : t.fields) {
                ReferenceFieldDef rfd;
                if (!(f instanceof ReferenceFieldDef) || (rfd = (ReferenceFieldDef)f).getTargetTableNamingInfo() == null || !rfd.getTargetTableNamingInfo().mainClassFQName().equals(this.tableNamingInfo.mainClassFQName())) continue;
                w.write(10);
                w.write("  private CachedSelection<" + rfd.shortestUnambiguousClassname + "> " + rfd.name + rfd.shortestUnambiguousClassname + "s = null;\n");
                w.write("  /** References to this " + this.tableNamingInfo.mainClassShortName() + " in the " + rfd.shortestUnambiguousClassname + " table via its " + rfd.name + " field.*/\n");
                w.write("  @SuppressWarnings(\"unchecked\")\n");
                w.write("  public Enumeration<" + rfd.shortestUnambiguousClassname + "> get" + StringUtils.capitalised(rfd.name) + rfd.shortestUnambiguousClassname + "s() {\n");
                w.write("    if (getTroid() == null)\n");
                w.write("      return new EmptyEnumeration<" + rfd.shortestUnambiguousClassname + ">();\n");
                w.write("    else {\n");
                w.write("      if (" + rfd.name + rfd.shortestUnambiguousClassname + "s == null)\n");
                w.write("        " + rfd.name + rfd.shortestUnambiguousClassname + "s =\n");
                w.write("          get" + this.dsd.databaseTablesClassName + "().get" + rfd.shortestUnambiguousClassname + "Table().get" + StringUtils.capitalised(rfd.name) + "Column().cachedSelectionWhereEq(getTroid());\n");
                w.write("      return " + rfd.name + rfd.shortestUnambiguousClassname + "s.objects();\n");
                w.write("    }\n");
                w.write("  }\n");
                w.write("\n");
                w.write("\n");
                w.write("  /** References to this " + this.tableNamingInfo.mainClassShortName() + " in the " + rfd.shortestUnambiguousClassname + " table via its " + rfd.name + " field, as a List.*/\n");
                w.write("  public List<" + StringUtils.capitalised(rfd.shortestUnambiguousClassname) + "> get" + StringUtils.capitalised(rfd.name) + rfd.shortestUnambiguousClassname + "List() {\n");
                w.write("    return Collections.list(get" + StringUtils.capitalised(rfd.name) + rfd.shortestUnambiguousClassname + "s());\n");
                w.write("  }\n");
                w.write("\n");
                w.write("\n");
            }
        }
        w.write(10);
        w.write("}\n");
    }

    public void generatePersistentJava(Writer w) throws IOException {
        w.write("import " + this.dsd.packageName + ".generated." + this.tableNamingInfo.baseClassShortName() + ";\n");
        w.write("\n/**\n * Melati POEM generated, programmer modifiable stub \n * for a <code>Persistent</code> <code>" + this.tableNamingInfo.mainClassShortName() + "</code> object.\n");
        w.write(" * \n" + (this.description != null ? " * <p> \n * Description: \n" + DSD.javadocFormat(1, 3, this.description + (this.description.lastIndexOf(".") != this.description.length() - 1 ? "." : "")) + " * </p>\n" : ""));
        w.write(this.fieldSummaryTable());
        w.write(" * \n * See org.melati.poem.prepro.TableDef#generatePersistentJava \n */\n");
        w.write("public class " + this.tableNamingInfo.mainClassShortName() + " extends " + this.tableNamingInfo.baseClassShortName() + " {\n");
        w.write("\n /**\n  * Constructor \n  * for a <code>Persistent</code> <code>" + this.tableNamingInfo.mainClassShortName() + "</code> object.\n" + (this.description != null ? "  * <p>\n  * Description: \n" + DSD.javadocFormat(2, 3, this.description + (this.description.lastIndexOf(".") != this.description.length() - 1 ? "." : "")) + "  * </p>\n" : "") + "  * \n" + "  * See org.melati.poem.prepro.TableDef" + "#generatePersistentJava \n" + "  */\n");
        w.write("  public " + this.tableNamingInfo.mainClassShortName() + "() { \n" + "    super();\n" + "}\n" + "\n" + "  // programmer's domain-specific code here\n" + "}\n");
    }

    public void generateTableBaseJava(Writer w) throws IOException {
        Enumeration<String> e = this.tableBaseImports.elements();
        while (e.hasMoreElements()) {
            String packageName = e.nextElement();
            if (this.ambiguous(packageName)) {
                w.write("// Extended table \nimport " + packageName + ";\n");
                continue;
            }
            w.write("import " + packageName + ";\n");
        }
        w.write("\n");
        w.write("\n/**\n * Melati POEM generated base class for <code>Table</code> <code>" + this.nameFromDsd + "</code>.\n");
        w.write(" *\n * See org.melati.poem.prepro.TableDef#generateTableBaseJava \n */\n\n");
        w.write("public class " + this.tableNamingInfo.tableBaseClassShortName() + "<T extends " + this.tableNamingInfo.mainClassShortName() + "> extends " + this.tableNamingInfo.superclassTableShortName() + "<T> {\n" + "\n");
        Enumeration<FieldDef> f = this.fields.elements();
        while (f.hasMoreElements()) {
            w.write("  private ");
            f.nextElement().generateColDecl(w);
            w.write(" = null;\n");
        }
        w.write("\n /**\n  * Constructor. \n  * \n  * See org.melati.poem.prepro.TableDef#generateTableBaseJava \n  * @param database          the POEM database we are using\n  * @param name              the name of this <code>Table</code>\n  * @param definitionSource  which definition is being used\n  * @throws PoemException    if anything goes wrong\n  */\n");
        w.write("\n  public " + this.tableNamingInfo.tableBaseClassShortName() + "(\n" + "      Database database, String name,\n" + "      DefinitionSource definitionSource)" + " throws PoemException {\n" + "    super(database, name, definitionSource);\n" + "  }\n" + "\n");
        w.write("\n /**\n  * Get the database tables.\n  *\n  * See org.melati.poem.prepro.TableDef#generateTableBaseJava \n  * @return the database tables\n  */\n");
        w.write("  public " + this.dsd.databaseTablesClassName + " get" + this.dsd.databaseTablesClassName + "() {\n" + "    return (" + this.dsd.databaseTablesClassName + ")getDatabase();\n" + "  }\n" + "\n");
        w.write("\n /**\n  * Initialise this table by defining its columns.\n  *\n  * See org.melati.poem.prepro.TableDef#generateTableBaseJava \n  */\n");
        w.write("  public void init() throws PoemException {\n    super.init();\n");
        Enumeration<FieldDef> fs = this.fields.elements();
        while (fs.hasMoreElements()) {
            fs.nextElement().generateColDefinition(w);
            if (!fs.hasMoreElements()) continue;
            w.write(10);
        }
        w.write("  }\n\n");
        fs = this.fields.elements();
        while (fs.hasMoreElements()) {
            fs.nextElement().generateColAccessor(w);
            w.write(10);
        }
        String requiredReturnClass = this.tableNamingInfo.mainClassRootReturnClass();
        w.write("\n /**\n  * Retrieve the <code>" + this.tableNamingInfo.mainClassShortName() + "</code> as a <code>" + requiredReturnClass + "</code>.\n" + "  *\n" + "  * See org.melati.poem.prepro.TableDef" + "#generateTableBaseJava \n" + "  * @param troid a Table Row Object ID\n" + "  * @return the <code>Persistent</code> identified " + "by the <code>troid</code>\n" + "  */\n");
        w.write("  public " + requiredReturnClass + " get" + this.tableNamingInfo.mainClassShortName() + "Object(" + "Integer troid) {\n" + "    return (" + requiredReturnClass + ")getObject(troid);\n" + "  }\n" + "\n");
        w.write("\n /**\n  * Retrieve the <code>" + this.tableNamingInfo.mainClassShortName() + "</code> \n" + "  * as a <code>" + requiredReturnClass + "</code>.\n" + "  *\n" + "  * See org.melati.poem.prepro.TableDef" + "#generateTableBaseJava \n" + "  * @param troid a Table Row Object ID\n" + "  * @return the <code>Persistent</code> identified " + "  */\n");
        w.write("  public " + requiredReturnClass + " get" + this.tableNamingInfo.mainClassShortName() + "Object(" + "int troid) {\n" + "    return (" + requiredReturnClass + ")getObject(troid);\n" + "  }\n");
        if (!this.isAbstract) {
            w.write("\n  protected JdbcPersistent _newPersistent() {\n    return new " + this.tableNamingInfo.mainClassUnambiguous() + "();\n" + "  }" + "\n");
        }
        if (this.displayName != null) {
            w.write("  public String defaultDisplayName() {\n    return " + StringUtils.quoted(this.displayName, '\"') + ";\n" + "  }\n" + "\n");
        }
        if (this.description != null) {
            w.write("  public String defaultDescription() {\n    return " + StringUtils.quoted(this.description, '\"') + ";\n" + "  }\n" + "\n");
        }
        if (this.seqCached) {
            w.write("  public boolean defaultRememberAllTroids() {\n    return true;\n  }\n\n");
        }
        if (this.cacheSize != -1) {
            w.write("  public Integer defaultCacheLimit() {\n    return new Integer(" + (this.cacheSize == -2 ? "999999999" : "" + this.cacheSize) + ");\n" + "  }\n" + "\n");
        }
        if (this.category != null) {
            w.write("  public String defaultCategory() {\n    return " + StringUtils.quoted(this.category, '\"') + ";\n" + "  }\n" + "\n");
        }
        w.write("  public int defaultDisplayOrder() {\n    return " + this.displayOrder + ";\n" + "  }\n");
        FieldDef uniqueNonNullableField = null;
        ArrayList<FieldDef> requiredFields = new ArrayList<FieldDef>();
        Enumeration<FieldDef> fs2 = this.fields.elements();
        while (fs2.hasMoreElements()) {
            FieldDef f2 = fs2.nextElement();
            if (!f2.isNullable() && f2.isUnique() && !f2.isTroidColumn() && uniqueNonNullableField == null) {
                uniqueNonNullableField = f2;
            }
            if (f2.isNullable() || f2.isTroidColumn()) continue;
            requiredFields.add(f2);
        }
        if (uniqueNonNullableField != null) {
            w.write("\n");
            w.write("  /**\n");
            w.write("   * @return a newly created or existing " + this.tableNamingInfo.mainClassShortName() + "\n");
            w.write("   **/\n");
            w.write("  public " + this.tableNamingInfo.mainClassShortName() + " ensure(");
            boolean seenOne = false;
            for (FieldDef f3 : requiredFields) {
                if (seenOne) {
                    w.write(", ");
                }
                w.write(f3.typeShortName);
                w.write(" ");
                w.write(f3.name);
                seenOne = true;
            }
            w.write(") {\n");
            w.write("    " + this.tableNamingInfo.mainClassShortName() + " p = (" + this.tableNamingInfo.mainClassShortName() + ")get" + uniqueNonNullableField.capitalisedName + "Column().firstWhereEq(" + uniqueNonNullableField.name + ");\n");
            w.write("    if (p == null) {\n      p = (" + this.tableNamingInfo.mainClassShortName() + ")newPersistent();\n");
            for (FieldDef f3 : requiredFields) {
                w.write("      p.set");
                w.write(f3.capitalisedName);
                w.write("(");
                w.write(f3.name);
                w.write(");\n");
            }
            w.write("    }\n");
            w.write("    return (" + this.tableNamingInfo.mainClassShortName() + ")get" + uniqueNonNullableField.capitalisedName + "Column().ensure(p);\n");
            w.write("  }\n");
        }
        w.write("}\n");
    }

    private boolean ambiguous(String packageName) {
        TableNamingInfo tni = this.dsd.tableNamingStore.tableInfoByTableOrPersistentFQName.get(packageName);
        if (tni == null) {
            return false;
        }
        return tni.hidden || tni.hidesOther;
    }

    public void generateTableJava(Writer w) throws IOException {
        w.write("import " + this.tableNamingInfo.tableBaseClassFQName() + ";\n");
        w.write("import org.melati.poem.DefinitionSource;\n");
        w.write("import org.melati.poem.Database;\n");
        w.write("import org.melati.poem.PoemException;\n");
        w.write("\n/**\n * Melati POEM generated, programmer modifiable stub \n * for a <code>" + this.tableNamingInfo.tableMainClassShortName() + "</code> object.\n" + (this.description != null ? " * <p>\n * Description: \n" + DSD.javadocFormat(1, 3, this.description + (this.description.lastIndexOf(".") != this.description.length() - 1 ? "." : "")) + " * </p>\n" : "") + " *\n");
        w.write(this.fieldSummaryTable());
        w.write(" * \n * See org.melati.poem.prepro.TableDef#generateTableJava \n */\n");
        w.write("public class " + this.tableNamingInfo.tableMainClassShortName() + "<T extends " + this.tableNamingInfo.mainClassShortName() + "> extends " + this.tableNamingInfo.tableBaseClassShortName() + "<" + this.tableNamingInfo.mainClassShortName() + "> {\n");
        Object o = new Object(){

            public String toString() {
                return "\n /**\n  * Constructor.\n  * \n  * See org.melati.poem.prepro.TableDef#generateTableJava \n  * @param database          the POEM database we are using\n  * @param name              the name of this <code>Table</code>\n  * @param definitionSource  which definition is being used\n  * @throws PoemException    if anything goes wrong\n  */\n";
            }
        };
        w.write(o.toString());
        w.write("  public " + this.tableNamingInfo.tableMainClassShortName() + "(\n" + "      Database database, String name,\n" + "      DefinitionSource definitionSource)" + " throws PoemException {\n" + "    super(database, name, definitionSource);\n" + "  }\n" + "\n" + "  // programmer's domain-specific code here\n" + "}\n");
    }

    public void generateJava() throws IOException, IllegalityException {
        int i;
        String fqKey;
        TableNamingInfo targetTable;
        String key;
        boolean hasDisplayLevel = false;
        boolean hasSearchability = false;
        boolean needSelectionImports = false;
        for (TableDef tableDef : this.dsd.tablesInDatabase) {
            if (tableDef.isAbstract || tableDef.superclass != null) continue;
            for (FieldDef f : tableDef.fields) {
                ReferenceFieldDef rfd;
                if (!(f instanceof ReferenceFieldDef) || (rfd = (ReferenceFieldDef)f).getTargetTableNamingInfo() == null || !rfd.getTargetTableNamingInfo().mainClassFQName().equals(this.tableNamingInfo.mainClassFQName())) continue;
                needSelectionImports = true;
                this.addImport(rfd.table.tableNamingInfo.mainClassFQName(), "persistent");
            }
        }
        if (needSelectionImports) {
            this.addImport("org.melati.poem.CachedSelection", "persistent");
            this.addImport("org.melati.poem.util.EmptyEnumeration", "persistent");
            this.addImport("java.util.Enumeration", "persistent");
            this.addImport("java.util.List", "persistent");
            this.addImport("java.util.Collections", "persistent");
        }
        int fieldCount = 0;
        Enumeration<FieldDef> enumeration = this.fields.elements();
        while (enumeration.hasMoreElements()) {
            ++fieldCount;
            FieldDef f = enumeration.nextElement();
            if (f.displayLevel != null) {
                hasDisplayLevel = true;
            }
            if (f.searchability == null) continue;
            hasSearchability = true;
        }
        if (fieldCount == 0 && !this.isAbstract && this.tableNamingInfo.superclass == null) {
            throw new NonAbstractEmptyTableException(this.name);
        }
        if (!this.isAbstract) {
            this.addImport("org.melati.poem.JdbcPersistent", "table");
        }
        if (hasDisplayLevel) {
            this.addImport("org.melati.poem.DisplayLevel", "table");
        }
        if (hasSearchability) {
            this.addImport("org.melati.poem.Searchability", "table");
        }
        this.addImport(this.tableNamingInfo.objectFQName, "table");
        if (this.definesColumns) {
            this.addImport("org.melati.poem.Column", "both");
            this.addImport("org.melati.poem.Field", "both");
        }
        if (this.tableNamingInfo.superclassMainUnambiguous().equals("JdbcPersistent")) {
            this.addImport("org.melati.poem.JdbcPersistent", "persistent");
        } else {
            this.addImport(this.tableNamingInfo.superclassMainFQName(), "persistent");
        }
        this.addImport(this.tableNamingInfo.tableMainClassFQName(), "persistent");
        this.addImport(this.dsd.packageName + "." + this.dsd.databaseTablesClassName, "persistent");
        this.addImport("org.melati.poem.Database", "table");
        this.addImport("org.melati.poem.DefinitionSource", "table");
        this.addImport("org.melati.poem.PoemException", "table");
        if (!this.isAbstract && this.definesColumns) {
            this.addImport("org.melati.poem.Persistent", "table");
        }
        if (this.tableNamingInfo.superclassTableUnambiguous().equals("Table")) {
            this.addImport("org.melati.poem.Table", "table");
        } else {
            this.addImport(this.tableNamingInfo.superclassTableFQName(), "table");
        }
        this.addImport(this.dsd.packageName + "." + this.dsd.databaseTablesClassName, "table");
        this.addImport(this.tableNamingInfo.mainClassFQName(), "persistent");
        Enumeration<String> enumeration2 = this.imports.keys();
        while (enumeration2.hasMoreElements()) {
            key = enumeration2.nextElement();
            if (key.indexOf(".") != -1) continue;
            targetTable = this.dsd.tableNamingStore.tableInfoByPersistentShortName.get(key);
            if (targetTable == null) {
                throw new RuntimeException("No TableNamingInfo for " + key + ". This is probably a typo either in the table definition name or in a reference field.");
            }
            fqKey = targetTable.objectFQName;
            String destination = this.imports.get(key);
            this.imports.remove(key);
            this.addImport(fqKey, destination);
        }
        Enumeration<String> enumeration3 = this.imports.keys();
        while (enumeration3.hasMoreElements()) {
            key = enumeration3.nextElement();
            if (key.indexOf(".") == -1) {
                targetTable = this.dsd.tableNamingStore.tableInfoByPersistentShortName.get(key);
                fqKey = targetTable.objectFQName;
            } else {
                fqKey = key;
            }
            String destination = this.imports.get(key);
            if (destination == "table") {
                this.tableBaseImports.addElement(fqKey);
                continue;
            }
            if (destination == "persistent") {
                this.persistentBaseImports.addElement(fqKey);
                continue;
            }
            this.tableBaseImports.addElement(fqKey);
            this.persistentBaseImports.addElement(fqKey);
        }
        Object[] objectArray = this.tableBaseImports.toArray();
        Object[] p = this.persistentBaseImports.toArray();
        Arrays.sort(objectArray);
        Arrays.sort(p);
        this.tableBaseImports.removeAllElements();
        this.persistentBaseImports.removeAllElements();
        for (i = 0; i < objectArray.length; ++i) {
            this.tableBaseImports.addElement((String)objectArray[i]);
        }
        for (i = 0; i < p.length; ++i) {
            this.persistentBaseImports.addElement((String)p[i]);
        }
        this.dsd.createJava(this.tableNamingInfo.baseClassShortName(), new Generator(){

            @Override
            public void process(Writer w) throws IOException {
                TableDef.this.this_.generatePersistentBaseJava(w);
            }
        }, true);
        this.dsd.createJava(this.tableNamingInfo.mainClassShortName(), new Generator(){

            @Override
            public void process(Writer w) throws IOException {
                TableDef.this.this_.generatePersistentJava(w);
            }
        }, false);
        this.dsd.createJava(this.tableNamingInfo.tableBaseClassShortName(), new Generator(){

            @Override
            public void process(Writer w) throws IOException {
                TableDef.this.this_.generateTableBaseJava(w);
            }
        }, true);
        this.dsd.createJava(this.tableNamingInfo.tableMainClassShortName(), new Generator(){

            @Override
            public void process(Writer w) throws IOException {
                TableDef.this.this_.generateTableJava(w);
            }
        }, false);
    }

    String fieldSummaryTable() {
        StringBuffer table = new StringBuffer();
        table.append(" * \n * <table> \n * <caption>\n * Field summary for SQL table <code>" + this.nameFromDsd + "</code>\n" + " * </caption>\n" + " * <tr><th>Name</th><th>Type</th><th>Description</th></tr>\n");
        Enumeration<FieldDef> f = this.fields.elements();
        while (f.hasMoreElements()) {
            FieldDef fd = f.nextElement();
            table.append(DSD.javadocFormat(1, 1, "<tr><td> " + fd.name + " </td><td> " + fd.typeShortName + " </td><td> " + (fd.description != null ? fd.description : "&nbsp;") + " </td></tr>"));
        }
        table.append(" * </table> \n");
        return table.toString();
    }
}

