/*
 * Decompiled with CFR 0.152.
 */
package org.melati.poem.prepro;

import java.io.IOException;
import java.io.StreamTokenizer;
import org.melati.poem.prepro.DSD;
import org.melati.poem.prepro.FieldDef;
import org.melati.poem.prepro.FieldQualifier;
import org.melati.poem.prepro.IllegalityException;
import org.melati.poem.prepro.ParsingDSDException;
import org.melati.poem.prepro.ReferenceFieldDef;
import org.melati.poem.prepro.StringKeyReferenceFieldDef;

public class IntegrityfixFieldQualifier
extends FieldQualifier {
    private String integrityfix;

    public IntegrityfixFieldQualifier(StreamTokenizer tokens) throws ParsingDSDException, IOException {
        DSD.expect(tokens, '=');
        tokens.nextToken();
        if (tokens.ttype != -3) {
            throw new ParsingDSDException("<integrity fix name>", tokens);
        }
        this.integrityfix = this.validIntegrityFixNamed(tokens.sval);
        tokens.nextToken();
    }

    private String validIntegrityFixNamed(String sval) {
        if (sval.equals("delete") || sval.equals("clear") || sval.equals("prevent")) {
            return sval;
        }
        throw new ParsingDSDException("<integrity fix name>: one of delete, clear or prevent", sval);
    }

    @Override
    public void apply(FieldDef field) throws IllegalityException {
        if (field instanceof ReferenceFieldDef) {
            ((ReferenceFieldDef)field).setIntegrityFix(this.integrityfix);
        } else if (field instanceof StringKeyReferenceFieldDef) {
            ((StringKeyReferenceFieldDef)field).setIntegrityFix(this.integrityfix);
        } else {
            throw new ApplicationException(field);
        }
    }

    public static class ApplicationException
    extends IllegalityException {
        private static final long serialVersionUID = 1L;

        ApplicationException(FieldDef field) {
            this.field = field;
            this.lineNumber = field.lineNumber;
            this.message = "The column " + field + " cannot have an `integrityfix' because that only applies to references";
        }
    }
}

