/*
 * Decompiled with CFR 0.152.
 */
package org.melati.poem.prepro;

import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.Writer;
import java.util.Vector;
import org.melati.poem.prepro.BigDecimalFieldDef;
import org.melati.poem.prepro.BinaryFieldDef;
import org.melati.poem.prepro.BooleanFieldDef;
import org.melati.poem.prepro.ColumnTypeFieldDef;
import org.melati.poem.prepro.DSD;
import org.melati.poem.prepro.DateFieldDef;
import org.melati.poem.prepro.DisplayLevelFieldDef;
import org.melati.poem.prepro.DoubleFieldDef;
import org.melati.poem.prepro.FieldQualifier;
import org.melati.poem.prepro.IllegalityException;
import org.melati.poem.prepro.IntegerFieldDef;
import org.melati.poem.prepro.IntegrityFixFieldDef;
import org.melati.poem.prepro.LongFieldDef;
import org.melati.poem.prepro.ParsingDSDException;
import org.melati.poem.prepro.PasswordFieldDef;
import org.melati.poem.prepro.ReferenceFieldDef;
import org.melati.poem.prepro.SearchabilityFieldDef;
import org.melati.poem.prepro.StringFieldDef;
import org.melati.poem.prepro.StringKeyReferenceFieldDef;
import org.melati.poem.prepro.StringUtils;
import org.melati.poem.prepro.TableDef;
import org.melati.poem.prepro.TimeFieldDef;
import org.melati.poem.prepro.TimestampFieldDef;

public abstract class FieldDef {
    protected final TableDef table;
    protected final String name;
    protected final String capitalisedName;
    protected int displayOrder;
    String displayName;
    String description;
    protected final String typeShortName;
    protected final String rawType;
    protected final Vector<FieldQualifier> fieldQualifiers;
    final String shortestUnambiguousClassname;
    final String rootTableAccessorMethod;
    protected String displayLevel = null;
    protected String searchability = null;
    private boolean sortDescending = false;
    int displayOrderPriority = -1;
    private boolean isNullable = false;
    private boolean isTroidColumn = false;
    private boolean isDeletedColumn = false;
    private boolean isEditable = true;
    private boolean isCreateable = true;
    private boolean isIndexed = false;
    private boolean isUnique = false;
    boolean isCompareOnly = false;
    private int width = -1;
    private int height = -1;
    String renderinfo = null;
    protected int lineNumber;

    public FieldDef(int lineNo, TableDef table, String name, String type, String rawType, int displayOrder, Vector<FieldQualifier> qualifiers) throws IllegalityException {
        this.lineNumber = lineNo;
        this.table = table;
        this.name = name;
        this.displayOrder = displayOrder;
        this.capitalisedName = StringUtils.capitalised(name);
        this.typeShortName = type;
        this.rawType = rawType;
        this.fieldQualifiers = qualifiers;
        this.shortestUnambiguousClassname = table.tableNamingInfo.mainClassUnambiguous();
        this.rootTableAccessorMethod = table.tableNamingInfo.rootTableAccessorName();
        for (int q = 0; q < qualifiers.size(); ++q) {
            qualifiers.elementAt(q).apply(this);
        }
    }

    public String toString() {
        return this.table.name + "." + this.name + " (" + (this.isNullable ? "nullable " : "") + this.typeShortName + ")";
    }

    private static void readFieldQualifiers(Vector<FieldQualifier> qualifiers, StreamTokenizer tokens) throws ParsingDSDException, IOException {
        while (tokens.ttype == 40) {
            tokens.nextToken();
            qualifiers.addElement(FieldQualifier.from(tokens));
            DSD.expect(tokens, ')');
            tokens.nextToken();
        }
    }

    public static FieldDef from(TableDef table, StreamTokenizer tokens, int displayOrder) throws ParsingDSDException, IOException, IllegalityException {
        table.addImport("org.melati.poem.AccessPoemException", "both");
        table.addImport("org.melati.poem.ValidationPoemException", "table");
        table.addImport("org.melati.poem.Persistent", "table");
        table.definesColumns = true;
        Vector<FieldQualifier> qualifiers = new Vector<FieldQualifier>();
        FieldDef.readFieldQualifiers(qualifiers, tokens);
        if (tokens.ttype != -3) {
            throw new ParsingDSDException("<field type>", tokens);
        }
        String type = tokens.sval;
        if (type.equals("byte")) {
            if (tokens.nextToken() != 91 || tokens.nextToken() != 93) {
                throw new ParsingDSDException("[", tokens);
            }
            type = "byte[]";
        }
        if (tokens.nextToken() != -3) {
            throw new ParsingDSDException("<field name>", tokens);
        }
        String name = tokens.sval;
        String targetKeyName = null;
        boolean stringKeyReference = false;
        if (name.equals("StringKeyReference")) {
            stringKeyReference = true;
            if (tokens.nextToken() != -3) {
                throw new ParsingDSDException("keyword 'on'", tokens);
            }
            if (!tokens.sval.equals("on")) {
                throw new ParsingDSDException("keyword 'on'", tokens);
            }
            if (tokens.nextToken() != -3) {
                throw new ParsingDSDException("<target key field name>", tokens);
            }
            targetKeyName = tokens.sval;
            if (tokens.nextToken() != -3) {
                throw new ParsingDSDException("<target key field name>", tokens);
            }
            name = tokens.sval;
        }
        tokens.nextToken();
        FieldDef.readFieldQualifiers(qualifiers, tokens);
        DSD.expect(tokens, ';');
        int lineNo = tokens.lineno();
        if (type.equals("Integer")) {
            return new IntegerFieldDef(lineNo, table, name, displayOrder, qualifiers);
        }
        if (type.equals("Long")) {
            return new LongFieldDef(lineNo, table, name, displayOrder, qualifiers);
        }
        if (type.equals("Double")) {
            return new DoubleFieldDef(lineNo, table, name, displayOrder, qualifiers);
        }
        if (type.equals("Boolean")) {
            return new BooleanFieldDef(lineNo, table, name, displayOrder, qualifiers);
        }
        if (type.equals("String")) {
            return new StringFieldDef(lineNo, table, name, displayOrder, qualifiers);
        }
        if (type.equals("Password")) {
            return new PasswordFieldDef(lineNo, table, name, displayOrder, qualifiers);
        }
        if (type.equals("Date")) {
            return new DateFieldDef(lineNo, table, name, displayOrder, qualifiers);
        }
        if (type.equals("Timestamp")) {
            return new TimestampFieldDef(lineNo, table, name, displayOrder, qualifiers);
        }
        if (type.equals("Time")) {
            return new TimeFieldDef(lineNo, table, name, displayOrder, qualifiers);
        }
        if (type.equals("ColumnType")) {
            return new ColumnTypeFieldDef(lineNo, table, name, displayOrder, qualifiers);
        }
        if (type.equals("DisplayLevel")) {
            return new DisplayLevelFieldDef(lineNo, table, name, displayOrder, qualifiers);
        }
        if (type.equals("Searchability")) {
            return new SearchabilityFieldDef(lineNo, table, name, displayOrder, qualifiers);
        }
        if (type.equals("IntegrityFix")) {
            return new IntegrityFixFieldDef(lineNo, table, name, displayOrder, qualifiers);
        }
        if (type.equals("BigDecimal")) {
            return new BigDecimalFieldDef(lineNo, table, name, displayOrder, qualifiers);
        }
        if (type.equals("byte[]")) {
            return new BinaryFieldDef(lineNo, table, name, displayOrder, qualifiers);
        }
        if (stringKeyReference) {
            return new StringKeyReferenceFieldDef(lineNo, table, name, targetKeyName, displayOrder, type, qualifiers);
        }
        return new ReferenceFieldDef(lineNo, table, name, displayOrder, type, qualifiers);
    }

    public void generateBaseMethods(Writer w) throws IOException {
        w.write("\n /**\n  * Retrieves the <code>" + this.capitalisedName + "</code> value, without locking, \n" + "  * for this <code>" + this.table.nameFromDsd + "</code> <code>Persistent</code>.\n" + "  *\n" + "  * see org.melati.poem.prepro.FieldDef#generateBaseMethods \n" + "  * @return the " + this.rawType + " " + this.name + "\n" + "  */\n");
        w.write("  public " + this.rawType + " get" + this.capitalisedName + "_unsafe() {\n" + "    return " + this.name + ";\n" + "  }\n" + "\n");
        w.write("\n /**\n  * Sets the <code>" + this.capitalisedName + "</code> value directly, without checking, \n" + "  * for this " + this.table.nameFromDsd + " <code>Persistent</code>.\n" + "  * \n" + "  * see org.melati.poem.prepro.FieldDef#generateBaseMethods \n" + "  * @param cooked  the pre-validated value to set\n" + "  */\n");
        w.write("  public void set" + this.capitalisedName + "_unsafe(" + this.rawType + " cooked) {\n" + "    " + this.name + " = cooked;\n" + "  }\n");
    }

    public void generateFieldCreator(Writer w) throws IOException {
        w.write("\n /**\n  * Retrieves the <code>" + this.capitalisedName + "</code> value as a <code>Field</code>\n" + "  * from this <code>" + this.table.nameFromDsd + "</code> <code>Persistent</code>.\n" + "  * \n" + "  * see org.melati.poem.prepro.FieldDef#generateFieldCreator \n" + "  * @throws AccessPoemException \n" + "  *         if the current <code>AccessToken</code> \n" + "  *         does not confer write access rights\n" + "  * @return the " + this.rawType + " " + this.name + "\n" + "  */\n");
        w.write("  public Field<" + this.rawType + "> get" + this.capitalisedName + "Field() throws AccessPoemException {\n" + "    Column<" + this.rawType + "> c = _" + this.rootTableAccessorMethod + "()." + "get" + this.capitalisedName + "Column();\n" + "    return new Field<" + this.rawType + ">((" + this.rawType + ")c.getRaw(this), c);\n" + "  }\n");
    }

    public abstract void generateJavaDeclaration(Writer var1) throws IOException;

    public void generateColDecl(Writer w) throws IOException {
        w.write("Column<" + this.rawType + "> col_" + this.name);
    }

    public void generateColAccessor(Writer w) throws IOException {
        w.write("\n /**\n  * Retrieves the <code>" + this.capitalisedName + "</code> <code>Column</code> for this \n" + "  * <code>" + this.table.nameFromDsd + "</code> <code>Table</code>.\n" + "  * \n" + "  * see org.melati.poem.prepro.FieldDef#generateColAccessor \n" + "  * @return the " + this.name + " <code>Column</code>\n" + "  */\n");
        w.write("  public final Column<" + this.rawType + "> get" + this.capitalisedName + "Column() {\n" + "    return col_" + this.name + ";\n" + "  }\n");
    }

    protected void generateColRawAccessors(Writer w) throws IOException {
        w.write("          public Object getRaw_unsafe(Persistent g)\n              throws AccessPoemException {\n            return ((" + this.shortestUnambiguousClassname + ")g)." + "get" + this.capitalisedName + "_unsafe();\n" + "          }\n" + "\n");
        w.write("          public void setRaw_unsafe(Persistent g, Object raw)\n              throws AccessPoemException {\n            ((" + this.shortestUnambiguousClassname + ")g).set" + this.capitalisedName + "_unsafe((" + this.rawType + ")raw);\n" + "          }\n");
    }

    public void generateColDefinition(Writer w) throws IOException {
        w.write("    defineColumn(col_" + this.name + " =\n" + "        new Column<" + this.rawType + ">(this, \"" + this.name + "\",\n" + "                   " + this.poemTypeJava() + ",\n" + "                   DefinitionSource.dsd) { \n" + "          public Object getCooked(Persistent g)\n" + "              throws AccessPoemException, PoemException {\n" + "            return ((" + this.shortestUnambiguousClassname + ")g).get" + this.capitalisedName + "();\n" + "          }\n" + "\n" + "          public void setCooked(Persistent g, Object cooked)\n" + "              throws AccessPoemException, ValidationPoemException {\n" + "            ((" + this.shortestUnambiguousClassname + ")g).set" + this.capitalisedName + "((" + this.typeShortName + ")cooked);\n" + "          }\n" + "\n" + "          public Field<" + this.rawType + "> asField(Persistent g) {\n" + "            return ((" + this.shortestUnambiguousClassname + ")g).get" + this.capitalisedName + "Field();\n" + "          }\n" + "\n");
        if (this.isTroidColumn || !this.isEditable) {
            w.write("          public boolean defaultUserEditable() {\n            return false;\n          }\n\n");
        }
        if (this.isTroidColumn || !this.isCreateable) {
            w.write("          public boolean defaultUserCreateable() {\n            return false;\n          }\n\n");
        }
        if (this.displayLevel != null) {
            w.write("          public DisplayLevel defaultDisplayLevel() {\n            return DisplayLevel." + this.displayLevel + ";\n" + "          }\n" + "\n");
        }
        if (this.searchability != null) {
            w.write("          public Searchability defaultSearchability() {\n            return Searchability." + this.searchability + ";\n" + "          }\n" + "\n");
        }
        if (this.displayOrderPriority != -1) {
            w.write("          public Integer defaultDisplayOrderPriority() {\n            return new Integer(" + this.displayOrderPriority + ");\n" + "          }\n" + "\n");
        }
        if (this.sortDescending) {
            w.write("          public boolean defaultSortDescending() {\n            return true;\n          }\n\n");
        }
        if (this.displayName != null) {
            w.write("          public String defaultDisplayName() {\n            return " + StringUtils.quoted(this.displayName, '\"') + ";\n" + "          }\n" + "\n");
        }
        w.write("          public int defaultDisplayOrder() {\n            return " + this.displayOrder + ";\n" + "          }\n" + "\n");
        if (this.description != null) {
            w.write("          public String defaultDescription() {\n            return " + StringUtils.quoted(this.description, '\"') + ";\n" + "          }\n" + "\n");
        }
        if (this.isIndexed) {
            w.write("          public boolean defaultIndexed() {\n            return true;\n          }\n\n");
        }
        if (this.isUnique) {
            w.write("          public boolean defaultUnique() {\n            return true;\n          }\n\n");
        }
        if (this.width != -1) {
            w.write("          public int defaultWidth() {\n            return " + this.width + ";\n" + "          }\n" + "\n");
        }
        if (this.height != -1) {
            w.write("          public int defaultHeight() {\n            return " + this.height + ";\n" + "          }\n" + "\n");
        }
        if (this.renderinfo != null) {
            w.write("          public String defaultRenderinfo() {\n            return " + StringUtils.quoted(this.renderinfo, '\"') + ";\n" + "          }\n" + "\n");
        }
        this.generateColRawAccessors(w);
        w.write("        });\n");
    }

    public abstract String poemTypeJava();

    public boolean isDeletedColumn() {
        return this.isDeletedColumn;
    }

    public void setDeletedColumn(boolean isDeletedColumn) {
        if (this.isDeletedColumn) {
            throw new IllegalityException(this.lineNumber, "Deleted qualifier already set true.");
        }
        this.isDeletedColumn = isDeletedColumn;
    }

    public boolean isTroidColumn() {
        return this.isTroidColumn;
    }

    public void setTroidColumn(boolean isTroidColumn) {
        if (this.isTroidColumn) {
            throw new IllegalityException(this.lineNumber, "Troid qualifier  already set true.");
        }
        this.isTroidColumn = isTroidColumn;
    }

    public boolean isNullable() {
        return this.isNullable;
    }

    public void setNullable(boolean isNullable) {
        if (this.isNullable) {
            throw new IllegalityException(this.lineNumber, "Nullable qualifier  already set true.");
        }
        this.isNullable = isNullable;
    }

    public boolean isEditable() {
        return this.isEditable;
    }

    public void setEditable(boolean isEditable) {
        if (!this.isEditable) {
            throw new IllegalityException(this.lineNumber, "Editable qualifier  already set true.");
        }
        this.isEditable = isEditable;
    }

    public boolean isSortDescending() {
        return this.sortDescending;
    }

    public void setSortDescending(boolean sortDescending) {
        if (this.sortDescending) {
            throw new IllegalityException(this.lineNumber, "Sort descending qualifier  already set true.");
        }
        this.sortDescending = sortDescending;
    }

    public boolean isCreateable() {
        return this.isCreateable;
    }

    public void setCreateable(boolean isCreateable) {
        if (!this.isCreateable) {
            throw new IllegalityException(this.lineNumber, "Creatable qualifier  already set true.");
        }
        this.isCreateable = isCreateable;
    }

    public boolean isIndexed() {
        return this.isIndexed;
    }

    public void setIndexed(boolean isIndexed) {
        if (this.isIndexed) {
            throw new IllegalityException(this.lineNumber, "Indexed qualifier  already set true.");
        }
        this.isIndexed = isIndexed;
    }

    public boolean isUnique() {
        return this.isUnique;
    }

    public void setUnique(boolean isUnique) {
        if (this.isUnique) {
            throw new IllegalityException(this.lineNumber, "Unique qualifier  already set true.");
        }
        this.isUnique = isUnique;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        if (this.width != -1) {
            throw new IllegalityException(this.lineNumber, "Size already set to " + this.width + " cannot overwrite with " + width);
        }
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        if (this.height != -1) {
            throw new IllegalityException(this.lineNumber, "Height already set to " + this.width + " cannot overwrite with " + this.width);
        }
        this.height = height;
    }
}

