/*
 * Decompiled with CFR 0.152.
 */
package org.melati.poem.prepro;

import java.io.IOException;
import java.io.StreamTokenizer;
import org.melati.poem.prepro.DSD;
import org.melati.poem.prepro.ParsingDSDException;
import org.melati.poem.prepro.TableDef;
import org.melati.poem.prepro.TableQualifier;

public class CacheSizeTableQualifier
extends TableQualifier {
    static final int DEFAULT = -1;
    static final int UNLIMITED = -2;
    private int size;

    public CacheSizeTableQualifier(StreamTokenizer tokens) throws ParsingDSDException, IOException {
        DSD.expect(tokens, '=');
        tokens.nextToken();
        if (tokens.ttype == -3 && tokens.sval.equals("unlimited")) {
            this.size = -2;
        } else {
            if (tokens.ttype != -2 || (int)tokens.nval < 0) {
                throw new ParsingDSDException("<nonnegative size number>", tokens);
            }
            this.size = (int)tokens.nval;
        }
        tokens.nextToken();
    }

    public void apply(TableDef table) {
        table.cacheSize = this.size;
    }
}

