/*
 * Decompiled with CFR 0.152.
 */
package org.melati.poem.prepro;

import java.io.IOException;
import java.io.StreamTokenizer;
import org.melati.poem.prepro.BinaryFieldDef;
import org.melati.poem.prepro.DSD;
import org.melati.poem.prepro.FieldDef;
import org.melati.poem.prepro.FieldQualifier;
import org.melati.poem.prepro.ParsingDSDException;
import org.melati.poem.prepro.SizeApplicationException;
import org.melati.poem.prepro.StringFieldDef;
import org.melati.poem.prepro.StringKeyReferenceFieldDef;

public class SizeFieldQualifier
extends FieldQualifier {
    private int size;

    public SizeFieldQualifier(StreamTokenizer tokens) throws ParsingDSDException, IOException {
        DSD.expect(tokens, '=');
        tokens.nextToken();
        if (tokens.ttype == -3 && tokens.sval.equals("unlimited")) {
            this.size = -1;
        } else {
            if (tokens.ttype != -2 || (int)tokens.nval <= 0) {
                throw new ParsingDSDException("<positive size number>", tokens);
            }
            this.size = (int)tokens.nval;
        }
        tokens.nextToken();
    }

    public void apply(FieldDef field) throws SizeApplicationException {
        if (field instanceof StringFieldDef) {
            ((StringFieldDef)field).setSize(this.size);
        } else if (field instanceof BinaryFieldDef) {
            ((BinaryFieldDef)field).setSize(this.size);
        } else if (field instanceof StringKeyReferenceFieldDef) {
            ((StringKeyReferenceFieldDef)field).setSize(this.size);
        } else {
            throw new SizeApplicationException(field);
        }
    }
}

