/*
 * Decompiled with CFR 0.152.
 */
package org.melati.poem.prepro;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.io.Writer;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;
import org.melati.poem.prepro.Generator;
import org.melati.poem.prepro.IllegalityException;
import org.melati.poem.prepro.ParsingDSDException;
import org.melati.poem.prepro.ResourceNotFoundException;
import org.melati.poem.prepro.StringUtils;
import org.melati.poem.prepro.TableDef;
import org.melati.poem.prepro.TableNamingStore;
import org.melati.poem.prepro.TargetExistsDSDException;

public class DSD {
    static final String NAG_BLOCK = "  // programmer's domain-specific code here\n  // Don't forget to delete first line to prevent overwriting\n";
    static final String autogenStamp = "// Do not edit this file!  It was generated by Melati POEM's DSD preprocessor.";
    static final String deleteMe = "// Delete this line to prevent overwriting of this file";
    private final Vector<String> packageComponents = new Vector();
    final String packageName;
    private final File dsdFile;
    private final File dsdDir;
    private final File dsdDirGen;
    private final String name;
    final String databaseClassName;
    final String databaseBaseClassName;
    final String databaseTablesClassName;
    final String databaseTablesBaseClassName;
    final String projectName;
    TableNamingStore tableNamingStore;
    final Vector<TableDef> tablesInPackage = new Vector();
    final Vector<TableDef> tablesInDatabase = new Vector();
    final Vector<DSD> importedDSDs = new Vector();
    public boolean hasAnExtenedTable;

    static void expect(StreamTokenizer tokens, String what) throws ParsingDSDException {
        if (tokens.ttype != -3 || !tokens.sval.equals(what)) {
            throw new ParsingDSDException(what, tokens);
        }
    }

    static void expect(StreamTokenizer tokens, char what) throws ParsingDSDException {
        if (tokens.ttype != what) {
            throw new ParsingDSDException("" + what, tokens);
        }
    }

    public DSD(String file) throws IOException, ParsingDSDException, IllegalityException, ResourceNotFoundException {
        this(file, new TableNamingStore(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DSD(String file, TableNamingStore names, boolean includePoem) throws ResourceNotFoundException, ParsingDSDException, IllegalityException, IOException {
        this.tableNamingStore = names;
        this.dsdFile = new File(file);
        String dsdFileName = this.dsdFile.getName();
        int dot = dsdFileName.lastIndexOf(46);
        this.name = dot == -1 ? dsdFileName : dsdFileName.substring(0, dot);
        this.projectName = StringUtils.capitalised(this.name);
        this.databaseClassName = this.projectName + "Database";
        this.databaseBaseClassName = this.projectName + "DatabaseBase";
        this.databaseTablesClassName = this.projectName + "DatabaseTables";
        this.databaseTablesBaseClassName = this.projectName + "DatabaseTablesBase";
        this.dsdDir = new File(new File(this.dsdFile.getAbsolutePath()).getParent());
        this.dsdDirGen = new File(this.dsdDir.getAbsolutePath() + File.separator + "generated");
        if (includePoem && !"Poem".equals(this.projectName)) {
            DSD poemDSD = new DSD(this.filePath("org.melati.poem.Poem.dsd"), this.tableNamingStore, false);
            Vector<TableDef> poemTables = poemDSD.tablesInPackage;
            for (int i = 0; i < poemTables.size(); ++i) {
                this.tablesInDatabase.addElement(poemTables.elementAt(i));
            }
        }
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(file));
        }
        catch (FileNotFoundException e) {
            if (file.indexOf("!") != -1) {
                String resourceName = file.substring(file.indexOf("!") + 2);
                reader = new BufferedReader(new InputStreamReader(Thread.currentThread().getContextClassLoader().getResourceAsStream(resourceName)));
            }
            throw e;
        }
        try {
            StreamTokenizer tokens = new StreamTokenizer(reader);
            tokens.slashSlashComments(true);
            tokens.slashStarComments(true);
            tokens.wordChars(95, 95);
            tokens.nextToken();
            DSD.expect(tokens, "package");
            StringBuffer packageBuffer = new StringBuffer();
            while (true) {
                if (tokens.nextToken() != -3) {
                    throw new ParsingDSDException("<package component>", tokens);
                }
                this.packageComponents.addElement(tokens.sval);
                packageBuffer.append(tokens.sval);
                if (tokens.nextToken() != 46) break;
                packageBuffer.append('.');
            }
            this.packageName = packageBuffer.toString();
            DSD.expect(tokens, ';');
            tokens.nextToken();
            while (tokens.ttype != -1 && tokens.sval.equals("import")) {
                if (tokens.nextToken() != -3) {
                    throw new ParsingDSDException("<import component>", tokens);
                }
                String importDSD = tokens.sval;
                tokens.nextToken();
                DSD.expect(tokens, ';');
                tokens.nextToken();
                DSD dsd = new DSD(this.filePath(importDSD), this.tableNamingStore, false);
                this.importedDSDs.addElement(dsd);
                Vector<TableDef> packageTables = dsd.tablesInPackage;
                for (int i = 0; i < packageTables.size(); ++i) {
                    this.tablesInDatabase.addElement(packageTables.elementAt(i));
                }
            }
            int t = 0;
            while (tokens.ttype != -1) {
                boolean isAbstract;
                if (tokens.ttype != -3) {
                    throw new ParsingDSDException("table", tokens);
                }
                if (tokens.sval.equals("abstract")) {
                    isAbstract = true;
                    tokens.nextToken();
                } else {
                    isAbstract = false;
                }
                DSD.expect(tokens, "table");
                tokens.nextToken();
                TableDef table = new TableDef(this, tokens, t, isAbstract, this.tableNamingStore);
                this.tablesInPackage.addElement(table);
                this.tablesInDatabase.addElement(table);
                ++t;
            }
        }
        finally {
            ((Reader)reader).close();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void createJava(String nameP, Generator proc, boolean overwrite) throws IOException {
        if (!this.dsdDirGen.exists()) {
            this.dsdDirGen.mkdir();
        }
        File f = null;
        f = overwrite ? new File(this.dsdDirGen, nameP + ".java") : new File(this.dsdDir, nameP + ".java");
        if (f.exists()) {
            if (overwrite) {
                if (!this.containsText(f, autogenStamp)) throw new TargetExistsDSDException(f);
                System.err.println("Replacing " + f);
            } else {
                if (!this.containsText(f, deleteMe)) {
                    System.err.println("Leaving existing " + f);
                    return;
                }
                System.err.println("Replacing unmodified " + f);
            }
        } else {
            System.err.println("Creating " + f);
        }
        BufferedWriter w = new BufferedWriter(new FileWriter(f));
        try {
            if (overwrite) {
                w.write("// Do not edit this file!  It was generated by Melati POEM's DSD preprocessor.\n\n");
                w.write("package " + this.packageName + ".generated;\n");
            } else {
                w.write("// Delete this line to prevent overwriting of this file\n\n");
                w.write("package " + this.packageName + ";\n");
            }
            w.write("\n\n");
            proc.process(w);
        }
        catch (IOException e) {
            try {
                ((Writer)w).close();
            }
            catch (Exception ee2) {
                Object ee2 = null;
            }
            try {
                f.delete();
                throw e;
            }
            catch (Exception ee3) {
                Object ee3 = null;
            }
            throw e;
        }
        w.write("\n");
        ((Writer)w).close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean containsText(File file, String text) throws FileNotFoundException, IOException, TargetExistsDSDException {
        BufferedReader r = new BufferedReader(new FileReader(file));
        boolean found = true;
        try {
            String firstLine = r.readLine();
            if (firstLine != null && !firstLine.equals(text)) {
                found = false;
            }
        }
        finally {
            r.close();
        }
        return found;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void createPackageHTML(Generator proc, boolean overwrite) throws IOException {
        File f;
        block14: {
            f = null;
            f = overwrite ? new File(this.dsdDirGen, "package.html") : new File(this.dsdDir, "package.html");
            if (f.exists()) {
                if (overwrite) {
                    BufferedReader r = new BufferedReader(new FileReader(f));
                    try {
                        for (int i = 0; i < 8; ++i) {
                            r.readLine();
                        }
                        String ninthLine = r.readLine();
                        if (ninthLine == null || ninthLine.indexOf(autogenStamp) != -1) {
                            System.err.println("Replacing " + f);
                            break block14;
                        }
                        System.err.println(ninthLine);
                        throw new TargetExistsDSDException(f);
                    }
                    finally {
                        r.close();
                    }
                }
                System.err.println("Leaving existing " + f);
                return;
            }
            System.err.println("Creating " + f);
        }
        BufferedWriter w = new BufferedWriter(new FileWriter(f));
        try {
            w.write("<?xml version=\"1.0\" encoding=\"iso-8859-1\"?>\n<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\"\n   \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">\n<html xmlns=\"http://www.w3.org/1999/xhtml\">\n<head>\n <meta http-equiv=\"Content-Type\" content=\"text/html; charset=us-ascii\" />\n <title>" + this.packageName);
            if (overwrite) {
                w.write(".generated");
            }
            w.write("</title>\n</head>\n<!-- // Do not edit this file!  It was generated by Melati POEM's DSD preprocessor.-->\n<body>\n");
            proc.process(w);
            w.write("</body>\n</html>\n\n");
        }
        catch (IOException e) {
            try {
                ((Writer)w).close();
            }
            catch (Exception ee2) {
                Object ee2 = null;
            }
            try {
                f.delete();
            }
            catch (Exception ee3) {
                Object ee3 = null;
            }
            throw e;
        }
        w.write("\n");
        ((Writer)w).close();
    }

    void generateDatabaseBaseJava(Writer w) throws IOException {
        TableDef td;
        if (this.packageName.equals("org.melati.poem")) {
            w.write("import org.melati.poem.Database;\n");
        } else {
            w.write("import org.melati.poem.PoemDatabase;\n");
        }
        w.write("import org.melati.poem.DefinitionSource;\n");
        Enumeration<TableDef> t = this.tablesInDatabase.elements();
        while (t.hasMoreElements()) {
            td = t.nextElement();
            if (td.tableNamingInfo.hidden || td.isAbstract) continue;
            w.write(td.tableNamingInfo.importPersistentString());
            w.write(td.tableNamingInfo.importTableString());
        }
        w.write("\n/**\n * Melati POEM generated Database base class.\n */\n");
        w.write("public class " + this.databaseBaseClassName + " extends " + (this.packageName.equals("org.melati.poem") && this.name.equalsIgnoreCase("Poem") ? "Database" : "PoemDatabase") + " {\n\n");
        t = this.tablesInDatabase.elements();
        while (t.hasMoreElements()) {
            td = t.nextElement();
            if (td.tableNamingInfo.hidden) continue;
            td.generateTableDeclarationJava(w);
        }
        w.write("\n");
        if (this.hasAnExtenedTable) {
            w.write("  @SuppressWarnings({ \"unchecked\", \"rawtypes\" })\n");
        }
        w.write("  protected " + this.databaseBaseClassName + "() {\n");
        t = this.tablesInDatabase.elements();
        while (t.hasMoreElements()) {
            td = t.nextElement();
            if (td.tableNamingInfo.hidden) continue;
            td.generateTableDefinitionJava(w);
        }
        w.write("  }\n");
        t = this.tablesInDatabase.elements();
        while (t.hasMoreElements()) {
            td = t.nextElement();
            if (td.tableNamingInfo.hidden) continue;
            w.write(10);
            td.generateTableAccessorJava(w);
        }
        w.write("}\n\n");
    }

    void generateDatabaseJava(Writer w) throws IOException {
        w.write("import " + this.packageName + ".generated." + this.databaseBaseClassName + ";\n");
        w.write("\n/**\n * Melati POEM generated, programmer modifiable stub.\n */\n");
        w.write("public class " + this.databaseClassName + " extends " + this.databaseBaseClassName + "\n                            implements " + this.databaseTablesClassName);
        w.write(" {\n");
        w.write(NAG_BLOCK);
        w.write("}\n\n");
    }

    void generateDatabaseTablesBaseJava(Writer w) throws IOException {
        w.write("// " + this.tablesInDatabase.size() + " tables in database\n");
        Enumeration<TableDef> t = this.tablesInDatabase.elements();
        while (t.hasMoreElements()) {
            TableDef td = t.nextElement();
            if (td.isAbstract) {
                w.write("// abstract ");
            }
            if (td.tableNamingInfo.hidden) {
                w.write("// hidden ");
            }
            w.write(td.tableNamingInfo.importTableString());
            if (td.isAbstract) {
                w.write("// abstract ");
            }
            w.write(td.tableNamingInfo.importPersistentString());
        }
        for (int j = 0; j < this.importedDSDs.size(); ++j) {
            DSD dsd = this.importedDSDs.elementAt(j);
            w.write("import " + dsd.packageName + "." + dsd.databaseTablesClassName + ";\n");
        }
        w.write("\n/**\n * Melati POEM generated base interface to the tables in \n * " + this.packageName + ".\n" + " */\n");
        w.write("public interface " + this.databaseTablesBaseClassName);
        boolean first = true;
        Enumeration<Object> t2 = this.importedDSDs.elements();
        while (t2.hasMoreElements()) {
            DSD dsd = t2.nextElement();
            if (first) {
                w.write("\n                       extends " + dsd.databaseTablesClassName);
                first = false;
                continue;
            }
            w.write(",\n                               " + dsd.databaseTablesClassName);
        }
        w.write(" {\n\n");
        t2 = this.tablesInDatabase.elements();
        while (t2.hasMoreElements()) {
            TableDef td = (TableDef)t2.nextElement();
            if (td.tableNamingInfo.hidden) continue;
            td.generateTableAccessorDefnJava(w);
        }
        w.write("}\n\n");
    }

    void generateDatabaseTablesJava(Writer w) throws IOException {
        w.write("import " + this.packageName + ".generated." + this.databaseTablesBaseClassName + ";\n");
        w.write("\n/**\n * Melati POEM generated, programmer modifiable interface stub.\n */\n");
        w.write("public interface " + this.databaseTablesClassName + " extends " + this.databaseTablesBaseClassName + " {\n");
        w.write(NAG_BLOCK);
        w.write("}\n\n");
    }

    void generateProjectTableJava(Writer w) throws IOException {
        w.write("import org.melati.poem.JdbcTable;\n");
        w.write("import org.melati.poem.DefinitionSource;\n");
        w.write("import org.melati.poem.Database;\n");
        w.write("import org.melati.poem.Persistent;\n");
        w.write("import org.melati.poem.PoemException;\n");
        w.write("\n/**\n * Melati POEM generated, programmer modifiable inheritance hook.\n */\n");
        w.write("public class " + this.getProjectTableClassName() + "<P extends Persistent> extends JdbcTable<P> {\n");
        w.write("\n /**\n  * Constructor. \n  * \n  * @see org.melati.poem.prepro.DSD#generateProjectTableJava \n  * @param database          the POEM database we are using\n  * @param name              the name of this <code>Table</code>\n  * @param definitionSource  which definition is being used\n  * @throws PoemException    if anything goes wrong\n  */\n");
        w.write("\n  public " + this.getProjectTableClassName() + "(\n" + "      Database database, String name,\n" + "      DefinitionSource definitionSource)" + " throws PoemException {\n" + "    super(database, name, definitionSource);\n" + "  }\n" + "\n");
        w.write(NAG_BLOCK);
        w.write("}\n\n");
    }

    void generateJava() throws IOException, IllegalityException {
        final DSD this_ = this;
        this.createJava(this.databaseBaseClassName, new Generator(){

            public void process(Writer w) throws IOException {
                this_.generateDatabaseBaseJava(w);
            }
        }, true);
        this.createJava(this.databaseClassName, new Generator(){

            public void process(Writer w) throws IOException {
                this_.generateDatabaseJava(w);
            }
        }, false);
        this.createJava(this.databaseTablesBaseClassName, new Generator(){

            public void process(Writer w) throws IOException {
                this_.generateDatabaseTablesBaseJava(w);
            }
        }, true);
        this.createJava(this.databaseTablesClassName, new Generator(){

            public void process(Writer w) throws IOException {
                this_.generateDatabaseTablesJava(w);
            }
        }, false);
        this.createJava(this.getProjectTableClassName(), new Generator(){

            public void process(Writer w) throws IOException {
                this_.generateProjectTableJava(w);
            }
        }, false);
        this.createPackageHTML(new Generator(){

            public void process(Writer w) throws IOException {
                w.write("<p>The POEM-generated model classes for " + DSD.this.packageName + ".</p>\n");
            }
        }, false);
        this.createPackageHTML(new Generator(){

            public void process(Writer w) throws IOException {
                w.write("<p>The POEM-generated support classes for " + DSD.this.packageName + ".</p>\n");
            }
        }, true);
        Enumeration<TableDef> t = this.tablesInPackage.elements();
        while (t.hasMoreElements()) {
            t.nextElement().generateJava();
        }
    }

    String filePath(String resource) throws ResourceNotFoundException {
        Class<?> database;
        int ext = resource.lastIndexOf(46);
        if (ext == -1) {
            throw new ResourceNotFoundException(resource, "I can't find the type of this resource (i.e. the file's extension)");
        }
        int file = resource.lastIndexOf(46, ext - 1);
        if (file == -1) {
            throw new ResourceNotFoundException(resource, "I can't find a package name for this resource");
        }
        String packageNameLocal = resource.substring(0, file);
        String fileName = resource.substring(file + 1, ext);
        String extension = resource.substring(ext + 1);
        String fileToLookFor = fileName + "." + extension;
        String databaseName = StringUtils.capitalised(fileName.toLowerCase()) + "DatabaseTables";
        try {
            database = Class.forName(packageNameLocal + "." + databaseName);
        }
        catch (Exception e) {
            throw new ResourceNotFoundException(resource, "I can't find the database class associated with this resource (" + packageNameLocal + "." + databaseName + "). " + "Is it in your classpath?", e);
        }
        URL url = database.getResource(fileToLookFor);
        if (url == null || url.getFile() == null || url.getFile().equals("")) {
            throw new ResourceNotFoundException(resource, "I can't find the resource from the database class file. Is " + fileToLookFor + " in your classpath?");
        }
        return url.getFile();
    }

    static String javadocFormat(String indent2, String string) {
        return DSD.javadocFormat(2, Integer.parseInt(indent2), string);
    }

    static String javadocFormat(String string) {
        return DSD.javadocFormat(2, 1, string);
    }

    static String javadocFormat(String indent1, String indent2, String string) {
        return DSD.javadocFormat(Integer.parseInt(indent1), Integer.parseInt(indent2), string);
    }

    static String javadocFormat(int indent1, int indent2, String string) {
        int i;
        int lineWidth = 77;
        int index = indent1;
        StringBuffer b = new StringBuffer();
        for (i = 0; i < indent1; ++i) {
            b.append(" ");
        }
        b.append("*");
        ++index;
        for (i = 0; i < indent2; ++i) {
            b.append(" ");
        }
        int available = lineWidth - (index += indent2);
        if (string.length() <= available) {
            b.append(string);
            b.append(" \n");
        } else {
            int prevSpace = string.lastIndexOf(32, available);
            int incision = available;
            if (prevSpace != -1) {
                incision = prevSpace + 1;
            }
            b.append(string.substring(0, incision));
            b.append("\n");
            b.append(DSD.javadocFormat(indent1, indent2, string.substring(incision)));
        }
        return b.toString();
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 1) {
            DSD dsd = new DSD(args[0]);
            dsd.generateJava();
        } else if (args.length == 2) {
            DSD dsd = new DSD(args[0], new TableNamingStore(), false);
            dsd.generateJava();
        } else {
            System.err.println("Usage: java org.melati.poem.prepro.DSD <dsd file> [false]");
        }
    }

    public String getProjectTableClassName() {
        return this.projectName + "Table";
    }

    public String getProjectName() {
        return this.projectName;
    }
}

