/*
 * Decompiled with CFR 0.152.
 */
package org.melati.poem.prepro;

import java.io.IOException;
import java.io.StreamTokenizer;
import org.melati.poem.prepro.CompareOnlyFieldQualifier;
import org.melati.poem.prepro.DeletedFieldQualifier;
import org.melati.poem.prepro.DescriptionFieldQualifier;
import org.melati.poem.prepro.DisplayLevelFieldQualifier;
import org.melati.poem.prepro.DisplayNameFieldQualifier;
import org.melati.poem.prepro.DisplayOrderFieldQualifier;
import org.melati.poem.prepro.DisplayOrderPriorityFieldQualifier;
import org.melati.poem.prepro.FieldDef;
import org.melati.poem.prepro.HeightFieldQualifier;
import org.melati.poem.prepro.IllegalityException;
import org.melati.poem.prepro.IndexedFieldQualifier;
import org.melati.poem.prepro.IntegrityfixFieldQualifier;
import org.melati.poem.prepro.NullableFieldQualifier;
import org.melati.poem.prepro.ParsingDSDException;
import org.melati.poem.prepro.PrecisionFieldQualifier;
import org.melati.poem.prepro.RenderinfoFieldQualifier;
import org.melati.poem.prepro.ScaleFieldQualifier;
import org.melati.poem.prepro.SearchabilityFieldQualifier;
import org.melati.poem.prepro.SizeFieldQualifier;
import org.melati.poem.prepro.SortDescendingFieldQualifier;
import org.melati.poem.prepro.TroidFieldQualifier;
import org.melati.poem.prepro.UncreateableFieldQualifier;
import org.melati.poem.prepro.UneditableFieldQualifier;
import org.melati.poem.prepro.UniqueFieldQualifier;
import org.melati.poem.prepro.WidthFieldQualifier;

public abstract class FieldQualifier {
    public abstract void apply(FieldDef var1) throws IllegalityException;

    public static FieldQualifier from(StreamTokenizer tokens) throws ParsingDSDException, IOException {
        FieldQualifier it;
        if (tokens.ttype != -3) {
            throw new ParsingDSDException("<field qualifier>", tokens);
        }
        String kind = tokens.sval;
        tokens.nextToken();
        if (kind.equals("indexed")) {
            it = new IndexedFieldQualifier();
        } else if (kind.equals("unique")) {
            it = new UniqueFieldQualifier();
        } else if (kind.equals("primary")) {
            it = new TroidFieldQualifier();
        } else if (kind.equals("nullable")) {
            it = new NullableFieldQualifier();
        } else if (kind.equals("size")) {
            it = new SizeFieldQualifier(tokens);
        } else if (kind.equals("deleted")) {
            it = new DeletedFieldQualifier();
        } else if (kind.equals("displayorderpriority")) {
            it = new DisplayOrderPriorityFieldQualifier(tokens);
        } else if (kind.equals("sortdescending")) {
            it = new SortDescendingFieldQualifier();
        } else if (kind.equals("uneditable")) {
            it = new UneditableFieldQualifier();
        } else if (kind.equals("uncreateable")) {
            it = new UncreateableFieldQualifier();
        } else if (kind.equals("displayname")) {
            it = new DisplayNameFieldQualifier(tokens);
        } else if (kind.equals("displayorder")) {
            it = new DisplayOrderFieldQualifier(tokens);
        } else if (kind.equals("description")) {
            it = new DescriptionFieldQualifier(tokens);
        } else if (kind.equals("displaylevel")) {
            it = new DisplayLevelFieldQualifier(tokens);
        } else if (kind.equals("searchability")) {
            it = new SearchabilityFieldQualifier(tokens);
        } else if (kind.equals("compareonly")) {
            it = new CompareOnlyFieldQualifier();
        } else if (kind.equals("width")) {
            it = new WidthFieldQualifier(tokens);
        } else if (kind.equals("height")) {
            it = new HeightFieldQualifier(tokens);
        } else if (kind.equals("renderinfo")) {
            it = new RenderinfoFieldQualifier(tokens);
        } else if (kind.equals("integrityfix")) {
            it = new IntegrityfixFieldQualifier(tokens);
        } else if (kind.equals("precision")) {
            it = new PrecisionFieldQualifier(tokens);
        } else if (kind.equals("scale")) {
            it = new ScaleFieldQualifier(tokens);
        } else {
            throw new ParsingDSDException("<field qualifier>", tokens);
        }
        return it;
    }
}

