/*
 * Decompiled with CFR 0.152.
 */
package org.melati.poem.prepro;

import java.io.IOException;
import java.io.Writer;
import java.util.Vector;
import org.melati.poem.prepro.DSD;
import org.melati.poem.prepro.FieldDef;
import org.melati.poem.prepro.FieldQualifier;
import org.melati.poem.prepro.IllegalityException;
import org.melati.poem.prepro.TableDef;

public class SearchabilityFieldDef
extends FieldDef {
    public SearchabilityFieldDef(int lineNo, TableDef table, String name, int displayOrder, Vector<FieldQualifier> qualifiers) throws IllegalityException {
        super(lineNo, table, name, "Searchability", "Integer", displayOrder, qualifiers);
        table.addImport("org.melati.poem.SearchabilityPoemType", "table");
        table.addImport("org.melati.poem.Searchability", "table");
        table.addImport("org.melati.poem.Searchability", "persistent");
    }

    @Override
    protected void generateColRawAccessors(Writer w) throws IOException {
        super.generateColRawAccessors(w);
        w.write("\n          public Object getRaw(Persistent g)\n              throws AccessPoemException {\n            return ((" + this.shortestUnambiguousClassname + ")g).get" + this.capitalisedName + "Index();\n" + "          }\n" + "\n");
        w.write("          public void setRaw(Persistent g, Object raw)\n              throws AccessPoemException {\n            ((" + this.shortestUnambiguousClassname + ")g).set" + this.capitalisedName + "Index((" + this.rawType + ")raw);\n" + "          }\n");
    }

    @Override
    public void generateBaseMethods(Writer w) throws IOException {
        super.generateBaseMethods(w);
        w.write("\n /**\n  * Retrieves the " + this.capitalisedName + " index value \n" + "  * of this <code>Persistent</code>.\n" + (this.description != null ? "  * Field description: \n" + DSD.javadocFormat(2, 3, this.description) + "  * \n" : "") + "  * \n" + "  * Generated by " + "org.melati.poem.prepro.SearchabiltyFieldDef" + "#generateBaseMethods \n" + "  * @throws AccessPoemException \n" + "  *         if the current <code>AccessToken</code> \n" + "  *         does not confer read access rights\n" + "  * @return the " + this.rawType + " " + this.name + "\n" + "  */\n");
        w.write("\n  public Integer get" + this.capitalisedName + "Index()\n" + "      throws AccessPoemException {\n" + "    readLock();\n" + "    return get" + this.capitalisedName + "_unsafe();\n" + "  }\n" + "\n");
        w.write("\n /**\n  * Sets the <code>" + this.capitalisedName + "</code> index value, with checking, for this " + "<code>Persistent</code>.\n" + (this.description != null ? "  * Field description: \n" + DSD.javadocFormat(2, 3, this.description) + "  * \n" : "") + "  * \n" + "  * Generated by " + "org.melati.poem.prepro.SearchabiltyFieldDef" + "#generateBaseMethods \n" + "  * @param raw  the value to set \n" + "  * @throws AccessPoemException \n" + "  *         if the current <code>AccessToken</code> \n" + "  *         does not confer write access rights\n" + "  */\n");
        w.write("  public void set" + this.capitalisedName + "Index(Integer raw)\n" + "      throws AccessPoemException {\n" + "    " + this.rootTableAccessorMethod + "().get" + this.capitalisedName + "Column()." + "getType().assertValidRaw(raw);\n" + "    writeLock();\n" + "    set" + this.capitalisedName + "_unsafe(raw);\n" + "  }\n" + "\n");
        w.write("\n /**\n  * Retrieves the " + this.capitalisedName + " value \n" + "  * of this <code>Persistent</code>.\n" + (this.description != null ? "  * Field description: \n" + DSD.javadocFormat(2, 3, this.description) + "  * \n" : "") + "  *\n" + "  * Generated by " + "org.melati.poem.prepro.SearchabiltyFieldDef" + "#generateBaseMethods \n" + "  * @throws AccessPoemException \n" + "  *         if the current <code>AccessToken</code> \n" + "  *         does not confer read access rights\n" + "  * @return the " + this.typeShortName + "\n" + "  */\n");
        w.write("  public " + this.typeShortName + " get" + this.capitalisedName + "()\n" + "      throws AccessPoemException {\n" + "    Integer index = get" + this.capitalisedName + "Index();\n" + "    return index == null ? null :\n" + "        Searchability.forIndex(index.intValue());\n" + "  }\n" + "\n");
        w.write("\n /**\n  * Sets the <code>" + this.capitalisedName + "</code> value, with checking, for the " + "<code>Persistent</code> argument.\n" + (this.description != null ? "  * Field description: \n" + DSD.javadocFormat(2, 3, this.description) + "  * \n" : "") + "  * \n" + "  * Generated by " + "org.melati.poem.prepro.SearchabiltyFieldDef" + "#generateBaseMethods \n" + "  * @param cooked  the value to set \n" + "  * @throws AccessPoemException \n" + "  *         if the current <code>AccessToken</code> \n" + "  *         does not confer write access rights\n" + "  */\n");
        w.write("  public void set" + this.capitalisedName + "(" + this.typeShortName + " cooked)\n" + "      throws AccessPoemException {\n" + "    set" + this.capitalisedName + "Index(cooked == null ? null : cooked.index);\n" + "  }\n");
    }

    @Override
    public void generateJavaDeclaration(Writer w) throws IOException {
        w.write("Integer " + this.name);
    }

    @Override
    public String poemTypeJava() {
        return "new SearchabilityPoemType()";
    }
}

