/*
 * Decompiled with CFR 0.152.
 */
package org.melati.example.contacts;

import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import org.melati.admin.AnticipatedException;
import org.melati.example.contacts.Category;
import org.melati.example.contacts.ContactsDatabase;
import org.melati.example.contacts.generated.ContactBase;
import org.melati.poem.AccessPoemException;
import org.melati.poem.Persistent;
import org.melati.poem.PoemThread;
import org.melati.poem.Treeable;
import org.melati.poem.User;
import org.melati.poem.util.EnumUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Contact
extends ContactBase
implements Treeable {
    public boolean isIn(Category category) {
        ContactsDatabase db = (ContactsDatabase)this.getContactsDatabaseTables();
        String sql = db.quotedName("contact") + " = " + this.getTroid() + " AND " + db.quotedName("category") + " = " + category.getTroid();
        return db.getContactCategoryTable().exists(sql);
    }

    protected void writeLock() {
        super.writeLock();
        this.setLastupdated_unsafe(new java.sql.Date(new Date().getTime()));
        if (PoemThread.accessToken() instanceof User) {
            this.setLastupdateuser_unsafe(((User)PoemThread.accessToken()).getTroid());
        } else {
            this.setLastupdateuser_unsafe(new Integer(1));
        }
        Integer count = this.getUpdates();
        if (count == null) {
            count = new Integer(0);
        }
        this.setUpdates_unsafe(new Integer(count + 1));
    }

    public Treeable[] getChildren() {
        return Contact.arrayOf(this.getContactTable().getOwnerColumn().selectionWhereEq((Object)this.troid()));
    }

    public ArrayList<Integer> getAncestors() {
        ArrayList<Integer> l = new ArrayList<Integer>();
        for (Contact p = this.getOwner(); p != null; p = p.getOwner()) {
            l.add(new Integer(p.troid()));
        }
        return l;
    }

    @Override
    public void setOwner(Contact cooked) throws AccessPoemException {
        if (cooked != null && cooked.getAncestors().contains(this.troid())) {
            throw new DescendantParentException("Owner must not be a descendant.");
        }
        super.setOwner(cooked);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Treeable[] arrayOf(Vector<Persistent> v) {
        Object[] arr;
        Vector<Persistent> vector = v;
        synchronized (vector) {
            arr = new Treeable[v.size()];
            v.copyInto(arr);
        }
        return arr;
    }

    public static Treeable[] arrayOf(Enumeration<Persistent> e) {
        Vector v = EnumUtils.vectorOf(e);
        return Contact.arrayOf(v);
    }

    public class DescendantParentException
    extends AnticipatedException {
        private static final long serialVersionUID = 1L;

        public DescendantParentException(String message) {
            super(message);
        }
    }
}

