/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.TNSAddress;

import java.util.Vector;
import oracle.net.TNSAddress.SOException;
import oracle.net.TNSAddress.SchemaObject;
import oracle.net.TNSAddress.SchemaObjectFactoryInterface;
import oracle.net.nl.NLException;
import oracle.net.nl.NVFactory;
import oracle.net.nl.NVPair;

public class AddressList
implements SchemaObject {
    public Vector children = new Vector();
    private SchemaObject child;
    private NVPair childnv;
    public boolean sourceRoute = false;
    public boolean loadBalance = false;
    public boolean failover = true;
    protected SchemaObjectFactoryInterface f = null;

    public AddressList(SchemaObjectFactoryInterface schemaObjectFactoryInterface) {
        this.f = schemaObjectFactoryInterface;
    }

    protected void init() {
        this.children.removeAllElements();
        this.child = null;
        this.childnv = null;
        this.sourceRoute = false;
        this.loadBalance = false;
        this.failover = true;
    }

    public void initFromNVPair(NVPair nVPair) throws SOException {
        this.init();
        int n = nVPair.getListSize();
        if (n == 0) {
            throw new SOException();
        }
        int n2 = 0;
        while (n2 < n) {
            this.childnv = nVPair.getListElement(n2);
            if (this.childnv.getName().equalsIgnoreCase("SOURCE_ROUTE")) {
                this.sourceRoute = this.childnv.getAtom().equalsIgnoreCase("yes") || this.childnv.getAtom().equalsIgnoreCase("on") || this.childnv.getAtom().equalsIgnoreCase("true");
            } else if (this.childnv.getName().equalsIgnoreCase("LOAD_BALANCE")) {
                this.loadBalance = this.childnv.getAtom().equalsIgnoreCase("yes") || this.childnv.getAtom().equalsIgnoreCase("on") || this.childnv.getAtom().equalsIgnoreCase("true");
            } else if (this.childnv.getName().equalsIgnoreCase("FAILOVER")) {
                this.failover = this.childnv.getAtom().equalsIgnoreCase("yes") || this.childnv.getAtom().equalsIgnoreCase("on") || this.childnv.getAtom().equalsIgnoreCase("true");
            } else if (this.childnv.getName().equalsIgnoreCase("ADDRESS")) {
                this.child = this.f.create(0);
                this.child.initFromNVPair(this.childnv);
                this.children.addElement(this.child);
            } else if (this.childnv.getName().equalsIgnoreCase("ADDRESS_LIST")) {
                this.child = this.f.create(1);
                this.child.initFromNVPair(this.childnv);
                this.children.addElement(this.child);
            } else {
                throw new SOException();
            }
            ++n2;
        }
        if (this.children.size() == 0) {
            throw new SOException();
        }
    }

    public void initFromString(String string) throws NLException, SOException {
        NVPair nVPair = new NVFactory().createNVPair(string);
        this.initFromNVPair(nVPair);
    }

    public int isA() {
        return 1;
    }

    public String isA_String() {
        return "ADDRESS_LIST";
    }

    public String toString() {
        String string = new String("");
        string = String.valueOf(string) + "(ADDRESS_LIST=";
        int n = 0;
        while (n < this.children.size()) {
            string = String.valueOf(string) + ((SchemaObject)this.children.elementAt(n)).toString();
            ++n;
        }
        if (this.sourceRoute) {
            string = String.valueOf(string) + "(SOURCE_ROUTE=yes)";
        }
        if (this.loadBalance) {
            string = String.valueOf(string) + "(LOAD_BALANCE=yes)";
        }
        if (!this.failover) {
            string = String.valueOf(string) + "(FAILOVER=false)";
        }
        string = String.valueOf(string) + ")";
        return string;
    }
}

