/*
 * Decompiled with CFR 0.152.
 */
package easysoft.sql;

import easysoft.rpc.Stub;
import easysoft.sql.jobConnection;
import easysoft.sql.jobDriver;
import easysoft.sql.jobResultSet;
import easysoft.sql.jobTrace;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;

public class jobStatement
implements Statement {
    public jobConnection conn;
    Stub rpc;
    volatile long hStmt = 0L;
    jobResultSet result = null;
    private int max_field_size = 1024;
    private int max_rows = 50000;
    private int timeout = 0;
    long updateCount = -1L;
    public int columnCount = 0;
    String o = "Statement";
    public int fetchSize = -1;
    public int fetchDirection = 1000;
    public int resultSetConcurrency = 1007;
    public int resultSetType = 1003;
    public String batchStatementsString = "";
    public int batchStatementCount = 0;

    public jobStatement() throws SQLException {
        jobTrace.debug("jobStatement() is called");
    }

    public jobStatement(jobConnection jobConnection2) throws SQLException {
        this.conn = jobConnection2;
        this.fetchSize = jobConnection2.fetchSize;
        this.rpc = jobConnection2.rpc;
        this.fetchSize = jobConnection2.fetchSize;
        if (jobConnection2.cl == null) {
            jobTrace.enter("Connection", "createStatement", "");
            throw new SQLException("Connection is not available to create Statement", "08003");
        }
        this.hStmt = this.rpc.jdbc_createStatementX(this.o, "createStatement", jobConnection2.jobHandle);
        jobTrace.debug("Statement Handle: " + this.hStmt);
        if (jobConnection2.limit > 0) {
            this.setMaxRows(jobConnection2.limit);
        }
        if (jobConnection2.queryTimeout > 0) {
            this.setQueryTimeout(jobConnection2.queryTimeout);
        }
        this.resultSetType = 1003;
    }

    public jobStatement(jobConnection jobConnection2, int n, int n2) throws SQLException {
        this.resultSetConcurrency = n2;
        this.resultSetType = n;
        this.conn = jobConnection2;
        this.rpc = jobConnection2.rpc;
        if (this.rpc == null) {
            throw new SQLException("Connection is not available to create Statement", "08003");
        }
        try {
            this.hStmt = this.rpc.jdbc_createStatementX("Connection", "createStatement", jobConnection2.jobHandle);
            if (jobConnection2.limit > 0) {
                this.setMaxRows(jobConnection2.limit);
            }
        }
        catch (SQLException sQLException) {
            throw jobDriver.extendChain(sQLException, "Statement constructor failed");
        }
        if (this.rpc == null) {
            throw new SQLException("Connection is not available to create Statement", "08003");
        }
        try {
            switch (n) {
                case 1003: {
                    n = 0;
                    break;
                }
                case 1004: {
                    n = 3;
                    break;
                }
                case 1005: {
                    n = 2;
                    break;
                }
                default: {
                    throw new SQLException("Invalid resultSetType: " + n);
                }
            }
            switch (n2) {
                case 1007: {
                    n2 = 1;
                    break;
                }
                case 1008: {
                    n2 = 2;
                    break;
                }
                default: {
                    throw new SQLException("Invalid resultSetConcurrency: " + n2);
                }
            }
            jobTrace.println("Just before calling jdbc2_createStatement");
            this.rpc.jdbc2_createStatement("Connection", "createStatement", this.hStmt, (short)n, (short)n2);
            this.fetchSize = 0;
        }
        catch (SQLException sQLException) {
            throw jobDriver.extendChain(sQLException, "Statement constructor failed" + sQLException.getMessage());
        }
    }

    public void addBatch(String string) throws SQLException {
        jobTrace.enter(this.o, "addBatch", "sql=" + string);
        this.batchStatementsString = this.batchStatementsString + this.packSql(string);
        jobTrace.returnVoid();
    }

    private int[] unpackResponse(String string) throws BatchUpdateException {
        int[] nArray = new int[]{};
        if (string == null) {
            return nArray;
        }
        int n = string.indexOf("|");
        int n2 = 0;
        int n3 = 0;
        while (n > 0) {
            ++n3;
            n2 = n2 + n + 1;
            n = string.substring(n2).indexOf("|");
        }
        nArray = new int[n3];
        n = string.indexOf("|");
        n2 = 0;
        n3 = 0;
        boolean bl = false;
        while (n > 0) {
            nArray[n3] = Integer.valueOf(string.substring(n2, n2 + n));
            if (nArray[n3] == -1) {
                nArray[n3] = -3;
                bl = true;
            }
            ++n3;
            n2 = n2 + n + 1;
            n = string.substring(n2).indexOf("|");
        }
        if (bl) {
            throw new BatchUpdateException("One or more of the batch execution returns a result set or has failed", nArray);
        }
        return nArray;
    }

    private String packSql(String string) {
        string = " " + string + ";";
        String string2 = Integer.toString(string.length() + 1, 16).toUpperCase();
        switch (string2.length()) {
            case 1: {
                string2 = "000" + string2;
                break;
            }
            case 2: {
                string2 = "00" + string2;
                break;
            }
            case 3: {
                string2 = "0" + string2;
                break;
            }
        }
        return "0x" + string2 + " " + string + " ";
    }

    public void cancel() throws SQLException {
        try {
            this.rpc.jdbc_cancel(this.o, "cancel", this.hStmt);
        }
        catch (Exception exception) {
            throw new SQLException("cancel failed");
        }
    }

    public void clearBatch() throws SQLException {
        this.batchStatementCount = 0;
        this.batchStatementsString = "";
    }

    public void clearWarnings() throws SQLException {
        this.rpc.jdbc_clearWarnings(this.o, "clearWarnings", this.rpc.cl.jobHandle);
    }

    public void close() throws SQLException {
        try {
            if (this.hStmt == 0L || this.conn.cl == null) {
                jobTrace.enter("Statement", "close");
                jobTrace.debug("Statement is closed already");
                jobTrace.returnVoid("close");
            } else {
                try {
                    this.closeResult();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                short s = this.rpc.jdbc_closeStatementX(this.o, "close", this.hStmt);
                this.hStmt = 0L;
                jobTrace.returnVoid("close");
            }
            jobTrace.returnVoid();
        }
        catch (SQLException sQLException) {
            throw new SQLException("Statement.close() failed" + sQLException.getMessage());
        }
    }

    void closeResult() throws SQLException {
        if (this.result != null && !this.result.isClosed()) {
            this.result.close();
            this.result = null;
        }
    }

    public boolean execute(String string) throws SQLException {
        try {
            this.checkHandles("execute");
            this.rpc.jdbc_executeQueryX(this.o, "execute", this.hStmt, string);
            this.columnCount = this.rpc.jdbc_getColumnCount("", "", this.hStmt);
            if (this.columnCount > 0) {
                return true;
            }
            this.updateCount = this.rpc.Jsql_row_count("", "", this.hStmt);
            return false;
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            throw jobDriver.extendChain(sQLException, "Execute Failed");
        }
    }

    public int[] executeBatch() throws SQLException, BatchUpdateException {
        String string = "";
        jobTrace.enter(this.o, "executeBatch", "()");
        try {
            string = this.rpc.jdbc_executeBatch(this.o, "executeBatch", this.hStmt, this.batchStatementsString + "0x000 ");
        }
        catch (SQLException sQLException) {
            throw new BatchUpdateException(sQLException.getMessage(), sQLException.getSQLState(), sQLException.getErrorCode(), this.unpackResponse(string));
        }
        jobTrace.println(string);
        return this.unpackResponse(string);
    }

    public ResultSet executeQuery(String string) throws SQLException {
        this.checkHandles("executeQuery");
        this.closeResult();
        if (string.trim().equals("tables")) {
            try {
                this.rpc.jdbc_getTables("", "", this.hStmt, "null", "null", "null", "null");
            }
            catch (SQLException sQLException) {
                throw jobDriver.extendChain(sQLException, "Getting tables failed");
            }
        } else {
            this.rpc.jdbc_executeQueryX(this.o, "executeQuery", this.hStmt, string);
            long l = this.rpc.Jsql_row_count("", "", this.hStmt);
            this.columnCount = this.rpc.jdbc_getColumnCount("", "", this.hStmt);
            if (this.columnCount <= 0) {
                throw new SQLException(jobDriver.errorPrefix + "Statement.executeQuery Not generating a ResultSet");
            }
        }
        this.result = new jobResultSet(this.rpc, this);
        return jobTrace.returnRS(this.result);
    }

    public int executeUpdate(String string) throws SQLException {
        if (this.hStmt == 0L) {
            throw new SQLException("Attempt to use a statement that is already closed");
        }
        this.updateCount = (int)this.rpc.jdbc_executeUpdateX(this.o, "executeUpdate", this.hStmt, string);
        this.updateCount = this.rpc.Jsql_row_count("", "", this.hStmt);
        if (this.updateCount == -1L) {
            this.columnCount = this.rpc.jdbc_getColumnCount("", "", this.hStmt);
            if (this.columnCount > 0) {
                throw new SQLException(jobDriver.errorPrefix + " Statement.executeUpdate(" + string + ") has returned a result set");
            }
        }
        return (int)this.updateCount;
    }

    public Connection getConnection() throws SQLException {
        jobTrace.enter(this.o, "getConnaction");
        return (Connection)jobTrace.returnObject(this.conn);
    }

    public int getFetchDirection() throws SQLException {
        String string = "getFetchDirection";
        int n = this.Jsql_get_CES_attr_integer(this.hStmt, (short)83, 6, string);
        if (n == 0) {
            return 1000;
        }
        return 1002;
    }

    public int getFetchSize() throws SQLException {
        jobTrace.enter(this.o, "getFetchsize()");
        if (this.fetchSize == -1) {
            return jobTrace.returnInt(0);
        }
        return jobTrace.returnInt(this.fetchSize);
    }

    public int getMaxFieldSize() throws SQLException {
        return this.Jsql_get_CES_attr_integer(this.hStmt, (short)83, 3, "getMaxFieldSize()");
    }

    public int getMaxRows() throws SQLException {
        return this.Jsql_get_CES_attr_integer(this.hStmt, (short)83, 1, "getMaxRows()");
    }

    public boolean getMoreResults() throws SQLException {
        if (this.rpc.jdbc_getMoreResults(this.o, "getMoreResults", this.hStmt) == 0) {
            this.columnCount = this.rpc.jdbc_getColumnCount("", "", this.hStmt);
            return jobTrace.returnBool(true);
        }
        this.columnCount = 0;
        return jobTrace.returnBool(false);
    }

    public int getQueryTimeout() throws SQLException {
        return this.Jsql_get_CES_attr_integer(this.hStmt, (short)83, 0, "getQueryTimeout()");
    }

    public ResultSet getResultSet() throws SQLException {
        jobTrace.enter(this.o, "getResultSet");
        if (this.columnCount <= 0) {
            this.closeResult();
            return (ResultSet)jobTrace.returnObject(null);
        }
        this.result = new jobResultSet(this.rpc, this);
        return (ResultSet)jobTrace.returnObject(this.result);
    }

    public int getResultSetConcurrency() throws SQLException {
        jobTrace.enter(this.o, "getResultSetConcurrency");
        return jobTrace.returnInt(this.resultSetConcurrency);
    }

    public int getResultSetType() throws SQLException {
        jobTrace.enter(this.o, "getResultSetType");
        return jobTrace.returnInt(this.resultSetType);
    }

    public long getStatementHandle() {
        return this.hStmt;
    }

    public int getUpdateCount() throws SQLException {
        if (this.columnCount == 0) {
            this.updateCount = this.rpc.Jsql_row_count(this.o, "getUpdateCount", this.hStmt);
            return jobTrace.returnInt((int)this.updateCount);
        }
        return jobTrace.returnInt(-1);
    }

    public SQLWarning getWarnings() throws SQLException {
        jobTrace.enter(this.o, "getWarnings");
        String string = "";
        try {
            string = this.rpc.jdbc_getWarnings(this.o, "getWarnings", this.rpc.cl.jobHandle);
            if (string.equals("")) {
                return (SQLWarning)jobTrace.returnObject(null);
            }
            return (SQLWarning)jobTrace.returnObject(new SQLWarning("STATEMENT: " + string));
        }
        catch (SQLException sQLException) {
            throw jobDriver.extendChain(sQLException, "Statement.getWarnings() failed");
        }
    }

    public void setCursorName(String string) throws SQLException {
        jobTrace.enter(this.o, "setCursorName(" + string + ")");
        this.rpc.Jsql_set_cursor_name(this.o, "setCursorName", this.hStmt, string);
        jobTrace.returnVoid();
    }

    public void setEscapeProcessing(boolean bl) throws SQLException {
        int n = 1;
        if (bl) {
            n = 0;
        }
        this.Jsql_set_CES_attr_integer(this.hStmt, (short)83, 2, n, "setEscapeProcessing(" + bl + ")");
    }

    public void setFetchDirection(int n) throws SQLException {
        String string = "setFetchDirection";
        jobTrace.enter(this.o, string);
        switch (n) {
            case 1000: 
            case 1001: 
            case 1002: {
                return;
            }
        }
        throw new SQLException("Invalid argument passed to setFetchDirection: " + n);
    }

    public void setFetchSize(int n) throws SQLException {
        if (n < 0) {
            throw new SQLException("Attempt to set FetchSize value to invalid value: " + n);
        }
        if (this.getMaxRows() != 0 && n > this.getMaxRows()) {
            throw new SQLException("The specified fetchSize = " + n + " is invalid");
        }
        this.fetchSize = n;
    }

    public void setMaxFieldSize(int n) throws SQLException {
        if (n < 0) {
            throw new SQLException("Attempt to set MaxFieldSize to ivalid value: " + n);
        }
        this.Jsql_set_CES_attr_integer(this.hStmt, (short)83, 3, n, "setMaxFieldSize(" + n + ")");
    }

    public void setMaxRows(int n) throws SQLException {
        if (n < 0) {
            throw new SQLException("Attempt to set MaxRows to ivalid value: " + n);
        }
        this.Jsql_set_CES_attr_integer(this.hStmt, (short)83, 1, n, "setMaxRows(" + n + ")");
    }

    public void setQueryTimeout(int n) throws SQLException {
        if (n < 0) {
            throw new SQLException("Attempt to set QueryTimeout to ivalid value: " + n);
        }
        this.Jsql_set_CES_attr_integer(this.hStmt, (short)83, 0, n, "setQueryTimeout(" + n + ")");
    }

    public int Jsql_get_CES_attr_integer(long l, short s, int n, String string) throws SQLException {
        if (l == 0L) {
            throw new SQLException("Connection is closed while attempting to " + string);
        }
        return (int)this.rpc.Jsql_get_CES_attr_integer("", "", l, s, n);
    }

    public void Jsql_set_CES_attr_integer(long l, short s, int n, int n2, String string) throws SQLException {
        if (l == 0L) {
            throw new SQLException("Connection is closed while attempting to " + string);
        }
        jobTrace.println(string);
        this.rpc.Jsql_set_CES_attr_integer("", "", l, s, n, n2);
    }

    protected void finalize() throws SQLException {
        this.close();
    }

    void checkHandles(String string) throws SQLException {
        if (this.conn.isClosed()) {
            throw new SQLException("The connection used by the current statement is closed. " + string + " cannot be executed.", "08003", 0);
        }
        if (this.hStmt == 0L) {
            throw new SQLException("The current statement is closed. " + string + " cannot be executed.", "HY010", 0);
        }
        this.closeResult();
    }
}

