/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro;

import org.webmacro.ContextException;

public class PropertyException
extends ContextException {
    private static final long serialVersionUID = 1L;
    private String _message = null;

    public PropertyException(String reason) {
        super(reason);
    }

    public PropertyException(String reason, Throwable e) {
        super(reason, e);
    }

    public PropertyException(String reason, Throwable e, String contextLocation) {
        super(reason, e);
        this.setContextLocation(contextLocation);
    }

    public void setMessage(String message) {
        this._message = message;
    }

    public String getMessage() {
        if (this._message == null) {
            return super.getMessage();
        }
        String msg = this._message;
        if (this.getContextLocation() != null && msg != null) {
            msg = msg + " at " + this.getContextLocation();
        }
        return msg;
    }

    public static class UndefinedVariableException
    extends PropertyException {
        private static final long serialVersionUID = 1L;
        private String _msg = "Attempted to dereference an undefined variable.";

        public UndefinedVariableException() {
            super((String)null);
        }

        public String getMessage() {
            String msg = this._msg;
            String loc = this.getContextLocation();
            if (loc != null) {
                msg = msg + " at " + loc;
            }
            return msg;
        }

        public void setMessage(String msg) {
            this._msg = msg;
        }
    }

    public static class RestrictedMethodException
    extends PropertyException {
        private static final long serialVersionUID = 1L;
        String _propertyName;
        String _className;
        String _variableName;

        public RestrictedMethodException(String propertyName, String variableName, String className) {
            super("The method " + propertyName + " on variable $" + variableName + " of class " + className + " may not be accessed from a template.");
            this._variableName = variableName;
            this._className = className;
            this._propertyName = propertyName;
        }
    }

    public static class RestrictedPropertyException
    extends PropertyException {
        private static final long serialVersionUID = 1L;
        String _propertyName;
        String _className;
        String _variableName;

        public RestrictedPropertyException(String propertyName, String variableName, String className) {
            super("The property " + propertyName + " on variable $" + variableName + " of class " + className + " may not be accessed from a template.");
            this._variableName = variableName;
            this._className = className;
            this._propertyName = propertyName;
        }
    }

    public static class InvalidTypeException
    extends PropertyException {
        private static final long serialVersionUID = 1L;

        public InvalidTypeException(String variableName, Class clazz) {
            super("$" + variableName + " is not a " + clazz.getName());
        }
    }

    public static class VoidValueException
    extends PropertyException {
        private static final long serialVersionUID = 1L;
        String _variableName;

        public VoidValueException() {
            super("Attempt to use void value");
        }

        public VoidValueException(String variableName) {
            super("Variable $" + variableName + " has a void value ");
            this._variableName = variableName;
        }
    }

    public static class NoSuchPropertyException
    extends PropertyException {
        private static final long serialVersionUID = 1L;
        String _propertyName;
        String _className;
        String _variableName;

        public NoSuchPropertyException(String propertyName, String variableName, String className) {
            super("No public property " + propertyName + " on variable $" + variableName + " of class " + className);
            this._variableName = variableName;
            this._className = className;
            this._propertyName = propertyName;
        }
    }

    public static class NoSuchMethodWithArgumentsException
    extends PropertyException {
        private static final long serialVersionUID = 1L;
        public String methodName;
        public String className;
        public String arguments;

        public NoSuchMethodWithArgumentsException(String methodName, String className, String arguments) {
            super("No public method " + methodName + "(" + arguments + ")" + " in class " + className);
            this.className = className;
            this.methodName = methodName;
            this.arguments = arguments;
        }
    }

    public static class NoSuchMethodException
    extends PropertyException {
        private static final long serialVersionUID = 1L;
        public String methodName;
        public String className;
        public String variableName;

        public NoSuchMethodException(String methodName, String variableName, String className) {
            super("No public method " + methodName + " on variable $" + variableName + " of class " + className);
            this.variableName = variableName;
            this.className = className;
            this.methodName = methodName;
        }
    }

    public static class NullValueException
    extends PropertyException {
        private static final long serialVersionUID = 1L;
        public String variableName;

        public NullValueException(String variableName) {
            super("Value is null: $" + variableName);
            this.variableName = variableName;
        }
    }

    public static class NullToStringException
    extends PropertyException {
        private static final long serialVersionUID = 1L;
        public String variableName;

        public NullToStringException(String variableName) {
            super(".toString() returns null: $" + variableName);
            this.variableName = variableName;
        }
    }

    public static class NoSuchVariableException
    extends PropertyException {
        private static final long serialVersionUID = 1L;
        public String variableName;

        public NoSuchVariableException(String variableName) {
            super("No such variable: $" + variableName);
            this.variableName = variableName;
        }
    }
}

