/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro;

import java.net.MalformedURLException;
import java.net.URL;
import org.webmacro.ResourceException;
import org.webmacro.Template;
import org.webmacro.resource.AbstractTemplateLoader;
import org.webmacro.resource.CacheElement;

public class URLTemplateLoader
extends AbstractTemplateLoader {
    private URL baseURI;

    public void setConfig(String config) {
        try {
            this.baseURI = new URL(config);
        }
        catch (MalformedURLException e) {
            this.log.error("Cannot init url template loader, bad URL", e);
        }
    }

    public final Template load(String query, CacheElement ce) throws ResourceException {
        try {
            URL url = new URL(this.baseURI, query);
            if (this.log.loggingDebug()) {
                this.log.debug("FileTemplateProvider: Found template " + url);
            }
            return this.helper.load(url, ce);
        }
        catch (MalformedURLException e) {
            throw new ResourceException("Bad template URL", e);
        }
    }
}

