/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.directive;

import org.webmacro.directive.Directive;
import org.webmacro.directive.DirectiveArgs;
import org.webmacro.engine.BuildContext;
import org.webmacro.engine.BuildException;
import org.webmacro.engine.Builder;

public final class ArgsHolder
implements DirectiveArgs {
    private Directive.ArgDescriptor[] args;
    private Object[] buildArgs;

    public ArgsHolder(Directive.ArgDescriptor[] args) {
        this.args = args;
        this.buildArgs = new Object[args.length];
    }

    private final int findArgIndex(int id) throws BuildException {
        for (int i = 0; i < this.args.length; ++i) {
            if (this.args[i].id != id) continue;
            return i;
        }
        throw new BuildException("Invalid argument ID " + id + " requested ");
    }

    public Object getExactArg(int idx) throws BuildException {
        return this.buildArgs[idx];
    }

    public final int getArgCount() {
        return this.buildArgs.length;
    }

    public final Object getArg(int id) throws BuildException {
        int index = this.findArgIndex(id);
        return this.buildArgs[index];
    }

    public final Object getArg(int id, BuildContext bc) throws BuildException {
        int index = this.findArgIndex(id);
        Object o = this.buildArgs[index];
        return o instanceof Builder ? ((Builder)o).build(bc) : o;
    }

    public final void setArg(int id, Object o) throws BuildException {
        int index = this.findArgIndex(id);
        this.buildArgs[index] = o;
    }
}

