/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.directive;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpSession;
import org.webmacro.Broker;
import org.webmacro.Context;
import org.webmacro.FastWriter;
import org.webmacro.Log;
import org.webmacro.Macro;
import org.webmacro.PropertyException;
import org.webmacro.TemplateVisitor;
import org.webmacro.WebMacroException;
import org.webmacro.directive.Directive;
import org.webmacro.directive.DirectiveBuilder;
import org.webmacro.directive.DirectiveDescriptor;
import org.webmacro.engine.Block;
import org.webmacro.engine.BuildContext;
import org.webmacro.engine.BuildException;
import org.webmacro.engine.Builder;
import org.webmacro.engine.StaticClassWrapper;
import org.webmacro.engine.UndefinedMacro;
import org.webmacro.engine.Variable;
import org.webmacro.util.Instantiator;

public class BeanDirective
extends Directive {
    private static final String APP_BEANS_KEY = "org.webmacro.directive.BeanDirective.appBeans";
    private static final int BEAN_TARGET = 1;
    private static final int BEAN_CLASS_NAME = 2;
    private static final int BEAN_SCOPE = 3;
    private static final int BEAN_SCOPE_GLOBAL = 4;
    private static final int BEAN_SCOPE_APPLICATION = 5;
    private static final int BEAN_SCOPE_SESSION = 6;
    private static final int BEAN_SCOPE_PAGE = 7;
    private static final int BEAN_INITARGS = 8;
    private static final int BEAN_INITARGS_VAL = 9;
    private static final int BEAN_TYPE_STATIC = 10;
    private static final int BEAN_ON_NEW = 11;
    private static final int BEAN_ON_NEW_BLOCK = 12;
    private static final UndefinedMacro UNDEF = UndefinedMacro.getInstance();
    private static int[] BEAN_SCOPES = new int[]{4, 5, 6, 7};
    static Map globalBeans = new HashMap(20);
    private Variable target;
    private String targetName;
    private String _className;
    private int scope;
    private boolean isStaticClass;
    private Object initArgObj;
    private Object[] initArgs;
    private Block onNewBlock;
    private Log _log;
    private Broker _broker;
    private static final Directive.ArgDescriptor[] myArgs = new Directive.ArgDescriptor[]{new Directive.LValueArg(1), new Directive.AssignmentArg(), new Directive.QuotedStringArg(2), new Directive.OptionalGroup(3), new Directive.KeywordArg(3, "scope"), new Directive.AssignmentArg(), new Directive.SingleOptionChoice(5), new Directive.OptionalGroup(1), new Directive.KeywordArg(4, "global"), new Directive.OptionalGroup(1), new Directive.KeywordArg(5, "application"), new Directive.OptionalGroup(1), new Directive.KeywordArg(6, "session"), new Directive.OptionalGroup(1), new Directive.KeywordArg(7, "page"), new Directive.OptionalGroup(1), new Directive.KeywordArg(10, "static"), new Directive.OptionalGroup(2), new Directive.KeywordArg(8, "initArgs"), new Directive.RValueArg(9), new Directive.OptionalGroup(2), new Directive.KeywordArg(11, "onNew"), new Directive.BlockArg(12)};
    private static final DirectiveDescriptor myDescr = new DirectiveDescriptor("bean", null, myArgs, null);

    public static DirectiveDescriptor getDescriptor() {
        return myDescr;
    }

    public Object build(DirectiveBuilder builder, BuildContext bc) throws BuildException {
        this._broker = bc.getBroker();
        this._log = this._broker.getLog("directive");
        try {
            this.target = (Variable)builder.getArg(1, bc);
        }
        catch (ClassCastException e) {
            throw new Directive.NotVariableBuildException(BeanDirective.myDescr.name, e);
        }
        this.targetName = this.target.getName();
        this._className = (String)builder.getArg(2, bc);
        this.classForName(this._className);
        boolean bl = this.isStaticClass = builder.getArg(10) != null;
        if (this.isStaticClass) {
            this.scope = 4;
        } else {
            this.scope = BeanDirective.getScope(builder, bc);
            this.initArgObj = builder.getArg(9);
            if (this.initArgObj instanceof Builder) {
                this.initArgObj = ((Builder)this.initArgObj).build(bc);
            }
        }
        this.onNewBlock = (Block)builder.getArg(12, bc);
        this._log.debug("BeanDirective, target=" + this.target + ", className=" + this._className + ", scope=" + this.scope + ", isStaticClass=" + this.isStaticClass + ", initArgs=" + this.initArgObj);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(FastWriter out, Context context) throws PropertyException, IOException {
        Map appBeans = (Map)this._broker.getBrokerLocal(APP_BEANS_KEY);
        boolean isNew = false;
        try {
            while (this.initArgObj instanceof Macro && this.initArgObj != UNDEF) {
                this.initArgObj = ((Macro)this.initArgObj).evaluate(context);
            }
            this.initArgs = this.initArgObj == null || this.initArgObj.getClass().isArray() ? (Object[])this.initArgObj : new Object[]{this.initArgObj};
            Object o = null;
            Class c = null;
            switch (this.scope) {
                case 4: {
                    Map map = globalBeans;
                    synchronized (map) {
                        o = globalBeans.get(this.targetName);
                        if (o == null) {
                            if (this.isStaticClass) {
                                c = context.getBroker().classForName(this._className);
                                o = new StaticClassWrapper(c);
                            } else {
                                o = this.instantiate(this._className, this.initArgs);
                            }
                            isNew = true;
                            globalBeans.put(this.targetName, o);
                        }
                        break;
                    }
                }
                case 5: {
                    Map map = appBeans;
                    synchronized (map) {
                        o = appBeans.get(this.targetName);
                        if (o == null) {
                            o = this.instantiate(this._className, this.initArgs);
                            isNew = true;
                            appBeans.put(this.targetName, o);
                        }
                        break;
                    }
                }
                case 6: {
                    HttpSession session = (HttpSession)context.getProperty("Session");
                    if (session != null) {
                        HttpSession httpSession = session;
                        synchronized (httpSession) {
                            o = session.getAttribute(this.targetName);
                            if (o == null) {
                                o = this.instantiate(this._className, this.initArgs);
                                isNew = true;
                                session.setAttribute(this.targetName, o);
                            }
                            break;
                        }
                    }
                    PropertyException e = new PropertyException("#bean usage error: session scope is only valid with servlets!");
                    this._broker.getEvaluationExceptionHandler().evaluate(this.target, context, e);
                    break;
                }
                default: {
                    o = this.instantiate(this._className, this.initArgs);
                    isNew = true;
                    if (o == null) break;
                    Class[] paramTypes = new Class[]{Context.class};
                    try {
                        Method m = o.getClass().getMethod("init", paramTypes);
                        if (m == null) break;
                        Object[] args = new Object[]{context};
                        m.invoke(o, args);
                        break;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
            this._log.debug("BeanDirective: Class " + this._className + " loaded.");
            this.target.setValue(context, o);
        }
        catch (PropertyException e) {
            this._broker.getEvaluationExceptionHandler().evaluate(this.target, context, e);
        }
        catch (Exception e) {
            String errorText = "BeanDirective: Unable to load bean " + this.target + " of type " + this._className;
            BeanDirective.writeWarning(errorText, context, out);
        }
        if (isNew && this.onNewBlock != null) {
            this.onNewBlock.write(out, context);
        }
    }

    public void accept(TemplateVisitor v) {
        v.beginDirective(BeanDirective.myDescr.name);
        v.visitDirectiveArg("BeanTarget", this.target);
        v.visitDirectiveArg("BeanClass", this._className);
        v.visitDirectiveArg("BeanScope", new Integer(this.scope));
        v.visitDirectiveArg("BeanIsStatic", new Boolean(this.isStaticClass));
        v.visitDirectiveArg("BeanInitArgs", this.initArgs);
        v.endDirective();
    }

    private Object instantiate(String className, Object[] args) throws Exception {
        Class c = this.classForName(className);
        return this.instantiate(c, args);
    }

    private Object instantiate(Class c, Object[] args) throws Exception {
        return Instantiator.getInstance(this._broker).instantiate(c, args);
    }

    private static int getScope(DirectiveBuilder builder, BuildContext bc) throws BuildException {
        int scope = -1;
        for (int i = 0; i < BEAN_SCOPES.length && builder.getArg(scope = BEAN_SCOPES[i]) == null; ++i) {
        }
        return scope;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(Broker b) {
        Broker broker = b;
        synchronized (broker) {
            b.setBrokerLocal(APP_BEANS_KEY, new HashMap(20));
        }
    }

    private Class classForName(String className) throws BuildException {
        Class c;
        try {
            c = Instantiator.getInstance(this._broker).classForName(className);
        }
        catch (WebMacroException e) {
            throw new BuildException("BeanDirective failed to load class \"" + className + "\"", e);
        }
        return c;
    }
}

