/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.directive;

import java.io.IOException;
import org.webmacro.Context;
import org.webmacro.FastWriter;
import org.webmacro.Macro;
import org.webmacro.PropertyException;
import org.webmacro.directive.Directive;
import org.webmacro.directive.DirectiveBuilder;
import org.webmacro.directive.DirectiveDescriptor;
import org.webmacro.engine.Block;
import org.webmacro.engine.BuildContext;
import org.webmacro.engine.BuildException;
import org.webmacro.engine.UndefinedMacro;
import org.webmacro.engine.Variable;

public class CountDirective
extends Directive {
    private static final int COUNT_ITERATOR = 1;
    private static final int COUNT_FROM_K = 2;
    private static final int COUNT_START = 3;
    private static final int COUNT_TO_K = 4;
    private static final int COUNT_END = 5;
    private static final int COUNT_STEP_K = 6;
    private static final int COUNT_STEP = 7;
    private static final int COUNT_BODY = 8;
    private static final Directive.ArgDescriptor[] _args = new Directive.ArgDescriptor[]{new Directive.LValueArg(1), new Directive.KeywordArg(2, "from"), new Directive.RValueArg(3), new Directive.KeywordArg(4, "to"), new Directive.RValueArg(5), new Directive.OptionalGroup(2), new Directive.KeywordArg(6, "step"), new Directive.RValueArg(7), new Directive.BlockArg(8)};
    private static final DirectiveDescriptor _desc = new DirectiveDescriptor("count", null, _args, null);
    private Variable _iterator;
    private Macro _body;
    private Object _objStart;
    private Object _objEnd;
    private Object _objStep;
    private int _start;
    private int _end;
    private int _step = Integer.MAX_VALUE;

    public static DirectiveDescriptor getDescriptor() {
        return _desc;
    }

    public Object build(DirectiveBuilder builder, BuildContext bc) throws BuildException {
        try {
            this._iterator = (Variable)builder.getArg(1, bc);
        }
        catch (ClassCastException e) {
            throw new Directive.NotVariableBuildException(CountDirective._desc.name, e);
        }
        this._objStart = builder.getArg(3, bc);
        this._objEnd = builder.getArg(5, bc);
        this._objStep = builder.getArg(7, bc);
        this._body = (Block)builder.getArg(8, bc);
        if (this._objStart != null) {
            if (this._objStart instanceof Number) {
                this._start = ((Number)this._objStart).intValue();
                this._objStart = null;
            } else if (this._objStart instanceof String) {
                this._start = Integer.parseInt((String)this._objStart);
                this._objStart = null;
            }
        }
        if (this._objEnd != null) {
            if (this._objEnd instanceof Number) {
                this._end = ((Number)this._objEnd).intValue();
                this._objEnd = null;
            } else if (this._objEnd instanceof String) {
                this._end = Integer.parseInt((String)this._objEnd);
                this._objEnd = null;
            }
        }
        if (this._objStep != null) {
            if (this._objStep instanceof Number) {
                this._step = ((Number)this._objStep).intValue();
                this._objStep = null;
            } else if (this._objStep instanceof String) {
                this._step = Integer.parseInt((String)this._objStep);
                this._objStep = null;
            }
        }
        return this;
    }

    public void write(FastWriter out, Context context) throws PropertyException, IOException {
        int start = this._start;
        int end = this._end;
        int step = this._step;
        boolean error = false;
        try {
            if (this._objStart != null) {
                start = this.evalAsInt(context, this._objStart);
            }
            if (this._objEnd != null) {
                end = this.evalAsInt(context, this._objEnd);
            }
            if (this._objStep != null) {
                step = this.evalAsInt(context, this._objStep);
            }
        }
        catch (Exception e) {
            out.write(context.getEvaluationExceptionHandler().expand(this._iterator, context, e));
            error = true;
        }
        if (!error) {
            if (step == Integer.MAX_VALUE) {
                int n = step = start > end ? -1 : 1;
            }
            if (step > 0) {
                while (start <= end) {
                    this._iterator.setValue(context, new Integer(start));
                    this._body.write(out, context);
                    start += step;
                }
            } else if (step < 0) {
                while (start >= end) {
                    this._iterator.setValue(context, new Integer(start));
                    this._body.write(out, context);
                    start += step;
                }
            } else {
                PropertyException.UndefinedVariableException pe = new PropertyException.UndefinedVariableException();
                ((PropertyException)pe).setMessage("#count: step cannot be 0.");
                out.write(context.getEvaluationExceptionHandler().expand(this._iterator, context, pe));
            }
        }
    }

    private int evalAsInt(Context context, Object o) throws PropertyException {
        if (o != null) {
            while (o instanceof Macro && o != UndefinedMacro.getInstance()) {
                o = ((Macro)o).evaluate(context);
            }
            if (o == UndefinedMacro.getInstance()) {
                PropertyException.UndefinedVariableException pe = new PropertyException.UndefinedVariableException();
                ((PropertyException)pe).setMessage("Undefined expression in #count directive.");
                throw pe;
            }
        }
        if (o == null) {
            PropertyException.UndefinedVariableException pe = new PropertyException.UndefinedVariableException();
            ((PropertyException)pe).setMessage("Null expression in #count directive.");
            throw pe;
        }
        if (o instanceof Number) {
            return ((Number)o).intValue();
        }
        try {
            return Integer.parseInt(o.toString());
        }
        catch (NumberFormatException e) {
            PropertyException.UndefinedVariableException pe = new PropertyException.UndefinedVariableException();
            ((PropertyException)pe).setMessage("Invalid numeric expression in #count directive: [" + o + "]");
            throw pe;
        }
    }
}

