/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.directive;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.StringTokenizer;
import org.webmacro.Broker;
import org.webmacro.Context;
import org.webmacro.FastWriter;
import org.webmacro.Log;
import org.webmacro.Macro;
import org.webmacro.NotFoundException;
import org.webmacro.PropertyException;
import org.webmacro.ResourceException;
import org.webmacro.Template;
import org.webmacro.TemplateVisitor;
import org.webmacro.directive.Directive;
import org.webmacro.directive.DirectiveBuilder;
import org.webmacro.directive.DirectiveDescriptor;
import org.webmacro.engine.BuildContext;
import org.webmacro.engine.BuildException;

public class IncludeDirective
extends Directive {
    public static final int TYPE_TEMPLATE = 0;
    public static final int TYPE_MACRO = 1;
    public static final int TYPE_TEXT = 2;
    public static final int TYPE_DYNAMIC = 3;
    private static final int PARSE_AS_K = 1;
    private static final int PARSE_TEMPLATE_K = 2;
    private static final int PARSE_TEXT_K = 3;
    private static final int PARSE_MACRO_K = 4;
    private static final int PARSE_FILENAME = 5;
    private static final Directive.ArgDescriptor[] _args = new Directive.ArgDescriptor[]{new Directive.OptionalGroup(4), new Directive.KeywordArg(1, "as"), new Directive.OptionalGroup(1), new Directive.KeywordArg(2, "template"), new Directive.OptionalGroup(1), new Directive.KeywordArg(3, "text"), new Directive.OptionalGroup(1), new Directive.KeywordArg(4, "macro"), new Directive.QuotedStringArg(5)};
    private static final DirectiveDescriptor _desc = new DirectiveDescriptor("include", null, _args, null);
    private String TEMPLATE_EXTENSIONS_NAME = ".TemplateExtensions";
    protected Log _log;
    protected int _type;
    protected Macro _macFilename;
    protected String _strFilename;
    protected String _directiveName;

    public static DirectiveDescriptor getDescriptor() {
        return _desc;
    }

    public final Object build(DirectiveBuilder builder, BuildContext bc) throws BuildException {
        Broker broker = bc.getBroker();
        this._log = bc.getLog("IncludeDirective");
        this._directiveName = builder.getName();
        this.TEMPLATE_EXTENSIONS_NAME = this._directiveName + this.TEMPLATE_EXTENSIONS_NAME;
        this._type = builder.getArg(3, bc) != null ? 2 : (builder.getArg(2, bc) != null ? 0 : (builder.getArg(4, bc) != null ? 1 : 3));
        Object o = builder.getArg(5, bc);
        if (o instanceof Macro) {
            if (this._type == 2 || this._type == 1) {
                this._log.warning("Included a 'static' file type using a dynamic filename. File will be included, but any included #macro's will not at " + bc.getCurrentLocation());
            }
            this._macFilename = (Macro)o;
        } else {
            this._strFilename = o.toString();
            if (this._strFilename == null || this._strFilename.length() == 0) {
                throw this.makeBuildException("Filename cannot be null or empty");
            }
            if (this._type == 2) {
                try {
                    return this.getThingToInclude(broker, this._type, this._strFilename);
                }
                catch (Exception e) {
                    throw this.makeBuildException("Unable to include as text", e);
                }
            }
            if (this._type == 1) {
                Template t = null;
                try {
                    t = this.getTemplate(broker, this._strFilename);
                    bc.mergeConstants(t);
                }
                catch (Exception e) {
                    throw this.makeBuildException("Unable to include as macro", e);
                }
                try {
                    return t.evaluateAsString(bc);
                }
                catch (PropertyException e) {
                    return "";
                }
            }
            if (this._type == 3) {
                this._type = this.guessType(broker, this._strFilename);
            }
        }
        return this;
    }

    public void write(FastWriter out, Context context) throws PropertyException, IOException {
        Broker broker = context.getBroker();
        if (this._macFilename != null) {
            this._strFilename = this._macFilename.evaluate(context).toString();
            if (this._strFilename == null || this._strFilename.length() == 0) {
                throw this.makePropertyException("Filename cannot be null or empty");
            }
        }
        if (this._log.loggingDebug() && context.getCurrentLocation().indexOf(this._strFilename) > -1) {
            this._log.warning(context.getCurrentLocation() + " includes itself.");
        }
        if (this._type == 3) {
            this._type = this.guessType(broker, this._strFilename);
        }
        if (this._log.loggingDebug()) {
            this._log.debug("Including '" + this._strFilename + "' as " + (this._type == 1 ? "MACRO" : (this._type == 0 ? "TEMPLATE" : (this._type == 2 ? "TEXT" : "UNKNOWN.  Throwing exception"))));
        }
        Object toInclude = this.getThingToInclude(broker, this._type, this._strFilename);
        switch (this._type) {
            case 0: 
            case 1: {
                ((Template)toInclude).write(out, context);
                break;
            }
            case 2: {
                out.write(toInclude.toString());
                break;
            }
            default: {
                throw this.makePropertyException("Unrecognized file type: " + this._type);
            }
        }
    }

    protected String[] getTemplateExtensions(Broker b) {
        String[] ret = (String[])b.getBrokerLocal(this.TEMPLATE_EXTENSIONS_NAME);
        if (ret == null) {
            String prop = b.getSettings().getSetting(this.TEMPLATE_EXTENSIONS_NAME, "wm");
            StringTokenizer st = new StringTokenizer(prop, ",; ");
            ret = new String[st.countTokens()];
            int x = 0;
            while (st.hasMoreElements()) {
                ret[x] = st.nextToken();
                ++x;
            }
            b.setBrokerLocal(this.TEMPLATE_EXTENSIONS_NAME, ret);
        }
        return ret;
    }

    protected int guessType(Broker b, String filename) {
        if (filename.indexOf("://") > -1) {
            return 2;
        }
        String[] extensions = this.getTemplateExtensions(b);
        for (int x = 0; x < extensions.length; ++x) {
            if (!filename.endsWith(extensions[x])) continue;
            return 0;
        }
        return 2;
    }

    protected Object getThingToInclude(Broker b, int type, String filename) throws PropertyException {
        switch (type) {
            case 0: {
                return this.getTemplate(b, filename);
            }
            case 1: {
                return this.getTemplate(b, filename);
            }
            case 2: {
                return this.getFile(b, filename);
            }
            case 3: {
                throw this.makePropertyException("Internal Error.  Never guessed file type");
            }
        }
        throw this.makePropertyException("Internal Error.  Unrecognized file type: " + type);
    }

    protected Template getTemplate(Broker b, String name) throws PropertyException {
        try {
            return (Template)b.get("template", name);
        }
        catch (NotFoundException nfe) {
            throw this.makePropertyException("Not found by template provider");
        }
        catch (ResourceException re) {
            throw this.makePropertyException("Unable to get template", re);
        }
        catch (Exception e) {
            throw this.makePropertyException("Unexpected ectpion while getting template");
        }
    }

    protected String getFile(Broker b, String name) throws PropertyException {
        try {
            return b.get("url", name).toString();
        }
        catch (Exception e) {
            URL url = null;
            try {
                url = b.getResource(name);
                if (url == null) {
                    throw this.makePropertyException("Resource not found by URL provider or Broker");
                }
                URLConnection conn = url.openConnection();
                StringBuffer sb = new StringBuffer();
                InputStream in = conn.getInputStream();
                String enc = conn.getContentEncoding();
                if (enc == null) {
                    enc = b.getSetting("TemplateEncoding");
                }
                int cnt = 0;
                byte[] buff = new byte[4096];
                while ((cnt = in.read(buff)) > 0) {
                    sb.append(new String(buff, 0, cnt, enc));
                }
                in.close();
                return sb.toString();
            }
            catch (IOException ioe) {
                throw this.makePropertyException("Error streaming file from: " + url, ioe);
            }
        }
    }

    public void accept(TemplateVisitor v) {
        v.beginDirective(IncludeDirective._desc.name);
        v.visitDirectiveArg("IncludeDirective", this._strFilename);
        v.endDirective();
    }

    private BuildException makeBuildException(String message) {
        return this.makeBuildException(message, null);
    }

    private BuildException makeBuildException(String message, Exception cause) {
        message = "#" + this._directiveName + " " + this._strFilename + ": " + message;
        if (cause != null) {
            return new BuildException(message, cause);
        }
        return new BuildException(message);
    }

    private PropertyException makePropertyException(String message) {
        return this.makePropertyException(message, null);
    }

    private PropertyException makePropertyException(String message, Exception cause) {
        message = "#" + this._directiveName + " " + this._strFilename + ": " + message;
        if (cause != null) {
            return new PropertyException(message, cause);
        }
        return new PropertyException(message);
    }
}

