/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.engine;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Stack;
import org.webmacro.Context;
import org.webmacro.Macro;
import org.webmacro.engine.Block;
import org.webmacro.engine.BuildContext;
import org.webmacro.engine.BuildException;
import org.webmacro.engine.Builder;

public class BlockBuilder
implements Builder {
    private static final int INITIAL_SIZE = 64;
    private static Macro[] mArray = new Macro[0];
    private static String[] sArray = new String[0];
    private ArrayList elements = new ArrayList();
    private int[] lineNos = new int[64];
    private int[] colNos = new int[64];
    private String name = "unknown";

    public BlockBuilder() {
    }

    public BlockBuilder(String name) {
        this.name = name;
    }

    public final Object build(BuildContext bc) throws BuildException {
        ArrayList<String> strings = new ArrayList<String>(this.elements.size());
        ArrayList macros = new ArrayList(this.elements.size());
        int[] ln = new int[this.elements.size()];
        int[] cn = new int[this.elements.size()];
        Stack<BBIterator> iterStack = new Stack<BBIterator>();
        StringBuffer s = new StringBuffer();
        Context.TemplateEvaluationContext tec = bc.getTemplateEvaluationContext();
        BlockIterator iter = new BBIterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (o instanceof Builder) {
                tec._templateName = iter.getName();
                tec._lineNo = iter.getLineNo();
                tec._columnNo = iter.getColNo();
                try {
                    o = ((Builder)o).build(bc);
                }
                catch (BuildException be) {
                    tec._templateName = iter.getName();
                    tec._lineNo = iter.getLineNo();
                    tec._columnNo = iter.getColNo();
                    throw be;
                }
            }
            if (o instanceof Block) {
                iterStack.push((BBIterator)iter);
                iter = ((Block)o).getBlockIterator();
            } else if (o instanceof Macro) {
                strings.add(s.toString());
                s = new StringBuffer();
                macros.add(o);
                int size = macros.size();
                if (ln.length < size) {
                    ln = BlockBuilder.resizeIntArray(ln, ln.length * 2);
                    cn = BlockBuilder.resizeIntArray(cn, cn.length * 2);
                }
                ln[size - 1] = iter.getLineNo();
                cn[size - 1] = iter.getColNo();
            } else if (o != null) {
                s.append(o.toString());
            }
            while (!iter.hasNext() && !iterStack.empty()) {
                iter = (BlockIterator)iterStack.pop();
            }
        }
        strings.add(s.toString());
        Macro[] finalMacros = macros.toArray(mArray);
        String[] finalStrings = strings.toArray(sArray);
        int[] finalLines = BlockBuilder.resizeIntArray(ln, macros.size());
        int[] finalCols = BlockBuilder.resizeIntArray(cn, macros.size());
        return new Block(this.name, finalStrings, finalMacros, finalLines, finalCols);
    }

    private static int[] resizeIntArray(int[] ia, int size) {
        int[] temp = new int[size];
        System.arraycopy(ia, 0, temp, 0, Math.min(ia.length, size));
        return temp;
    }

    public void addElement(Object o) {
        this.elements.add(o);
    }

    public void addElement(Object o, int lineNo, int colNo) {
        this.elements.add(o);
        int size = this.elements.size();
        if (this.lineNos.length < size) {
            this.lineNos = BlockBuilder.resizeIntArray(this.lineNos, Math.max(this.lineNos.length * 2, size + 64));
            this.colNos = BlockBuilder.resizeIntArray(this.colNos, Math.max(this.colNos.length * 2, size + 64));
        }
        this.lineNos[size - 1] = lineNo;
        this.colNos[size - 1] = colNo;
    }

    public int size() {
        return this.elements.size();
    }

    public void remove(int i) {
        this.elements.remove(i);
    }

    public Object elementAt(int i) {
        return this.elements.get(i);
    }

    public Object setElementAt(Object o, int i) {
        return this.elements.set(i, o);
    }

    public class BBIterator
    implements BlockIterator {
        private int size;
        private int i;

        public BBIterator() {
            this.size = BlockBuilder.this.elements.size();
            this.i = 0;
        }

        public String getName() {
            return BlockBuilder.this.name;
        }

        public boolean hasNext() {
            return this.i < this.size;
        }

        public Object next() {
            return BlockBuilder.this.elements.get(this.i++);
        }

        public int getLineNo() {
            return BlockBuilder.this.lineNos[this.i - 1];
        }

        public int getColNo() {
            return BlockBuilder.this.colNos[this.i - 1];
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static interface BlockIterator
    extends Iterator {
        public String getName();

        public int getLineNo();

        public int getColNo();
    }
}

