/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.engine;

import java.util.ArrayList;
import org.webmacro.Broker;
import org.webmacro.Context;
import org.webmacro.Log;
import org.webmacro.PropertyException;
import org.webmacro.engine.EvaluationExceptionHandler;
import org.webmacro.engine.Variable;
import org.webmacro.util.Settings;

public class DebugEvaluationExceptionHandler
implements EvaluationExceptionHandler {
    private Log _log;

    public DebugEvaluationExceptionHandler() {
    }

    public DebugEvaluationExceptionHandler(Broker b) {
        this.init(b, b.getSettings());
    }

    public void init(Broker b, Settings config) {
        this._log = b.getLog("engine");
    }

    public void evaluate(Variable variable, Context context, Exception problem) throws PropertyException {
        this.handleError(variable, context, problem);
    }

    public String expand(Variable variable, Context context, Exception problem) throws PropertyException {
        return this.handleError(variable, context, problem);
    }

    private String handleError(Variable variable, Context context, Exception problem) throws PropertyException {
        ArrayList arlErrors = null;
        PropertyException propEx = null;
        propEx = problem instanceof PropertyException ? (PropertyException)problem : new PropertyException("Error expanding $" + variable.getVariableName());
        propEx.setContextLocation(context.getCurrentLocation());
        String strError = propEx.getMessage();
        if (context.containsKey("WMERROR") && context.get("WMERROR") instanceof ArrayList) {
            arlErrors = (ArrayList)context.get("WMERROR");
        } else {
            arlErrors = new ArrayList();
            context.put((Object)"WMERROR", arlErrors);
        }
        if (strError.lastIndexOf("\r\n") >= 0) {
            strError = strError.substring(strError.lastIndexOf("\r\n"));
            strError = strError.trim();
        }
        if (!arlErrors.contains(strError)) {
            arlErrors.add(strError);
        }
        if (this._log != null) {
            this._log.warning(strError, propEx);
        }
        throw propEx;
    }

    public String warningString(String strText) throws PropertyException {
        throw new PropertyException("Evaluation warning: " + strText);
    }

    public String errorString(String strText) throws PropertyException {
        throw new PropertyException("Evaluation error: " + strText);
    }
}

