/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.engine;

import java.io.IOException;
import org.webmacro.Context;
import org.webmacro.FastWriter;
import org.webmacro.Macro;
import org.webmacro.PropertyException;
import org.webmacro.TemplateVisitor;
import org.webmacro.Visitable;
import org.webmacro.engine.BuildContext;
import org.webmacro.engine.BuildException;
import org.webmacro.engine.Builder;
import org.webmacro.engine.UndefinedMacro;

public abstract class Expression {
    private static final UndefinedMacro UNDEF = UndefinedMacro.getInstance();
    private static final Boolean TRUE = Boolean.TRUE;
    private static final Boolean FALSE = Boolean.FALSE;

    public static boolean isTrue(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        return o != UNDEF;
    }

    public static boolean isNumber(Object o) {
        return o instanceof Number;
    }

    public static Object numberObject(long result, Object op1, Object op2) {
        if (op1.getClass() == Long.class || op2.getClass() == Long.class) {
            return new Long(result);
        }
        return new Integer((int)result);
    }

    public static long numberValue(Object o) {
        return ((Number)o).longValue();
    }

    public static class CompareGtBuilder
    extends BinaryOperationBuilder {
        public CompareGtBuilder(Object l, Object r) {
            super(l, r);
        }

        public Object build(Object l, Object r) throws BuildException {
            CompareGt c = new CompareGt(l, r);
            if (l instanceof Macro || r instanceof Macro) {
                return c;
            }
            try {
                return c.operate(l, r);
            }
            catch (PropertyException e) {
                throw new BuildException(e.toString());
            }
        }
    }

    public static class CompareGeBuilder
    extends BinaryOperationBuilder {
        public CompareGeBuilder(Object l, Object r) {
            super(l, r);
        }

        public Object build(Object l, Object r) throws BuildException {
            CompareGe c = new CompareGe(l, r);
            if (l instanceof Macro || r instanceof Macro) {
                return c;
            }
            try {
                return c.operate(l, r);
            }
            catch (PropertyException e) {
                throw new BuildException(e.toString());
            }
        }
    }

    public static class CompareLtBuilder
    extends BinaryOperationBuilder {
        public CompareLtBuilder(Object l, Object r) {
            super(l, r);
        }

        public Object build(Object l, Object r) throws BuildException {
            CompareLt c = new CompareLt(l, r);
            if (l instanceof Macro || r instanceof Macro) {
                return c;
            }
            try {
                return c.operate(l, r);
            }
            catch (PropertyException e) {
                throw new BuildException(e.toString());
            }
        }
    }

    public static class CompareLeBuilder
    extends BinaryOperationBuilder {
        public CompareLeBuilder(Object l, Object r) {
            super(l, r);
        }

        public Object build(Object l, Object r) throws BuildException {
            CompareLe c = new CompareLe(l, r);
            if (l instanceof Macro || r instanceof Macro) {
                return c;
            }
            try {
                return c.operate(l, r);
            }
            catch (PropertyException e) {
                throw new BuildException(e.toString());
            }
        }
    }

    public static class CompareNeBuilder
    extends BinaryOperationBuilder {
        public CompareNeBuilder(Object l, Object r) {
            super(l, r);
        }

        public Object build(Object l, Object r) throws BuildException {
            CompareNe c = new CompareNe(l, r);
            if (l instanceof Macro || r instanceof Macro) {
                return c;
            }
            try {
                return c.operate(l, r);
            }
            catch (PropertyException e) {
                throw new BuildException(e.toString());
            }
        }
    }

    public static class CompareEqBuilder
    extends BinaryOperationBuilder {
        public CompareEqBuilder(Object l, Object r) {
            super(l, r);
        }

        public Object build(Object l, Object r) throws BuildException {
            CompareEq c = new CompareEq(l, r);
            if (l instanceof Macro || r instanceof Macro) {
                return c;
            }
            try {
                return c.operate(l, r);
            }
            catch (PropertyException e) {
                throw new BuildException(e.toString());
            }
        }
    }

    public static class DivideBuilder
    extends BinaryOperationBuilder {
        public DivideBuilder(Object l, Object r) {
            super(l, r);
        }

        public Object build(Object l, Object r) throws BuildException {
            if (!(l instanceof Macro) && !(r instanceof Macro)) {
                if (Expression.isNumber(l) && Expression.isNumber(r)) {
                    long denom = Expression.numberValue(r);
                    if (denom == 0L) {
                        throw new BuildException("Divide by zero");
                    }
                    return Expression.numberObject(Expression.numberValue(l) / denom, l, r);
                }
                throw new BuildException("Divide requires numeric operands");
            }
            return new DivideOperation(l, r);
        }
    }

    public static class MultiplyBuilder
    extends BinaryOperationBuilder {
        public MultiplyBuilder(Object l, Object r) {
            super(l, r);
        }

        public Object build(Object l, Object r) throws BuildException {
            if (!(l instanceof Macro) && !(r instanceof Macro)) {
                if (Expression.isNumber(l) && Expression.isNumber(r)) {
                    return Expression.numberObject(Expression.numberValue(l) * Expression.numberValue(r), l, r);
                }
                throw new BuildException("Multiply requires numeric operands");
            }
            return new MultiplyOperation(l, r);
        }
    }

    public static class SubtractBuilder
    extends BinaryOperationBuilder {
        public SubtractBuilder(Object l, Object r) {
            super(l, r);
        }

        public Object build(Object l, Object r) throws BuildException {
            if (!(l instanceof Macro) && !(r instanceof Macro)) {
                if (Expression.isNumber(l) && Expression.isNumber(r)) {
                    return Expression.numberObject(Expression.numberValue(l) - Expression.numberValue(r), l, r);
                }
                throw new BuildException("Subtract requires numeric operands");
            }
            return new SubtractOperation(l, r);
        }
    }

    public static class AddBuilder
    extends BinaryOperationBuilder {
        public AddBuilder(Object l, Object r) {
            super(l, r);
        }

        public Object build(Object l, Object r) throws BuildException {
            if (!(l instanceof Macro) && !(r instanceof Macro)) {
                if (Expression.isNumber(l) && Expression.isNumber(r)) {
                    return Expression.numberObject(Expression.numberValue(l) + Expression.numberValue(r), l, r);
                }
                throw new BuildException("Add requires numeric operands");
            }
            return new AddOperation(l, r);
        }
    }

    public static class NotBuilder
    extends UnaryOperationBuilder {
        public NotBuilder(Object o) {
            super(o);
        }

        public Object build(Object o) {
            if (o instanceof Macro) {
                return new NotOperation(o);
            }
            return !Expression.isTrue(o) ? TRUE : FALSE;
        }
    }

    public static class OrBuilder
    extends BinaryOperationBuilder {
        public OrBuilder(Object l, Object r) {
            super(l, r);
        }

        public Object build(Object l, Object r) {
            if (l instanceof Macro) {
                if (r instanceof Macro) {
                    return new OrOperation(l, r);
                }
                return Expression.isTrue(r) ? TRUE : l;
            }
            if (r instanceof Macro) {
                return Expression.isTrue(l) ? TRUE : r;
            }
            return Expression.isTrue(l) || Expression.isTrue(r) ? TRUE : FALSE;
        }
    }

    public static class AndBuilder
    extends BinaryOperationBuilder {
        public AndBuilder(Object l, Object r) {
            super(l, r);
        }

        public Object build(Object l, Object r) {
            if (l instanceof Macro) {
                if (r instanceof Macro) {
                    return new AndOperation(l, r);
                }
                return Expression.isTrue(r) ? l : FALSE;
            }
            if (r instanceof Macro) {
                return Expression.isTrue(l) ? r : FALSE;
            }
            return Expression.isTrue(l) && Expression.isTrue(r) ? TRUE : FALSE;
        }
    }

    public static abstract class UnaryOperationBuilder
    implements Builder {
        private Object _o;

        public UnaryOperationBuilder(Object o) {
            this._o = o;
        }

        public abstract Object build(Object var1) throws BuildException;

        public Object build(BuildContext pc) throws BuildException {
            Object o = this._o instanceof Builder ? ((Builder)this._o).build(pc) : this._o;
            return this.build(o);
        }
    }

    public static abstract class BinaryOperationBuilder
    implements Builder {
        private Object _l;
        private Object _r;

        public BinaryOperationBuilder(Object l, Object r) {
            this._l = l;
            this._r = r;
        }

        public abstract Object build(Object var1, Object var2) throws BuildException;

        public Object build(BuildContext pc) throws BuildException {
            Object l = this._l instanceof Builder ? ((Builder)this._l).build(pc) : this._l;
            Object r = this._r instanceof Builder ? ((Builder)this._r).build(pc) : this._r;
            return this.build(l, r);
        }
    }

    public static class CompareGt
    extends Compare {
        public CompareGt(Object l, Object r) {
            super(l, r);
        }

        public String getName() {
            return "CompareGt";
        }

        public Boolean compare(String l, String r) {
            return l.compareTo(r) > 0 ? TRUE : FALSE;
        }

        public Boolean compare(long l, long r) {
            return l > r ? TRUE : FALSE;
        }
    }

    public static class CompareGe
    extends Compare {
        public CompareGe(Object l, Object r) {
            super(l, r);
        }

        public String getName() {
            return "CompareGe";
        }

        public Boolean compare(String l, String r) {
            return l.compareTo(r) >= 0 ? TRUE : FALSE;
        }

        public Boolean compare(long l, long r) {
            return l >= r ? TRUE : FALSE;
        }
    }

    public static class CompareLt
    extends Compare {
        public CompareLt(Object l, Object r) {
            super(l, r);
        }

        public String getName() {
            return "CompareLt";
        }

        public Boolean compare(String l, String r) {
            return l.compareTo(r) < 0 ? TRUE : FALSE;
        }

        public Boolean compare(long l, long r) {
            return l < r ? TRUE : FALSE;
        }
    }

    public static class CompareLe
    extends Compare {
        public CompareLe(Object l, Object r) {
            super(l, r);
        }

        public String getName() {
            return "CompareLe";
        }

        public Boolean compare(String l, String r) {
            return l.compareTo(r) <= 0 ? TRUE : FALSE;
        }

        public Boolean compare(long l, long r) {
            return l <= r ? TRUE : FALSE;
        }
    }

    public static class CompareNe
    extends Compare {
        public CompareNe(Object l, Object r) {
            super(l, r);
        }

        public String getName() {
            return "CompareNe";
        }

        public Boolean compare(Object l, Object r) {
            return !l.equals(r) ? TRUE : FALSE;
        }

        public Boolean compare(String l, String r) {
            return !l.equals(r) ? TRUE : FALSE;
        }

        public Boolean compare(long l, long r) {
            return l != r ? TRUE : FALSE;
        }

        public Boolean compareNull(Object o) {
            return o != null ? TRUE : FALSE;
        }
    }

    public static class CompareEq
    extends Compare {
        public CompareEq(Object l, Object r) {
            super(l, r);
        }

        public String getName() {
            return "CompareEq";
        }

        public Boolean compare(Object l, Object r) {
            return l.equals(r) ? TRUE : FALSE;
        }

        public Boolean compare(String l, String r) {
            return l.equals(r) ? TRUE : FALSE;
        }

        public Boolean compare(long l, long r) {
            return l == r ? TRUE : FALSE;
        }

        public Boolean compareNull(Object o) {
            return o == null ? TRUE : FALSE;
        }
    }

    public static abstract class Compare
    extends BinaryOperation {
        public Compare(Object l, Object r) {
            super(l, r);
        }

        public abstract Boolean compare(String var1, String var2);

        public abstract Boolean compare(long var1, long var3);

        public Boolean compare(Object l, Object r) {
            return null;
        }

        public Boolean compareNull(Object o) {
            return null;
        }

        public Object operate(Object l, Object r) throws PropertyException {
            Boolean b = null;
            boolean lIsNumber = Expression.isNumber(l);
            boolean rIsNumber = Expression.isNumber(r);
            if (lIsNumber && rIsNumber) {
                b = this.compare(Expression.numberValue(l), Expression.numberValue(r));
            } else {
                boolean lIsString = l instanceof String;
                boolean rIsString = r instanceof String;
                b = lIsString && rIsString ? this.compare((String)l, (String)r) : (lIsString && rIsNumber ? this.compare((String)l, Long.toString(Expression.numberValue(r))) : (lIsNumber && rIsString ? this.compare(Long.toString(Expression.numberValue(l)), (String)r) : (l == null ? this.compareNull(r) : (r == null ? this.compareNull(l) : this.compare(l, r)))));
            }
            if (b == null) {
                throw new PropertyException("Objects not comparable");
            }
            return b;
        }
    }

    public static class DivideOperation
    extends BinaryOperation {
        public DivideOperation(Object l, Object r) {
            super(l, r);
        }

        public String getName() {
            return "Divide";
        }

        public Object operate(Object l, Object r) throws PropertyException {
            if (!Expression.isNumber(l) || !Expression.isNumber(r)) {
                throw new PropertyException("Divide requires numeric operands");
            }
            long denom = Expression.numberValue(r);
            if (denom == 0L) {
                throw new PropertyException("Divide by zero");
            }
            return Expression.numberObject(Expression.numberValue(l) / denom, l, r);
        }
    }

    public static class MultiplyOperation
    extends BinaryOperation {
        public MultiplyOperation(Object l, Object r) {
            super(l, r);
        }

        public String getName() {
            return "Multiply";
        }

        public Object operate(Object l, Object r) throws PropertyException {
            if (!Expression.isNumber(l) || !Expression.isNumber(r)) {
                throw new PropertyException("Multiply requires numeric operands");
            }
            return Expression.numberObject(Expression.numberValue(l) * Expression.numberValue(r), l, r);
        }
    }

    public static class SubtractOperation
    extends BinaryOperation {
        public SubtractOperation(Object l, Object r) {
            super(l, r);
        }

        public String getName() {
            return "Subtract";
        }

        public Object operate(Object l, Object r) throws PropertyException {
            if (!Expression.isNumber(l) || !Expression.isNumber(r)) {
                throw new PropertyException("Subtract requires numeric operands");
            }
            return Expression.numberObject(Expression.numberValue(l) - Expression.numberValue(r), l, r);
        }
    }

    public static class AddOperation
    extends BinaryOperation {
        public AddOperation(Object l, Object r) {
            super(l, r);
        }

        public String getName() {
            return "Add";
        }

        public Object operate(Object l, Object r) throws PropertyException {
            if (!Expression.isNumber(l) || !Expression.isNumber(r)) {
                throw new PropertyException("Add requires numeric operands");
            }
            return Expression.numberObject(Expression.numberValue(l) + Expression.numberValue(r), l, r);
        }
    }

    public static class NotOperation
    extends UnaryOperation {
        public NotOperation(Object o) {
            super(o);
        }

        public String getName() {
            return "Not";
        }

        public Object operate(Object o) {
            return !Expression.isTrue(o) ? TRUE : FALSE;
        }
    }

    public static class OrOperation
    extends ExpressionBase {
        private Object _l;
        private Object _r;

        public OrOperation(Object l, Object r) {
            this._l = l;
            this._r = r;
        }

        public Object evaluate(Context context) throws PropertyException {
            Object r;
            Object l;
            Object object = l = this._l instanceof Macro ? ((Macro)this._l).evaluate(context) : this._l;
            if (Expression.isTrue(l)) {
                return TRUE;
            }
            Object object2 = r = this._r instanceof Macro ? ((Macro)this._r).evaluate(context) : this._r;
            if (Expression.isTrue(r)) {
                return TRUE;
            }
            return FALSE;
        }

        public void accept(TemplateVisitor v) {
            v.visitBinaryOperation("Or", this._l, this._r);
        }
    }

    public static class AndOperation
    extends ExpressionBase {
        private Object _l;
        private Object _r;

        public AndOperation(Object l, Object r) {
            this._l = l;
            this._r = r;
        }

        public Object evaluate(Context context) throws PropertyException {
            Object r;
            Object l;
            Object object = l = this._l instanceof Macro ? ((Macro)this._l).evaluate(context) : this._l;
            if (!Expression.isTrue(l)) {
                return FALSE;
            }
            Object object2 = r = this._r instanceof Macro ? ((Macro)this._r).evaluate(context) : this._r;
            if (!Expression.isTrue(r)) {
                return FALSE;
            }
            return TRUE;
        }

        public void accept(TemplateVisitor v) {
            v.visitBinaryOperation("And", this._l, this._r);
        }
    }

    public static abstract class UnaryOperation
    extends ExpressionBase {
        private Object _o;

        UnaryOperation(Object o) {
            this._o = o;
        }

        public abstract Object operate(Object var1);

        public Object evaluate(Context context) throws PropertyException {
            Object o = this._o instanceof Macro ? ((Macro)this._o).evaluate(context) : this._o;
            return this.operate(o);
        }

        public abstract String getName();

        public void accept(TemplateVisitor v) {
            v.visitUnaryOperation(this.getName(), this._o);
        }
    }

    public static abstract class BinaryOperation
    extends ExpressionBase {
        private Object _l;
        private Object _r;

        BinaryOperation(Object l, Object r) {
            this._l = l;
            this._r = r;
        }

        public abstract Object operate(Object var1, Object var2) throws PropertyException;

        public Object evaluate(Context context) throws PropertyException {
            Object l = this._l instanceof Macro ? ((Macro)this._l).evaluate(context) : this._l;
            Object r = this._r instanceof Macro ? ((Macro)this._r).evaluate(context) : this._r;
            return this.operate(l, r);
        }

        public abstract String getName();

        public void accept(TemplateVisitor v) {
            v.visitBinaryOperation(this.getName(), this._l, this._r);
        }
    }

    public static abstract class ExpressionBase
    implements Macro,
    Visitable {
        protected ExpressionBase() {
        }

        public final void write(FastWriter out, Context context) throws PropertyException, IOException {
            out.write(this.evaluate(context).toString());
        }
    }
}

