/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.engine;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.webmacro.Broker;
import org.webmacro.engine.WMTemplate;

public class FileTemplate
extends WMTemplate {
    private final File myFile;
    private final String myEncoding;

    public FileTemplate(Broker broker, String filename) {
        this(broker, new File(filename), null);
    }

    public FileTemplate(Broker broker, File templateFile) {
        this(broker, templateFile, null);
    }

    public FileTemplate(Broker broker, File tmplFile, String encoding) {
        super(broker);
        this.myFile = tmplFile;
        this.myEncoding = encoding == null ? this.getDefaultEncoding() : encoding;
    }

    protected Reader getReader() throws IOException {
        return new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.myFile), this.myEncoding));
    }

    public String toString() {
        return "FileTemplate:" + this.myFile;
    }

    public String getName() {
        return this.myFile.getPath();
    }
}

