/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.engine;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Hashtable;
import org.webmacro.Broker;
import org.webmacro.InitException;
import org.webmacro.Log;
import org.webmacro.NotFoundException;
import org.webmacro.Provider;
import org.webmacro.engine.IntrospectionException;
import org.webmacro.engine.Parser;
import org.webmacro.util.Settings;

public final class ParserProvider
implements Provider {
    private final Hashtable _parsers = new Hashtable();
    private Broker _broker = null;
    private Log _log;
    private final Class[] _brokerParam = new Class[]{Broker.class};
    private final Object[] _brokerArg = new Object[1];

    public final void register(String pClassName, String pType) throws IntrospectionException, InitException {
        Class pclass;
        String pname = ParserProvider.extractName(pClassName);
        String name = pType != null && !pType.equals("") ? pType : pname;
        try {
            pclass = this._broker.classForName(pClassName);
        }
        catch (Exception e) {
            throw new IntrospectionException("No class " + pClassName);
        }
        try {
            this._log.info("Registering parser: " + name + " (" + pClassName + ")");
            Parser p = (Parser)this._parsers.get(name);
            if (p == null) {
                Constructor ctor = pclass.getConstructor(this._brokerParam);
                p = (Parser)ctor.newInstance(this._brokerArg);
                this._parsers.put(name, p);
            } else if (!pclass.equals(p.getClass())) {
                throw new InitException("Attempt to register parser " + pClassName + " failed because " + p.getClass() + " is already registered for type " + name);
            }
        }
        catch (InstantiationException ne) {
            throw new IntrospectionException("Parsers could not be instantiated", ne);
        }
        catch (IllegalAccessException ia) {
            throw new IntrospectionException("Parser class must be public", ia);
        }
        catch (InvocationTargetException it) {
            throw new InitException("Parser threw an exception", it);
        }
        catch (NoSuchMethodException nm) {
            throw new IntrospectionException("Parser missing the required constructor", nm);
        }
    }

    public final Parser getParser(String pname) throws NotFoundException {
        Parser p = (Parser)this._parsers.get(pname);
        if (p == null) {
            throw new NotFoundException("No parser registered for type " + pname);
        }
        return p;
    }

    private static String extractName(String par) throws IntrospectionException {
        if (!par.endsWith("Parser")) {
            throw new IntrospectionException("Malformed classname (" + par + "), must end with Parser");
        }
        int end = par.length() - 6;
        int start = par.lastIndexOf(46, end) + 1;
        String parName = par.substring(start, end);
        if (par.startsWith("org.webmacro.")) {
            parName = parName.toLowerCase();
        }
        return parName;
    }

    public String getType() {
        return "parser";
    }

    public void init(Broker broker, Settings p) throws InitException {
        this._brokerArg[0] = broker;
        this._broker = broker;
        this._log = broker.getLog("engine");
        try {
            p.processListSetting("Parsers", new SettingHandler());
        }
        catch (Exception e) {
            throw new InitException("Could not init ParserProvider", e);
        }
    }

    public void destroy() {
        this._parsers.clear();
    }

    public Object get(String name) throws NotFoundException {
        try {
            return this.getParser(name);
        }
        catch (Exception e) {
            throw new NotFoundException("No such parser: " + name, e);
        }
    }

    public void flush() {
    }

    private class SettingHandler
    extends Settings.ListSettingHandler {
        private SettingHandler() {
        }

        public void processSetting(String settingKey, String settingValue) {
            try {
                ParserProvider.this.register(settingValue, settingKey);
            }
            catch (Exception ce) {
                ParserProvider.this._log.error("Could not load parser: " + settingValue, ce);
            }
        }
    }
}

