/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.engine;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.webmacro.Context;
import org.webmacro.PropertyException;
import org.webmacro.engine.Accessor;
import org.webmacro.engine.BinaryMethodAccessor;
import org.webmacro.engine.DirectAccessor;
import org.webmacro.engine.FieldAccessor;
import org.webmacro.engine.LengthAccessor;
import org.webmacro.engine.MethodAccessor;
import org.webmacro.engine.PropertyOperatorCache;
import org.webmacro.engine.UnaryMethodAccessor;
import org.webmacro.engine.VoidMacro;
import org.webmacro.util.ArrayIterator;
import org.webmacro.util.EnumIterator;
import org.webmacro.util.PropertyMethod;

final class PropertyOperator {
    private final HashMap _unaryAccessors = new HashMap();
    private final HashMap _binaryAccessors = new HashMap();
    private final HashMap _directAccessors = new HashMap();
    private BinaryMethodAccessor _hashAccessor;
    private Method iteratorMethod = null;
    private static LengthAccessor _lengthAccessor = new LengthAccessor();
    private final PropertyOperatorCache _cache;
    static /* synthetic */ Class class$java$util$Iterator;
    static /* synthetic */ Class array$Ljava$lang$Object;
    static /* synthetic */ Class class$java$util$Enumeration;

    private void getAllMethods(HashMap meths, Class c) {
        int i;
        if (Modifier.isPublic(c.getModifiers())) {
            Method[] m = c.getDeclaredMethods();
            for (i = 0; i < m.length; ++i) {
                if (!Modifier.isPublic(m[i].getModifiers())) continue;
                this.addMethod(meths, m[i]);
            }
        }
        Class<?>[] iface = c.getInterfaces();
        for (i = 0; i < iface.length; ++i) {
            this.getAllMethods(meths, iface[i]);
        }
        Class sup = c.getSuperclass();
        if (sup != null) {
            this.getAllMethods(meths, sup);
        }
    }

    private int precedes(Class[] lhs, Class[] rhs) {
        if (lhs.length == rhs.length) {
            for (int i = 0; i < lhs.length; ++i) {
                if (rhs[i].equals(lhs[i])) continue;
                if (lhs[i].isAssignableFrom(rhs[i])) {
                    return 1;
                }
                if (rhs[i].isAssignableFrom(lhs[i])) {
                    return -1;
                }
                return 1;
            }
            return 0;
        }
        return lhs.length < rhs.length ? -1 : 1;
    }

    boolean isMethodAllowed(Method m) {
        Class<?> c = m.getDeclaringClass();
        Map restrictedClasses = this._cache.getRestrictedClassMap();
        if (restrictedClasses.containsKey(c)) {
            List okMeths = (List)restrictedClasses.get(c);
            return okMeths != null && okMeths.contains(m.getName());
        }
        return true;
    }

    boolean isMethodRestricted(Class c, String name) {
        Map restrictedClassMap = this._cache.getRestrictedClassMap();
        if (!restrictedClassMap.containsKey(c)) {
            return false;
        }
        Method[] meths = c.getMethods();
        for (int i = 0; i < meths.length; ++i) {
            List l;
            if (!meths[i].getName().equals(name) || (l = (List)restrictedClassMap.get(c)) == null) continue;
            return !l.contains(name);
        }
        return false;
    }

    private void addMethod(HashMap hm, Method m) {
        Vector<Object> v;
        if (!this.isMethodAllowed(m)) {
            return;
        }
        String name = m.getName();
        Object o = hm.get(name);
        if (o == null) {
            hm.put(name, m);
            return;
        }
        if (o instanceof Method) {
            v = new Vector<Object>();
            v.addElement(o);
            hm.put(name, v);
        } else {
            v = (Vector<Object>)o;
        }
        Class[] ptypes = m.getParameterTypes();
        for (int i = 0; i < v.size(); ++i) {
            Class[] curTypes = ((Method)v.elementAt(i)).getParameterTypes();
            int order = this.precedes(ptypes, curTypes);
            if (order < 0) {
                v.insertElementAt(m, i);
                return;
            }
            if (order != 0) continue;
            return;
        }
        v.addElement(m);
    }

    private Vector getMethods(Class c) {
        Vector<Object> v = new Vector<Object>();
        HashMap h = new HashMap();
        this.getAllMethods(h, c);
        Iterator iter = h.values().iterator();
        while (iter.hasNext()) {
            Object elem = iter.next();
            if (elem instanceof Method) {
                v.addElement(elem);
                continue;
            }
            Vector v1 = (Vector)elem;
            for (int i = 0; i < v1.size(); ++i) {
                v.addElement(v1.elementAt(i));
            }
        }
        return v;
    }

    public PropertyOperator(Class target, PropertyOperatorCache cache) throws PropertyException {
        Accessor acc;
        this._cache = cache;
        Field[] fields = target.getFields();
        for (int i = 0; i < fields.length; ++i) {
            if (!Modifier.isPublic(fields[i].getModifiers())) continue;
            acc = new FieldAccessor(fields[i]);
            this._unaryAccessors.put(acc.getName(), acc);
        }
        if (target.isArray()) {
            this._unaryAccessors.put("length", _lengthAccessor);
        }
        Vector methods = this.getMethods(target);
        for (int i = 0; i < methods.size(); ++i) {
            Class<?> returnType;
            Class iterClass;
            boolean iterA;
            String propName;
            Method meth = (Method)methods.elementAt(i);
            if (!this.isMethodAllowed(meth)) continue;
            String name = meth.getName();
            Class[] params = meth.getParameterTypes();
            int plength = params.length;
            acc = (Accessor)this._directAccessors.get(name);
            if (acc != null) {
                ((DirectAccessor)acc).addMethod(meth, params);
            } else {
                acc = new DirectAccessor(name, meth, params);
                this._directAccessors.put(name, acc);
            }
            if (name.startsWith("get") || name.startsWith("set") || name.equals("put")) {
                propName = name.substring(3);
                if (plength == 0 && name.startsWith("get") || plength == 1 && name.startsWith("set")) {
                    acc = (Accessor)this._unaryAccessors.get(propName);
                    if (acc != null) {
                        if (!(acc instanceof MethodAccessor)) continue;
                        ((MethodAccessor)acc).addMethod(meth, params);
                        continue;
                    }
                    acc = new UnaryMethodAccessor(propName, meth, params);
                    this._unaryAccessors.put(propName, acc);
                    continue;
                }
                if (plength > 0 && params[0].isInstance("string") && (plength == 2 && name.equals("put") || plength == 1 && name.equals("get"))) {
                    if (this._hashAccessor != null) {
                        this._hashAccessor.addMethod(meth, params);
                        continue;
                    }
                    this._hashAccessor = new BinaryMethodAccessor(propName, meth, params);
                    continue;
                }
                if (plength <= 0 || !params[0].isInstance("string") || (plength != 1 || !name.startsWith("get")) && (plength != 2 || !name.startsWith("set"))) continue;
                acc = (Accessor)this._binaryAccessors.get(propName);
                if (acc != null) {
                    ((MethodAccessor)acc).addMethod(meth, params);
                    continue;
                }
                acc = new BinaryMethodAccessor(propName, meth, params);
                this._binaryAccessors.put(propName, acc);
                continue;
            }
            if (name.startsWith("is") && meth.getReturnType() == Boolean.TYPE) {
                if (plength != 0) continue;
                propName = name.substring(2);
                acc = (Accessor)this._unaryAccessors.get(propName);
                if (acc != null) {
                    if (!(acc instanceof MethodAccessor)) continue;
                    ((MethodAccessor)acc).addMethod(meth, params);
                    continue;
                }
                acc = new UnaryMethodAccessor(propName, meth, params);
                this._unaryAccessors.put(propName, acc);
                continue;
            }
            if (!name.equals("elements") && !name.equals("enumeration") && !name.equals("iterator") && !name.equals("toArray") || params.length != 0 || !(iterA = (iterClass = class$java$util$Iterator == null ? PropertyOperator.class$("java.util.Iterator") : class$java$util$Iterator).isAssignableFrom(returnType = meth.getReturnType())) && (this.iteratorMethod != null && !this.iteratorMethod.getName().equals("toArray") || !(array$Ljava$lang$Object == null ? PropertyOperator.class$("[Ljava.lang.Object;") : array$Ljava$lang$Object).isAssignableFrom(returnType)) && !(class$java$util$Enumeration == null ? PropertyOperator.class$("java.util.Enumeration") : class$java$util$Enumeration).isAssignableFrom(returnType)) continue;
            this.iteratorMethod = meth;
        }
    }

    public Object getProperty(Context context, Object instance, Object[] names, int start, int end) throws PropertyException {
        String propName;
        Object nextPropValue = null;
        Accessor acc = null;
        if (names[start] instanceof String) {
            propName = (String)names[start];
        } else if (names[start] instanceof PropertyMethod) {
            PropertyMethod pm = (PropertyMethod)names[start];
            propName = pm.getName();
            acc = (Accessor)this._directAccessors.get(propName);
            Object[] args = pm.getArguments(context);
            if (acc == null) {
                if (this.isMethodRestricted(instance.getClass(), propName)) {
                    throw new PropertyException.RestrictedMethodException(pm.toString(), PropertyOperator.fillInName(names, start), instance.getClass().getName());
                }
                throw new PropertyException.NoSuchMethodException(pm.toString(), PropertyOperator.fillInName(names, start), instance.getClass().getName());
            }
            try {
                nextPropValue = acc.get(instance, args);
                ++start;
            }
            catch (NoSuchMethodException e) {
                throw new PropertyException.NoSuchMethodException(pm.toString(), PropertyOperator.fillInName(names, start), instance.getClass().getName());
            }
        } else {
            propName = names[start].toString();
        }
        if (acc == null && (acc = (Accessor)this._unaryAccessors.get(propName)) != null) {
            try {
                nextPropValue = acc.get(instance);
                ++start;
            }
            catch (NoSuchMethodException e) {
                acc = null;
            }
        }
        if (acc == null) {
            acc = (Accessor)this._binaryAccessors.get(propName);
            if (acc != null && start + 1 <= names.length) {
                try {
                    nextPropValue = acc.get(instance, (String)names[start + 1]);
                    start += 2;
                }
                catch (NoSuchMethodException e) {
                    acc = null;
                }
                catch (ClassCastException e) {
                    acc = null;
                }
            } else {
                acc = null;
            }
        }
        if (acc == null) {
            acc = this._hashAccessor;
            try {
                if (acc != null) {
                    nextPropValue = acc.get(instance, propName);
                    ++start;
                }
            }
            catch (NoSuchMethodException e) {
                acc = null;
            }
        }
        if (acc == null) {
            if (this.isMethodRestricted(instance.getClass(), "get" + propName) || this.isMethodRestricted(instance.getClass(), "set" + propName)) {
                throw new PropertyException.RestrictedPropertyException(propName, PropertyOperator.fillInName(names, start), instance.getClass().getName());
            }
            throw new PropertyException.NoSuchPropertyException(propName, PropertyOperator.fillInName(names, start), instance.getClass().getName());
        }
        if (start <= end) {
            try {
                return this._cache.getOperator(nextPropValue).getProperty(context, nextPropValue, names, start, end);
            }
            catch (NullPointerException e) {
                throw new PropertyException("$" + PropertyOperator.fillInName(names, start) + " is null.  Cannot access ." + names[end]);
            }
        }
        return nextPropValue;
    }

    private static final String fillInName(Object[] names, int end) {
        StringBuffer sb = new StringBuffer();
        for (int x = 0; x < end; ++x) {
            if (x > 0) {
                sb.append(".");
            }
            sb.append(names[x]);
        }
        return sb.toString();
    }

    public boolean setProperty(Context context, Object instance, Object[] names, Object value, int pos) throws PropertyException, NoSuchMethodException {
        int binPos = names.length - 2;
        if (pos < binPos) {
            Object grandparent = this.getProperty(context, instance, names, pos, binPos - 1);
            PropertyOperator po = this._cache.getOperator(grandparent);
            return po.setProperty(context, grandparent, names, value, binPos);
        }
        if (pos == binPos) {
            Object parent = null;
            try {
                PropertyOperator po;
                parent = this.getProperty(context, instance, names, pos, pos);
                if (parent != null && (po = this._cache.getOperator(parent)).setProperty(context, parent, names, value, pos + 1)) {
                    return true;
                }
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
            Accessor binOp = (Accessor)this._binaryAccessors.get(names[pos]);
            if (binOp != null) {
                try {
                    return binOp.set(instance, (String)names[pos + 1], value);
                }
                catch (ClassCastException e) {
                    return false;
                }
                catch (NoSuchMethodException e) {
                    return false;
                }
            }
            return false;
        }
        Accessor unaryOp = (Accessor)this._unaryAccessors.get(names[pos]);
        try {
            if (unaryOp != null && unaryOp.set(instance, value)) {
                return true;
            }
            if (this._hashAccessor != null) {
                return this._hashAccessor.set(instance, (String)names[pos], value);
            }
        }
        catch (NoSuchMethodException e) {
        }
        catch (ClassCastException e) {
            // empty catch block
        }
        return false;
    }

    public Iterator findIterator(Object instance) throws PropertyException {
        if (this.iteratorMethod != null) {
            Object ret = PropertyOperator.invoke(this.iteratorMethod, instance, null);
            if (ret instanceof Iterator) {
                return (Iterator)ret;
            }
            if (ret instanceof Enumeration) {
                return new EnumIterator((Enumeration)ret);
            }
            if (ret instanceof Object[]) {
                return new ArrayIterator((Object[])ret);
            }
        }
        throw new PropertyException((instance == null ? "null" : instance.getClass().getName()) + " is not a list");
    }

    static Object invoke(Method meth, Object instance, Object[] args) throws PropertyException {
        try {
            Object obj = meth.invoke(instance, args);
            if (obj == null && meth.getReturnType() == Void.TYPE) {
                return VoidMacro.instance;
            }
            return obj;
        }
        catch (IllegalAccessException e) {
            throw new PropertyException("You don't have permission to access the requested method (" + meth + " in class " + instance.getClass() + " on object " + instance + "). Private/protected/package access " + " values cannot be accessed via property introspection.", e);
        }
        catch (IllegalArgumentException e) {
            throw new PropertyException("Some kind of error occurred processing your request: this indicates a failure in PropertyOperator.java that should be reported: attempt to access method " + meth + " on object " + instance + " with " + args.length + " parameters " + " threw an exception: " + e, e);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof PropertyException.UndefinedVariableException) {
                throw (PropertyException)e.getTargetException();
            }
            throw new PropertyException("Attempt to invoke method " + meth + " on object " + instance.getClass().getName() + " raised an exception: " + e.getTargetException().getClass().getName(), e.getTargetException());
        }
        catch (NullPointerException e) {
            throw new PropertyException("NullPointerException thrown from method " + meth + " on object " + instance + " -- most likely you have attempted " + "to use an undefined value, or a failure in that method.", e);
        }
    }
}

