/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.engine;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.webmacro.Broker;
import org.webmacro.Context;
import org.webmacro.InitException;
import org.webmacro.Log;
import org.webmacro.PropertyException;
import org.webmacro.engine.PropertyOperator;
import org.webmacro.engine.StaticClassWrapper;
import org.webmacro.resource.CacheManager;
import org.webmacro.resource.SimpleCacheManager;
import org.webmacro.util.ArrayIterator;
import org.webmacro.util.EnumIterator;
import org.webmacro.util.PrimitiveArrayIterator;
import org.webmacro.util.Settings;

public final class PropertyOperatorCache {
    private CacheManager _cache;
    private Log _log;
    private HashMap _restrictedClasses;

    public final void init(Broker b, Settings config) throws InitException {
        this._log = b.getLog("resource", "Object loading and caching");
        String cacheManager = b.getSetting("PropertyOperator.CacheManager");
        if (cacheManager == null || cacheManager.equals("")) {
            this._log.info("CachingProvider: No cache manager specified for PropertyOperator, using SimpleCacheManager");
            this._cache = new SimpleCacheManager();
        } else {
            try {
                this._cache = (CacheManager)b.classForName(cacheManager).newInstance();
            }
            catch (Exception e) {
                this._log.warning("Unable to load cache manager " + cacheManager + " for PropertyOperator, using SimpleCacheManager.  Reason:\n" + e);
                this._cache = new SimpleCacheManager();
            }
        }
        this._cache.init(b, config, "PropertyOperator");
        this._restrictedClasses = new HashMap(11);
        String restrictList = b.getSetting("RestrictedClasses");
        if (restrictList != null) {
            StringTokenizer stok = new StringTokenizer(restrictList, ",");
            while (stok.hasMoreTokens()) {
                String className = stok.nextToken();
                try {
                    Class<?> c = Class.forName(className);
                    String okMethList = b.getSetting("RestrictedClasses.AllowedMethods." + className);
                    ArrayList<String> okMeths = null;
                    if (okMethList != null) {
                        okMeths = new ArrayList<String>(20);
                        StringTokenizer stok2 = new StringTokenizer(okMethList, ",");
                        while (stok2.hasMoreTokens()) {
                            okMeths.add(stok2.nextToken());
                        }
                    }
                    this._restrictedClasses.put(c, okMeths);
                }
                catch (Exception e) {
                    this._log.error("Configuration error: restricted class " + className + " cannot be loaded", e);
                }
            }
        }
    }

    Map getRestrictedClassMap() {
        return this._restrictedClasses;
    }

    public final PropertyOperator getOperator(Class type) throws PropertyException {
        Object o = this._cache.get(type);
        if (o == null) {
            PropertyOperator po = new PropertyOperator(type, this);
            this._cache.put(type, po);
            return po;
        }
        return (PropertyOperator)o;
    }

    public final PropertyOperator getOperator(Object obj) throws PropertyException {
        Class type = obj.getClass();
        if (type == StaticClassWrapper.class) {
            type = ((StaticClassWrapper)obj).get();
        }
        return this.getOperator(type);
    }

    public final Object getProperty(Context context, Object instance, Object[] names, int start) throws PropertyException {
        if (instance == null) {
            return null;
        }
        return this.getOperator(instance).getProperty(context, instance, names, start, names.length - 1);
    }

    public final Object getProperty(Context context, Object instance, Object[] names) throws PropertyException {
        return this.getProperty(context, instance, names, 0);
    }

    public final boolean setProperty(Context context, Object instance, Object[] names, int start, Object value) throws PropertyException {
        try {
            if (instance == null) {
                return false;
            }
            return this.getOperator(instance).setProperty(context, instance, names, value, start);
        }
        catch (PropertyException e) {
            throw e;
        }
        catch (NoSuchMethodException e) {
            throw new PropertyException("No method to access property: " + e, e);
        }
    }

    public final boolean setProperty(Context context, Object instance, Object[] names, Object value) throws PropertyException {
        return this.setProperty(context, instance, names, 0, value);
    }

    public final Iterator getIterator(Object instance) throws PropertyException {
        if (instance instanceof Object[]) {
            return new ArrayIterator((Object[])instance);
        }
        if (instance.getClass().isArray()) {
            return new PrimitiveArrayIterator(instance);
        }
        if (instance instanceof Iterator) {
            return (Iterator)instance;
        }
        if (instance instanceof Enumeration) {
            return new EnumIterator((Enumeration)instance);
        }
        return this.getOperator(instance).findIterator(instance);
    }
}

