/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.parser;

import org.webmacro.engine.BlockBuilder;

public class ParserBlockBuilder
extends BlockBuilder {
    private int literalMark = 0;

    public ParserBlockBuilder() {
    }

    public ParserBlockBuilder(String name) {
        super(name);
    }

    public final void markLiteral() {
        this.literalMark = this.size();
    }

    private static final boolean isSpaceChar(char c) {
        return c == ' ' || c == '\t';
    }

    private static final int eatWs(String s, int pos) {
        while (pos >= 0 && ParserBlockBuilder.isSpaceChar(s.charAt(pos))) {
            --pos;
        }
        return pos;
    }

    private static final int eatOneWs(String s, int pos) {
        if (pos >= 0 && ParserBlockBuilder.isSpaceChar(s.charAt(pos))) {
            --pos;
        }
        return pos;
    }

    private static final int eatNl(String s, int pos) {
        if (pos >= 0) {
            if (s.charAt(pos) == '\r') {
                --pos;
            } else if (s.charAt(pos) == '\n' && --pos >= 0 && s.charAt(pos) == '\r') {
                --pos;
            }
        }
        return pos;
    }

    public final void eatTrailingWs() {
        int i = this.size() - 1;
        if (i < 0 || i + 1 == this.literalMark) {
            return;
        }
        Object o = this.elementAt(i);
        if (!(o instanceof String)) {
            return;
        }
        String s = (String)o;
        int j = ParserBlockBuilder.eatWs(s, s.length() - 1);
        if (j < 0) {
            this.remove(i);
        } else if (j < s.length() - 1) {
            this.setElementAt(s.substring(0, j + 1), i);
        }
        this.markLiteral();
    }

    public final void eatTrailingWsNl() {
        int i = this.size() - 1;
        if (i < 0 || i + 1 == this.literalMark) {
            return;
        }
        Object o = this.elementAt(i);
        if (!(o instanceof String)) {
            return;
        }
        String s = (String)o;
        int j = ParserBlockBuilder.eatWs(s, s.length() - 1);
        if ((j = ParserBlockBuilder.eatNl(s, j)) < 0) {
            this.remove(i);
        } else if (j < s.length() - 1) {
            this.setElementAt(s.substring(0, j + 1), i);
        }
        this.markLiteral();
    }

    public final void eatTrailingWsNlWs() {
        int i = this.size() - 1;
        if (i < 0 || i + 1 == this.literalMark) {
            return;
        }
        Object o = this.elementAt(i);
        if (!(o instanceof String)) {
            return;
        }
        String s = (String)o;
        int j = ParserBlockBuilder.eatWs(s, s.length() - 1);
        j = ParserBlockBuilder.eatNl(s, j);
        if ((j = ParserBlockBuilder.eatWs(s, j)) < 0) {
            this.remove(i);
        } else if (j < s.length() - 1) {
            this.setElementAt(s.substring(0, j + 1), i);
        }
        this.markLiteral();
    }

    public final void eatOneWs() {
        int i = this.size() - 1;
        if (i < 0 || i + 1 == this.literalMark) {
            return;
        }
        Object o = this.elementAt(i);
        if (!(o instanceof String)) {
            return;
        }
        String s = (String)o;
        int j = ParserBlockBuilder.eatOneWs(s, s.length() - 1);
        if (j < 0) {
            this.remove(i);
        } else if (j < s.length() - 1) {
            this.setElementAt(s.substring(0, j + 1), i);
        }
        this.markLiteral();
    }

    public final void eatLeadingWsNl() {
        int j;
        int i = this.size() - 1;
        if (i < 0 || i + 1 == this.literalMark) {
            return;
        }
        Object o = this.elementAt(i);
        if (!(o instanceof String)) {
            return;
        }
        String s = (String)o;
        int l = s.length();
        for (j = 0; j < l && ParserBlockBuilder.isSpaceChar(s.charAt(j)); ++j) {
        }
        if (j < l) {
            if (s.charAt(j) == '\r') {
                ++j;
            } else if (s.charAt(j) == '\n' && ++j < l && s.charAt(j) == '\r') {
                ++j;
            }
        }
        if (j >= l) {
            this.remove(i);
        } else if (j > 0) {
            this.setElementAt(s.substring(j), i);
        }
        this.markLiteral();
    }

    public final boolean directiveOk() {
        if (this.size() == 0 || this.size() == this.literalMark) {
            return true;
        }
        Object o = this.elementAt(this.size() - 1);
        if (!(o instanceof String) || ((String)o).length() == 0) {
            return true;
        }
        String s = (String)o;
        char ch = s.charAt(s.length() - 1);
        return ch != '=' && ch != '\'' && ch != '\"' && ch != ':' && !Character.isLetterOrDigit(ch);
    }
}

