/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.parser;

import java.io.FileReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.webmacro.Broker;
import org.webmacro.Context;
import org.webmacro.WM;
import org.webmacro.directive.Directive;
import org.webmacro.directive.DirectiveArgs;
import org.webmacro.directive.DirectiveBuilder;
import org.webmacro.directive.DirectiveDescriptor;
import org.webmacro.engine.Block;
import org.webmacro.engine.BlockBuilder;
import org.webmacro.engine.BuildContext;
import org.webmacro.engine.BuildException;
import org.webmacro.engine.Builder;
import org.webmacro.engine.Expression;
import org.webmacro.engine.FunctionCallBuilder;
import org.webmacro.engine.ListBuilder;
import org.webmacro.engine.MacroBuilder;
import org.webmacro.engine.MapBuilder;
import org.webmacro.engine.PropertyMethodBuilder;
import org.webmacro.engine.QuotedStringBuilder;
import org.webmacro.engine.UndefinedMacro;
import org.webmacro.engine.VariableBuilder;
import org.webmacro.parser.BackupCharStream;
import org.webmacro.parser.CharStream;
import org.webmacro.parser.ParseException;
import org.webmacro.parser.ParserBlockBuilder;
import org.webmacro.parser.Token;
import org.webmacro.parser.WMParser_implConstants;
import org.webmacro.parser.WMParser_implTokenManager;

public class WMParser_impl
implements WMParser_implConstants {
    private Broker broker;
    private BackupCharStream stream;
    private Stack blockStack = new Stack();
    private String templateName;
    private static String SEMI_FEATURE = "Use of semicolon to delimit property reference -- use $( ) instead";
    private static String DDOLLAR_FEATURE = "Use of $$ to reference template property -- use single $ instead";
    public WMParser_implTokenManager token_source;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    private boolean jj_lookingAhead = false;
    private boolean jj_semLA;
    private int jj_gen;
    private final int[] jj_la1 = new int[120];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private final JJCalls[] jj_2_rtns = new JJCalls[23];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private List jj_expentries = new ArrayList();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    public WMParser_impl(Broker broker, String templateName, BackupCharStream stream) {
        this(stream);
        this.stream = stream;
        this.broker = broker;
        this.templateName = templateName;
    }

    public WMParser_impl(Broker broker, String templateName, Reader reader) {
        this(broker, templateName, new BackupCharStream(reader));
    }

    public void ReInit(String templateName, Reader reader) {
        this.templateName = templateName;
        this.stream.ReInit(reader);
        this.ReInit(this.stream);
    }

    public static void main(String[] args) throws Exception {
        WM wm = new WM();
        Broker broker = wm.getBroker();
        WMParser_impl parser = args.length >= 1 ? new WMParser_impl(broker, args[0], new FileReader(args[0])) : new WMParser_impl(broker, "stdin", new InputStreamReader(System.in));
        BlockBuilder bb = parser.WMDocument();
        Context context = null;
        try {
            context = wm.getContext();
            Object[] names = new Object[]{"prop"};
            context.setProperty(names, (Object)"Example property");
            Block b = (Block)bb.build(new BuildContext(broker));
            System.out.println((String)b.evaluate(context));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void SetState(int state) {
        if (state != this.token_source.curLexState) {
            Token root;
            Token last = root = new Token();
            root.next = null;
            while (this.token.next != null) {
                Token t = this.token;
                while (t.next != null && t.next.next != null) {
                    t = t.next;
                }
                last.next = t.next;
                last = t.next;
                if (t.next.specialToken != null) {
                    Token tt = t.next.specialToken;
                    while (tt != null) {
                        last.next = tt;
                        last = tt;
                        tt.next = null;
                        tt = tt.specialToken;
                    }
                }
                t.next = null;
            }
            while (root.next != null) {
                this.token_source.backup(root.next.image.length());
                root.next = root.next.next;
            }
            this.jj_ntk = -1;
            this.token_source.SwitchTo(state);
        }
    }

    private boolean lookahead_not_breaking_subd() {
        boolean retVal = true;
        Object o = this.blockStack.peek();
        if (o == null) {
            return true;
        }
        Directive.Subdirective[] subdirectives = (Directive.Subdirective[])o;
        if (this.getToken((int)1).kind == 23 && this.getToken((int)2).kind == 11) {
            String word = this.getToken((int)2).image;
            for (int i = 0; i < subdirectives.length; ++i) {
                if (!subdirectives[i].isBreaking || !word.startsWith(subdirectives[i].name) || word.length() != subdirectives[i].name.length() && Character.isJavaIdentifierPart(word.charAt(subdirectives[i].name.length()))) continue;
                retVal = false;
                break;
            }
        }
        return retVal;
    }

    private void warnDeprecated(String feature, int line, int col) {
        this.broker.getLog("parser").warning("Deprecated feature: " + feature + " at " + this.templateName + ":" + line + "." + col);
    }

    Directive.Subdirective lookahead_subdirective(Directive.Subdirective[] subdirectives) throws ParseException {
        int n = 1;
        Token t = this.getToken(n);
        while (t.kind == 30 || t.kind == 31) {
            t = this.getToken(++n);
        }
        if (this.getToken((int)n).kind == 23 && this.getToken((int)(n + 1)).kind == 54) {
            String word = this.getToken((int)(n + 1)).image;
            for (int i = 0; i < subdirectives.length; ++i) {
                if (!word.equals(subdirectives[i].name)) continue;
                return subdirectives[i];
            }
        }
        return null;
    }

    boolean lookahead_keyword(String keyword) throws ParseException {
        int n = 1;
        if (this.getToken((int)n).kind == 30) {
            ++n;
        }
        return this.getToken((int)n).kind == 54 && this.getToken((int)n).image.equals(keyword);
    }

    boolean lookahead_arg(Directive.ArgDescriptor arg) throws ParseException {
        if (arg.type == 4) {
            return this.lookahead_keyword(arg.keyword);
        }
        if (arg.type == 5) {
            int n = 1;
            if (this.getToken((int)n).kind == 30) {
                ++n;
            }
            return this.getToken((int)n).kind == 43;
        }
        return false;
    }

    Object parse_arg(DirectiveDescriptor descriptor, Directive.ArgDescriptor arg) throws ParseException {
        switch (arg.type) {
            case 1: {
                return this.Conditional();
            }
            case 6: {
                this.BeforeBlock();
                this.SetState(4);
                BlockBuilder b = this.Block(descriptor.hasBreakingSubdirectives ? descriptor.subdirectives : null);
                this.SetState(3);
                this.OptionalWs();
                return b;
            }
            case 7: {
                this.BeforeBlock();
                this.SetState(4);
                BlockBuilder b = this.LiteralBlock();
                this.SetState(3);
                this.OptionalWs();
                return b;
            }
            case 2: {
                return this.LValue();
            }
            case 3: {
                return this.RValue();
            }
            case 9: {
                return this.QuotedString();
            }
            case 11: {
                return this.Word();
            }
            case 10: {
                return this.StringArg();
            }
            case 5: {
                this.Punct_EQ();
                return "=";
            }
            case 12: {
                return this.FormalArgList();
            }
            case 4: {
                if (arg.optional && !this.lookahead_keyword(arg.keyword)) {
                    return null;
                }
                this.Keyword(arg.keyword);
                return arg.keyword;
            }
        }
        throw new ParseException("ParseDirectiveArg: Unknown argument type " + arg.type);
    }

    boolean parse_arg_group(DirectiveDescriptor descriptor, Directive.ArgDescriptor[] args, int i, DirectiveArgs da) throws ParseException, BuildException {
        if (args[i].optional && !this.lookahead_arg(args[args[i].children[0]])) {
            return false;
        }
        for (int j = 0; j < args[i].subordinateArgs; ++j) {
            Directive.ArgDescriptor child = args[args[i].children[j]];
            if (child.type == 50) {
                this.parse_arg_group(descriptor, args, args[i].children[j], da);
                continue;
            }
            if (child.type == 51) {
                this.parse_arg_choice(descriptor, args, args[i].children[j], da);
                continue;
            }
            Object o = this.parse_arg(descriptor, child);
            da.setArg(child.id, o);
        }
        return true;
    }

    void parse_arg_choice(DirectiveDescriptor descriptor, Directive.ArgDescriptor[] args, int i, DirectiveArgs da) throws ParseException, BuildException {
        Directive.ArgDescriptor child;
        int j;
        boolean foundOne = false;
        Directive.OptionChoice oc = (Directive.OptionChoice)args[i];
        boolean more = true;
        block0: while (more) {
            for (j = 0; j < args[i].subordinateArgs; ++j) {
                more = false;
                child = args[args[i].children[j]];
                if (!this.lookahead_keyword(args[child.children[0]].keyword)) continue;
                foundOne = true;
                this.parse_arg_group(descriptor, args, args[i].children[j], da);
                if (!oc.repeating) continue block0;
                more = true;
                continue block0;
            }
        }
        if (!args[i].optional && !foundOne) {
            StringBuffer sb = new StringBuffer();
            for (j = 0; j < args[i].subordinateArgs; ++j) {
                if (j > 0) {
                    sb.append(", ");
                }
                child = args[args[i].children[j]];
                sb.append(args[child.children[0]].keyword);
            }
            throw new ParseException("Expecting one of " + sb.toString());
        }
    }

    void parse_args(DirectiveDescriptor descriptor, Directive.ArgDescriptor[] args, DirectiveArgs da) throws ParseException {
        try {
            int i = 0;
            while (i < args.length) {
                Directive.ArgDescriptor arg = args[i];
                if (arg.type == 50) {
                    this.parse_arg_group(descriptor, args, i, da);
                } else if (arg.type == 51) {
                    this.parse_arg_choice(descriptor, args, i, da);
                } else {
                    Object o = this.parse_arg(descriptor, arg);
                    da.setArg(arg.id, o);
                }
                i = arg.nextArg;
            }
        }
        catch (BuildException e) {
            throw new ParseException("BuildException", e);
        }
    }

    Builder parse_directive(String directive) throws ParseException, ParseException {
        DirectiveBuilder db = null;
        DirectiveDescriptor descriptor = null;
        try {
            descriptor = (DirectiveDescriptor)this.broker.get("directive", directive);
            if (descriptor == null) {
                return this.parse_macro(directive);
            }
            if (!descriptor.valid) {
                throw new ParseException("Descriptor for directive " + directive + " is not valid");
            }
        }
        catch (Exception e) {
            throw new ParseException("No such directive #" + directive);
        }
        db = new DirectiveBuilder(descriptor);
        this.parse_args(descriptor, descriptor.args, db);
        if (descriptor.subdirectives != null && descriptor.subdirectives.length > 0) {
            Directive.Subdirective subd;
            while ((subd = this.lookahead_subdirective(descriptor.subdirectives)) != null) {
                DirectiveArgs da;
                try {
                    if (!db.subdirectiveOk(subd.id)) break;
                    this.SubdirectiveStart();
                    da = db.newSubdirective(subd.id);
                }
                catch (BuildException e) {
                    throw new ParseException("BuildException", e);
                }
                this.parse_args(descriptor, subd.args, da);
            }
        }
        this.OptionalWsNl();
        return db;
    }

    Builder parse_macro(String name) throws ParseException, ParseException {
        Token token = this.getToken(1);
        ListBuilder lb = this.MacroArgList();
        return new MacroBuilder(name, lb, token.beginLine, token.beginColumn);
    }

    public final void EatWsNlIfNl(BlockBuilder b) throws ParseException {
        int entryState = this.token_source.curLexState;
        this.SetState(3);
        if (this.jj_2_1(Integer.MAX_VALUE)) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 30: {
                    this.jj_consume_token(30);
                    break;
                }
                default: {
                    this.jj_la1[0] = this.jj_gen;
                }
            }
            this.jj_consume_token(31);
        }
        this.SetState(entryState);
    }

    public final void EatWsNlOrSpace(BlockBuilder b) throws ParseException {
        int entryState = this.token_source.curLexState;
        Token n = null;
        this.SetState(3);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 30: 
            case 31: {
                if (this.jj_2_3(Integer.MAX_VALUE)) {
                    this.jj_consume_token(31);
                    break;
                }
                if (this.jj_2_4(Integer.MAX_VALUE)) {
                    Token w = this.jj_consume_token(30);
                    if (this.jj_2_2(Integer.MAX_VALUE)) {
                        n = this.jj_consume_token(31);
                    }
                    if (n != null) break;
                    b.addElement(w.image.substring(1));
                    break;
                }
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[1] = this.jj_gen;
            }
        }
        this.SetState(entryState);
    }

    public final void BeforeBlock() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 30: {
                this.jj_consume_token(30);
                break;
            }
            default: {
                this.jj_la1[2] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 31: {
                this.jj_consume_token(31);
                if (!this.jj_2_5(Integer.MAX_VALUE)) break;
                this.jj_consume_token(30);
                break;
            }
            default: {
                this.jj_la1[3] = this.jj_gen;
            }
        }
    }

    public final void OptionalWsNl() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 30: {
                this.jj_consume_token(30);
                break;
            }
            default: {
                this.jj_la1[4] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 31: {
                this.jj_consume_token(31);
                break;
            }
            default: {
                this.jj_la1[5] = this.jj_gen;
            }
        }
    }

    public final void OptionalWs() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 30: {
                this.jj_consume_token(30);
                break;
            }
            default: {
                this.jj_la1[6] = this.jj_gen;
            }
        }
    }

    public final void SubdirectiveStart() throws ParseException {
        block11: {
            block10: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 30: 
                    case 31: {
                        break;
                    }
                    default: {
                        this.jj_la1[7] = this.jj_gen;
                        break block11;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 30: {
                        this.jj_consume_token(30);
                        continue block10;
                    }
                    case 31: {
                        this.jj_consume_token(31);
                        continue block10;
                    }
                }
                break;
            }
            this.jj_la1[8] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        this.jj_consume_token(23);
        this.jj_consume_token(54);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 30: {
                this.jj_consume_token(30);
                break;
            }
            default: {
                this.jj_la1[9] = this.jj_gen;
            }
        }
    }

    public final Builder LValue() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 30: {
                this.jj_consume_token(30);
                break;
            }
            default: {
                this.jj_la1[10] = this.jj_gen;
            }
        }
        Builder lv = this.VariableReference();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 30: {
                this.jj_consume_token(30);
                break;
            }
            default: {
                this.jj_la1[11] = this.jj_gen;
            }
        }
        return lv;
    }

    public final Object RValue() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 30: {
                this.jj_consume_token(30);
                break;
            }
            default: {
                this.jj_la1[12] = this.jj_gen;
            }
        }
        Object rv = this.Expression();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 30: {
                this.jj_consume_token(30);
                break;
            }
            default: {
                this.jj_la1[13] = this.jj_gen;
            }
        }
        return rv;
    }

    public final void Punct_EQ() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 30: {
                this.jj_consume_token(30);
                break;
            }
            default: {
                this.jj_la1[14] = this.jj_gen;
            }
        }
        this.jj_consume_token(43);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 30: {
                this.jj_consume_token(30);
                break;
            }
            default: {
                this.jj_la1[15] = this.jj_gen;
            }
        }
    }

    public final void Punct_COMMA() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 30: {
                this.jj_consume_token(30);
                break;
            }
            default: {
                this.jj_la1[16] = this.jj_gen;
            }
        }
        this.jj_consume_token(52);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 30: {
                this.jj_consume_token(30);
                break;
            }
            default: {
                this.jj_la1[17] = this.jj_gen;
            }
        }
    }

    public final void Punct_LPAREN() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 30: {
                this.jj_consume_token(30);
                break;
            }
            default: {
                this.jj_la1[18] = this.jj_gen;
            }
        }
        this.jj_consume_token(32);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 30: {
                this.jj_consume_token(30);
                break;
            }
            default: {
                this.jj_la1[19] = this.jj_gen;
            }
        }
    }

    public final void Punct_RPAREN() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 30: {
                this.jj_consume_token(30);
                break;
            }
            default: {
                this.jj_la1[20] = this.jj_gen;
            }
        }
        this.jj_consume_token(33);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 30: {
                this.jj_consume_token(30);
                break;
            }
            default: {
                this.jj_la1[21] = this.jj_gen;
            }
        }
    }

    public final void Keyword(String s) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 30: {
                this.jj_consume_token(30);
                break;
            }
            default: {
                this.jj_la1[22] = this.jj_gen;
            }
        }
        Token t = this.jj_consume_token(54);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 30: {
                this.jj_consume_token(30);
                break;
            }
            default: {
                this.jj_la1[23] = this.jj_gen;
            }
        }
        if (!s.equals(t.image)) {
            throw new ParseException("Encountered " + t.image + " at line " + t.beginLine + "; expecting " + s);
        }
    }

    public final String Word() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 30: {
                this.jj_consume_token(30);
                break;
            }
            default: {
                this.jj_la1[24] = this.jj_gen;
            }
        }
        Token t = this.jj_consume_token(54);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 30: {
                this.jj_consume_token(30);
                break;
            }
            default: {
                this.jj_la1[25] = this.jj_gen;
            }
        }
        return t.image;
    }

    public final Object Conditional() throws ParseException {
        this.jj_consume_token(32);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 30: {
                this.jj_consume_token(30);
                break;
            }
            default: {
                this.jj_la1[26] = this.jj_gen;
            }
        }
        Object e = this.Expression();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 30: {
                this.jj_consume_token(30);
                break;
            }
            default: {
                this.jj_la1[27] = this.jj_gen;
            }
        }
        this.jj_consume_token(33);
        return e;
    }

    public final Object ObjectRoot() throws ParseException {
        Object element;
        if (this.jj_2_6(Integer.MAX_VALUE)) {
            Token t = this.jj_consume_token(54);
            this.jj_consume_token(32);
            ListBuilder argList = this.ArgList();
            this.jj_consume_token(33);
            element = new FunctionCallBuilder(t.image, argList);
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 54: {
                    Token t = this.jj_consume_token(54);
                    element = t.image;
                    break;
                }
                default: {
                    this.jj_la1[28] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        return element;
    }

    public final void VariableReferenceGuts(ArrayList v) throws ParseException {
        Object element = this.ObjectRoot();
        v.add(element);
        while (this.jj_2_7(Integer.MAX_VALUE)) {
            this.jj_consume_token(37);
            Token t = this.jj_consume_token(54);
            element = t.image;
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 32: {
                    this.jj_consume_token(32);
                    ListBuilder argList = this.ArgList();
                    this.jj_consume_token(33);
                    element = new PropertyMethodBuilder((String)element, argList);
                    break;
                }
                default: {
                    this.jj_la1[29] = this.jj_gen;
                }
            }
            v.add(element);
        }
    }

    public final Builder VariableReference() throws ParseException {
        Token t;
        ArrayList<String> v = new ArrayList<String>();
        this.jj_consume_token(20);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 20: {
                t = this.jj_consume_token(20);
                this.warnDeprecated(DDOLLAR_FEATURE, t.beginLine, t.beginColumn);
                break;
            }
            default: {
                this.jj_la1[30] = this.jj_gen;
            }
        }
        if (this.jj_2_8(2)) {
            t = this.jj_consume_token(54);
            this.jj_consume_token(53);
            v.add(t.image);
            this.warnDeprecated(SEMI_FEATURE, t.beginLine, t.beginColumn);
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 54: {
                    this.VariableReferenceGuts(v);
                    break;
                }
                case 32: {
                    this.jj_consume_token(32);
                    this.VariableReferenceGuts(v);
                    this.jj_consume_token(33);
                    break;
                }
                default: {
                    this.jj_la1[31] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        Object[] names = v.toArray();
        return new VariableBuilder(names);
    }

    /*
     * Enabled aggressive block sorting
     */
    public final Builder QuotedString() throws ParseException {
        int entryState = this.token_source.curLexState;
        QuotedStringBuilder qs = new QuotedStringBuilder();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 24: {
                this.jj_consume_token(24);
                this.SetState(1);
                block20: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 20: 
                        case 21: 
                        case 22: 
                        case 57: {
                            break;
                        }
                        default: {
                            this.jj_la1[32] = this.jj_gen;
                            break block20;
                        }
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 57: {
                            Token t = this.jj_consume_token(57);
                            qs.addElement(t.image);
                            continue block20;
                        }
                        case 21: {
                            Token t = this.jj_consume_token(21);
                            qs.addElement(t.image.substring(1));
                            continue block20;
                        }
                        case 22: {
                            Token t = this.jj_consume_token(22);
                            qs.addElement(t.image);
                            continue block20;
                        }
                    }
                    this.jj_la1[33] = this.jj_gen;
                    if (!this.jj_2_9(Integer.MAX_VALUE)) {
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                    Object dr = this.DollarReference();
                    qs.addElement(dr);
                }
                this.jj_consume_token(24);
                break;
            }
            case 25: {
                this.jj_consume_token(25);
                this.SetState(0);
                block21: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 20: 
                        case 21: 
                        case 22: 
                        case 58: {
                            break;
                        }
                        default: {
                            this.jj_la1[34] = this.jj_gen;
                            break block21;
                        }
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 58: {
                            Token t = this.jj_consume_token(58);
                            qs.addElement(t.image);
                            continue block21;
                        }
                        case 21: {
                            Token t = this.jj_consume_token(21);
                            qs.addElement(t.image.substring(1));
                            continue block21;
                        }
                        case 22: {
                            Token t = this.jj_consume_token(22);
                            qs.addElement(t.image);
                            continue block21;
                        }
                    }
                    this.jj_la1[35] = this.jj_gen;
                    if (!this.jj_2_10(Integer.MAX_VALUE)) {
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                    Object dr = this.DollarReference();
                    qs.addElement(dr);
                }
                this.jj_consume_token(25);
                break;
            }
            default: {
                this.jj_la1[36] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.SetState(entryState);
        return qs;
    }

    public final Builder StringArg() throws ParseException {
        Builder b;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 24: 
            case 25: {
                b = this.QuotedString();
                break;
            }
            case 20: {
                b = this.VariableReference();
                break;
            }
            default: {
                this.jj_la1[37] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return b;
    }

    public final MapBuilder MapArgList() throws ParseException {
        MapBuilder map = new MapBuilder();
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 15: 
            case 20: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 32: 
            case 34: 
            case 46: 
            case 51: 
            case 55: {
                Object key = this.Expression();
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 30: 
                    case 31: {
                        block76: while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 30: {
                                    this.jj_consume_token(30);
                                    break;
                                }
                                case 31: {
                                    this.jj_consume_token(31);
                                    break;
                                }
                                default: {
                                    this.jj_la1[38] = this.jj_gen;
                                    this.jj_consume_token(-1);
                                    throw new ParseException();
                                }
                            }
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 30: 
                                case 31: {
                                    continue block76;
                                }
                            }
                            break;
                        }
                        this.jj_la1[39] = this.jj_gen;
                        break;
                    }
                    default: {
                        this.jj_la1[40] = this.jj_gen;
                    }
                }
                this.jj_consume_token(36);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 30: 
                    case 31: {
                        block77: while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 30: {
                                    this.jj_consume_token(30);
                                    break;
                                }
                                case 31: {
                                    this.jj_consume_token(31);
                                    break;
                                }
                                default: {
                                    this.jj_la1[41] = this.jj_gen;
                                    this.jj_consume_token(-1);
                                    throw new ParseException();
                                }
                            }
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 30: 
                                case 31: {
                                    continue block77;
                                }
                            }
                            break;
                        }
                        this.jj_la1[42] = this.jj_gen;
                        break;
                    }
                    default: {
                        this.jj_la1[43] = this.jj_gen;
                    }
                }
                Object value = this.Expression();
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 30: 
                    case 31: {
                        block78: while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 30: {
                                    this.jj_consume_token(30);
                                    break;
                                }
                                case 31: {
                                    this.jj_consume_token(31);
                                    break;
                                }
                                default: {
                                    this.jj_la1[44] = this.jj_gen;
                                    this.jj_consume_token(-1);
                                    throw new ParseException();
                                }
                            }
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 30: 
                                case 31: {
                                    continue block78;
                                }
                            }
                            break;
                        }
                        this.jj_la1[45] = this.jj_gen;
                        break;
                    }
                    default: {
                        this.jj_la1[46] = this.jj_gen;
                    }
                }
                map.put(key, value);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 52: {
                            break;
                        }
                        default: {
                            this.jj_la1[47] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(52);
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 30: 
                        case 31: {
                            block80: while (true) {
                                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                    case 30: {
                                        this.jj_consume_token(30);
                                        break;
                                    }
                                    case 31: {
                                        this.jj_consume_token(31);
                                        break;
                                    }
                                    default: {
                                        this.jj_la1[48] = this.jj_gen;
                                        this.jj_consume_token(-1);
                                        throw new ParseException();
                                    }
                                }
                                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                    case 30: 
                                    case 31: {
                                        continue block80;
                                    }
                                }
                                break;
                            }
                            this.jj_la1[49] = this.jj_gen;
                            break;
                        }
                        default: {
                            this.jj_la1[50] = this.jj_gen;
                        }
                    }
                    key = this.Expression();
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 30: 
                        case 31: {
                            block81: while (true) {
                                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                    case 30: {
                                        this.jj_consume_token(30);
                                        break;
                                    }
                                    case 31: {
                                        this.jj_consume_token(31);
                                        break;
                                    }
                                    default: {
                                        this.jj_la1[51] = this.jj_gen;
                                        this.jj_consume_token(-1);
                                        throw new ParseException();
                                    }
                                }
                                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                    case 30: 
                                    case 31: {
                                        continue block81;
                                    }
                                }
                                break;
                            }
                            this.jj_la1[52] = this.jj_gen;
                            break;
                        }
                        default: {
                            this.jj_la1[53] = this.jj_gen;
                        }
                    }
                    this.jj_consume_token(36);
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 30: 
                        case 31: {
                            block82: while (true) {
                                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                    case 30: {
                                        this.jj_consume_token(30);
                                        break;
                                    }
                                    case 31: {
                                        this.jj_consume_token(31);
                                        break;
                                    }
                                    default: {
                                        this.jj_la1[54] = this.jj_gen;
                                        this.jj_consume_token(-1);
                                        throw new ParseException();
                                    }
                                }
                                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                    case 30: 
                                    case 31: {
                                        continue block82;
                                    }
                                }
                                break;
                            }
                            this.jj_la1[55] = this.jj_gen;
                            break;
                        }
                        default: {
                            this.jj_la1[56] = this.jj_gen;
                        }
                    }
                    value = this.Expression();
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 30: 
                        case 31: {
                            block83: while (true) {
                                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                    case 30: {
                                        this.jj_consume_token(30);
                                        break;
                                    }
                                    case 31: {
                                        this.jj_consume_token(31);
                                        break;
                                    }
                                    default: {
                                        this.jj_la1[57] = this.jj_gen;
                                        this.jj_consume_token(-1);
                                        throw new ParseException();
                                    }
                                }
                                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                    case 30: 
                                    case 31: {
                                        continue block83;
                                    }
                                }
                                break;
                            }
                            this.jj_la1[58] = this.jj_gen;
                            break;
                        }
                        default: {
                            this.jj_la1[59] = this.jj_gen;
                        }
                    }
                    map.put(key, value);
                }
            }
            default: {
                this.jj_la1[60] = this.jj_gen;
            }
        }
        return map;
    }

    public final MapBuilder CurlyMap() throws ParseException {
        this.jj_consume_token(15);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 30: 
            case 31: {
                block10: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 30: {
                            this.jj_consume_token(30);
                            break;
                        }
                        case 31: {
                            this.jj_consume_token(31);
                            break;
                        }
                        default: {
                            this.jj_la1[61] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 30: 
                        case 31: {
                            continue block10;
                        }
                    }
                    break;
                }
                this.jj_la1[62] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[63] = this.jj_gen;
            }
        }
        MapBuilder map = this.MapArgList();
        this.SetState(4);
        this.jj_consume_token(12);
        this.SetState(3);
        return map;
    }

    public final ListBuilder ArgList() throws ParseException {
        ListBuilder list = new ListBuilder();
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 15: 
            case 20: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 34: 
            case 46: 
            case 51: 
            case 55: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 30: {
                        this.jj_consume_token(30);
                        break;
                    }
                    default: {
                        this.jj_la1[64] = this.jj_gen;
                    }
                }
                Object e = this.Expression();
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 30: {
                        this.jj_consume_token(30);
                        break;
                    }
                    default: {
                        this.jj_la1[65] = this.jj_gen;
                    }
                }
                list.addElement(e);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 52: {
                            break;
                        }
                        default: {
                            this.jj_la1[66] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(52);
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 30: {
                            this.jj_consume_token(30);
                            break;
                        }
                        default: {
                            this.jj_la1[67] = this.jj_gen;
                        }
                    }
                    e = this.Expression();
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 30: {
                            this.jj_consume_token(30);
                            break;
                        }
                        default: {
                            this.jj_la1[68] = this.jj_gen;
                        }
                    }
                    list.addElement(e);
                }
            }
            default: {
                this.jj_la1[69] = this.jj_gen;
            }
        }
        return list;
    }

    public final ListBuilder BracketList() throws ParseException {
        this.jj_consume_token(34);
        ListBuilder list = this.ArgList();
        this.jj_consume_token(35);
        return list;
    }

    public final Object[] FormalArgList() throws ParseException {
        ArrayList<String> list = new ArrayList<String>();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 32: {
                this.jj_consume_token(32);
                block3 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 20: 
                    case 30: {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 30: {
                                this.jj_consume_token(30);
                                break;
                            }
                            default: {
                                this.jj_la1[70] = this.jj_gen;
                            }
                        }
                        this.jj_consume_token(20);
                        Token name = this.jj_consume_token(54);
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 30: {
                                this.jj_consume_token(30);
                                break;
                            }
                            default: {
                                this.jj_la1[71] = this.jj_gen;
                            }
                        }
                        list.add(name.image);
                        while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 52: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[72] = this.jj_gen;
                                    break block3;
                                }
                            }
                            this.jj_consume_token(52);
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 30: {
                                    this.jj_consume_token(30);
                                    break;
                                }
                                default: {
                                    this.jj_la1[73] = this.jj_gen;
                                }
                            }
                            this.jj_consume_token(20);
                            name = this.jj_consume_token(54);
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 30: {
                                    this.jj_consume_token(30);
                                    break;
                                }
                                default: {
                                    this.jj_la1[74] = this.jj_gen;
                                }
                            }
                            list.add(name.image);
                        }
                    }
                    default: {
                        this.jj_la1[75] = this.jj_gen;
                    }
                }
                this.jj_consume_token(33);
                break;
            }
            default: {
                this.jj_la1[76] = this.jj_gen;
            }
        }
        return list.toArray();
    }

    public final ListBuilder MacroArgList() throws ParseException {
        ListBuilder list = new ListBuilder();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 32: {
                this.jj_consume_token(32);
                list = this.ArgList();
                this.jj_consume_token(33);
                break;
            }
            default: {
                this.jj_la1[77] = this.jj_gen;
            }
        }
        return list;
    }

    public final Object Term() throws ParseException {
        Object e;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 20: {
                e = this.VariableReference();
                break;
            }
            case 32: {
                this.jj_consume_token(32);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 30: {
                        this.jj_consume_token(30);
                        break;
                    }
                    default: {
                        this.jj_la1[78] = this.jj_gen;
                    }
                }
                e = this.Expression();
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 30: {
                        this.jj_consume_token(30);
                        break;
                    }
                    default: {
                        this.jj_la1[79] = this.jj_gen;
                    }
                }
                this.jj_consume_token(33);
                break;
            }
            case 24: 
            case 25: {
                e = this.QuotedString();
                break;
            }
            case 34: {
                e = this.BracketList();
                break;
            }
            case 15: {
                e = this.CurlyMap();
                break;
            }
            case 26: {
                this.jj_consume_token(26);
                e = null;
                break;
            }
            case 27: {
                this.jj_consume_token(27);
                e = Boolean.TRUE;
                break;
            }
            case 28: {
                this.jj_consume_token(28);
                e = Boolean.FALSE;
                break;
            }
            case 29: {
                this.jj_consume_token(29);
                e = UndefinedMacro.getInstance();
                break;
            }
            case 51: {
                this.jj_consume_token(51);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 30: {
                        this.jj_consume_token(30);
                        break;
                    }
                    default: {
                        this.jj_la1[80] = this.jj_gen;
                    }
                }
                e = this.Term();
                e = new Expression.NotBuilder(e);
                break;
            }
            case 55: {
                Token t = this.jj_consume_token(55);
                try {
                    e = new Integer(t.image);
                }
                catch (NumberFormatException ex) {
                    e = null;
                }
                break;
            }
            case 46: {
                this.jj_consume_token(46);
                Token t = this.jj_consume_token(55);
                try {
                    int i = Integer.parseInt(t.image);
                    e = new Integer(-i);
                }
                catch (NumberFormatException ex) {
                    e = null;
                }
                break;
            }
            default: {
                this.jj_la1[81] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return e;
    }

    public final Object Factor() throws ParseException {
        Object e = this.Term();
        while (this.jj_2_11(2)) {
            Token op;
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 30: {
                    this.jj_consume_token(30);
                    break;
                }
                default: {
                    this.jj_la1[82] = this.jj_gen;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 47: {
                    op = this.jj_consume_token(47);
                    break;
                }
                case 48: {
                    op = this.jj_consume_token(48);
                    break;
                }
                default: {
                    this.jj_la1[83] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 30: {
                    this.jj_consume_token(30);
                    break;
                }
                default: {
                    this.jj_la1[84] = this.jj_gen;
                }
            }
            Object e2 = this.Term();
            if (op.kind == 47) {
                e = new Expression.MultiplyBuilder(e, e2);
                continue;
            }
            if (op.kind == 48) {
                e = new Expression.DivideBuilder(e, e2);
                continue;
            }
            throw new ParseException("internal parser error in Factor()");
        }
        return e;
    }

    public final Object AExpression() throws ParseException {
        Object e = this.Factor();
        while (this.jj_2_12(2)) {
            Token op;
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 30: {
                    this.jj_consume_token(30);
                    break;
                }
                default: {
                    this.jj_la1[85] = this.jj_gen;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 45: {
                    op = this.jj_consume_token(45);
                    break;
                }
                case 46: {
                    op = this.jj_consume_token(46);
                    break;
                }
                default: {
                    this.jj_la1[86] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 30: {
                    this.jj_consume_token(30);
                    break;
                }
                default: {
                    this.jj_la1[87] = this.jj_gen;
                }
            }
            Object e2 = this.Factor();
            if (op.kind == 45) {
                e = new Expression.AddBuilder(e, e2);
                continue;
            }
            if (op.kind == 46) {
                e = new Expression.SubtractBuilder(e, e2);
                continue;
            }
            throw new ParseException("internal parser error in AExpression()");
        }
        return e;
    }

    public final Token RelOp() throws ParseException {
        Token t;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 42: {
                t = this.jj_consume_token(42);
                break;
            }
            case 43: {
                t = this.jj_consume_token(43);
                break;
            }
            case 44: {
                t = this.jj_consume_token(44);
                break;
            }
            case 40: {
                t = this.jj_consume_token(40);
                break;
            }
            case 41: {
                t = this.jj_consume_token(41);
                break;
            }
            case 39: {
                t = this.jj_consume_token(39);
                break;
            }
            case 38: {
                t = this.jj_consume_token(38);
                break;
            }
            default: {
                this.jj_la1[88] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return t;
    }

    public final Object CExpression() throws ParseException {
        Object e2 = null;
        Token op = null;
        Object e1 = this.AExpression();
        if (this.jj_2_13(2)) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 30: {
                    this.jj_consume_token(30);
                    break;
                }
                default: {
                    this.jj_la1[89] = this.jj_gen;
                }
            }
            op = this.RelOp();
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 30: {
                    this.jj_consume_token(30);
                    break;
                }
                default: {
                    this.jj_la1[90] = this.jj_gen;
                }
            }
            e2 = this.AExpression();
        }
        if (op == null) {
            return e1;
        }
        switch (op.kind) {
            case 42: {
                return new Expression.CompareEqBuilder(e1, e2);
            }
            case 43: {
                return new Expression.CompareEqBuilder(e1, e2);
            }
            case 44: {
                return new Expression.CompareNeBuilder(e1, e2);
            }
            case 40: {
                return new Expression.CompareGtBuilder(e1, e2);
            }
            case 41: {
                return new Expression.CompareGeBuilder(e1, e2);
            }
            case 39: {
                return new Expression.CompareLeBuilder(e1, e2);
            }
            case 38: {
                return new Expression.CompareLtBuilder(e1, e2);
            }
        }
        throw new ParseException("internal parser error in CExpression()");
    }

    public final Object AndExpression() throws ParseException {
        Object e = this.CExpression();
        while (this.jj_2_14(2)) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 30: {
                    this.jj_consume_token(30);
                    break;
                }
                default: {
                    this.jj_la1[91] = this.jj_gen;
                }
            }
            this.jj_consume_token(49);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 30: {
                    this.jj_consume_token(30);
                    break;
                }
                default: {
                    this.jj_la1[92] = this.jj_gen;
                }
            }
            Object e2 = this.CExpression();
            e = new Expression.AndBuilder(e, e2);
        }
        return e;
    }

    public final Object OrExpression() throws ParseException {
        Object e = this.AndExpression();
        while (this.jj_2_15(2)) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 30: {
                    this.jj_consume_token(30);
                    break;
                }
                default: {
                    this.jj_la1[93] = this.jj_gen;
                }
            }
            this.jj_consume_token(50);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 30: {
                    this.jj_consume_token(30);
                    break;
                }
                default: {
                    this.jj_la1[94] = this.jj_gen;
                }
            }
            Object e2 = this.AndExpression();
            e = new Expression.OrBuilder(e, e2);
        }
        return e;
    }

    public final Object Expression() throws ParseException {
        Object e = null;
        e = this.OrExpression();
        return e;
    }

    void EatWsNl() throws ParseException {
        int entryState = this.token_source.curLexState;
        this.SetState(3);
        this.OptionalWsNl();
        this.SetState(entryState);
    }

    public final void Directive(ParserBlockBuilder b) throws ParseException {
        this.jj_consume_token(23);
        this.SetState(3);
        if (this.jj_2_16(Integer.MAX_VALUE) && b.directiveOk()) {
            Token t = this.jj_consume_token(54);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 30: {
                    this.jj_consume_token(30);
                    break;
                }
                default: {
                    this.jj_la1[95] = this.jj_gen;
                }
            }
            Builder o = this.parse_directive(t.image);
            b.eatTrailingWsNl();
            b.addElement(o, t.beginLine, t.beginColumn);
        } else {
            b.addElement("#");
        }
        this.SetState(4);
    }

    public final void Comment(ParserBlockBuilder b) throws ParseException {
        this.jj_consume_token(17);
        this.SetState(2);
        if (b.directiveOk()) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 18: {
                    this.jj_consume_token(18);
                    break;
                }
                default: {
                    this.jj_la1[96] = this.jj_gen;
                }
            }
            b.eatTrailingWsNl();
        } else {
            b.addElement("##");
        }
        this.SetState(4);
    }

    public final Object DollarReference() throws ParseException {
        Object o;
        int entryState = this.token_source.curLexState;
        this.SetState(3);
        if (this.jj_2_17(Integer.MAX_VALUE)) {
            o = this.VariableReference();
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 20: {
                    this.jj_consume_token(20);
                    o = "$";
                    break;
                }
                default: {
                    this.jj_la1[97] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        this.SetState(entryState);
        return o;
    }

    public final void WMContent(ParserBlockBuilder b) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 11: {
                Token t = this.jj_consume_token(11);
                b.addElement(t.image);
                break;
            }
            case 21: {
                Token t = this.jj_consume_token(21);
                b.addElement(t.image.substring(1));
                b.markLiteral();
                break;
            }
            case 22: {
                Token t = this.jj_consume_token(22);
                b.addElement(t.image);
                break;
            }
            case 23: {
                this.Directive(b);
                break;
            }
            case 17: {
                this.Comment(b);
                break;
            }
            default: {
                this.jj_la1[98] = this.jj_gen;
                if (this.jj_2_18(Integer.MAX_VALUE)) {
                    Token t = this.getToken(1);
                    Object dr = this.DollarReference();
                    b.addElement(dr, t.beginLine, t.beginColumn);
                    break;
                }
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void WMContentNoDirective(ParserBlockBuilder b) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 11: {
                Token t = this.jj_consume_token(11);
                b.addElement(t.image);
                break;
            }
            case 21: {
                Token t = this.jj_consume_token(21);
                b.addElement(t.image.substring(1));
                b.markLiteral();
                break;
            }
            case 22: {
                Token t = this.jj_consume_token(22);
                b.addElement(t.image);
                break;
            }
            case 17: {
                this.Comment(b);
                break;
            }
            default: {
                this.jj_la1[99] = this.jj_gen;
                if (this.jj_2_19(Integer.MAX_VALUE)) {
                    Token t = this.getToken(1);
                    Object dr = this.DollarReference();
                    b.addElement(dr, t.beginLine, t.beginColumn);
                    break;
                }
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void LiteralWMContent(ParserBlockBuilder b) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 21: {
                Token t = this.jj_consume_token(21);
                b.addElement(t.image.substring(1));
                break;
            }
            case 11: 
            case 17: 
            case 20: 
            case 22: 
            case 23: {
                Token t;
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 11: {
                        t = this.jj_consume_token(11);
                        break;
                    }
                    case 22: {
                        t = this.jj_consume_token(22);
                        break;
                    }
                    case 23: {
                        t = this.jj_consume_token(23);
                        break;
                    }
                    case 20: {
                        t = this.jj_consume_token(20);
                        break;
                    }
                    case 17: {
                        t = this.jj_consume_token(17);
                        break;
                    }
                    default: {
                        this.jj_la1[100] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                b.addElement(t.image);
                break;
            }
            default: {
                this.jj_la1[101] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public final BlockBuilder LiteralBlock() throws ParseException {
        block32: {
            block31: {
                block30: {
                    block = new ParserBlockBuilder(this.templateName);
                    if (!this.jj_2_20(0x7FFFFFFF)) break block31;
                    this.jj_consume_token(15);
                    block28: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 11: 
                            case 13: 
                            case 14: 
                            case 17: 
                            case 20: 
                            case 21: 
                            case 22: 
                            case 23: {
                                break;
                            }
                            default: {
                                this.jj_la1[102] = this.jj_gen;
                                break block30;
                            }
                        }
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 11: 
                            case 17: 
                            case 20: 
                            case 21: 
                            case 22: 
                            case 23: {
                                this.LiteralWMContent(block);
                                continue block28;
                            }
                            case 13: 
                            case 14: {
                                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                    case 14: {
                                        t = this.jj_consume_token(14);
                                        break;
                                    }
                                    case 13: {
                                        t = this.jj_consume_token(13);
                                        break;
                                    }
                                    default: {
                                        this.jj_la1[103] = this.jj_gen;
                                        this.jj_consume_token(-1);
                                        throw new ParseException();
                                    }
                                }
                                block.addElement(t.image);
                                continue block28;
                            }
                        }
                        break;
                    }
                    this.jj_la1[104] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
                this.jj_consume_token(12);
                break block32;
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 17: 
                case 20: 
                case 21: 
                case 22: 
                case 23: {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 14: {
                            this.jj_consume_token(14);
                            break;
                        }
                        default: {
                            this.jj_la1[105] = this.jj_gen;
                        }
                    }
                    block29: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 11: 
                            case 12: 
                            case 15: 
                            case 17: 
                            case 20: 
                            case 21: 
                            case 22: 
                            case 23: {
                                break;
                            }
                            default: {
                                this.jj_la1[106] = this.jj_gen;
                                ** GOTO lbl79
                            }
                        }
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 11: 
                            case 17: 
                            case 20: 
                            case 21: 
                            case 22: 
                            case 23: {
                                this.LiteralWMContent(block);
                                continue block29;
                            }
                            case 12: 
                            case 15: {
                                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                    case 15: {
                                        t = this.jj_consume_token(15);
                                        break;
                                    }
                                    case 12: {
                                        t = this.jj_consume_token(12);
                                        break;
                                    }
                                    default: {
                                        this.jj_la1[107] = this.jj_gen;
                                        this.jj_consume_token(-1);
                                        throw new ParseException();
                                    }
                                }
                                block.addElement(t.image);
                                continue block29;
                            }
                        }
                        break;
                    }
                    this.jj_la1[108] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
lbl79:
                    // 1 sources

                    this.jj_consume_token(13);
                    break;
                }
                default: {
                    this.jj_la1[109] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        return block;
    }

    public final BlockBuilder Block(Directive.Subdirective[] subdirectives) throws ParseException {
        ParserBlockBuilder block = new ParserBlockBuilder(this.templateName);
        this.blockStack.push(subdirectives);
        if (this.jj_2_23(Integer.MAX_VALUE)) {
            block31: {
                this.jj_consume_token(15);
                this.EatWsNlIfNl(block);
                block26: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 11: 
                        case 13: 
                        case 14: 
                        case 17: 
                        case 20: 
                        case 21: 
                        case 22: 
                        case 23: {
                            break;
                        }
                        default: {
                            this.jj_la1[110] = this.jj_gen;
                            break block31;
                        }
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 11: 
                        case 17: 
                        case 20: 
                        case 21: 
                        case 22: 
                        case 23: {
                            this.WMContent(block);
                            continue block26;
                        }
                        case 13: 
                        case 14: {
                            Token t;
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 14: {
                                    t = this.jj_consume_token(14);
                                    break;
                                }
                                case 13: {
                                    t = this.jj_consume_token(13);
                                    break;
                                }
                                default: {
                                    this.jj_la1[111] = this.jj_gen;
                                    this.jj_consume_token(-1);
                                    throw new ParseException();
                                }
                            }
                            block.addElement(t.image);
                            continue block26;
                        }
                    }
                    break;
                }
                this.jj_la1[112] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            this.jj_consume_token(12);
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 14: {
                    this.jj_consume_token(14);
                    this.EatWsNlOrSpace(block);
                    break;
                }
                default: {
                    this.jj_la1[113] = this.jj_gen;
                }
            }
            block27: while (this.jj_2_21(1)) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 11: 
                    case 17: 
                    case 20: 
                    case 21: 
                    case 22: {
                        this.WMContentNoDirective(block);
                        continue block27;
                    }
                    case 0: {
                        this.jj_consume_token(0);
                        throw new ParseException("Unclosed block beginning at line " + this.token.beginLine + ".  Check for invalid directive options or missing a #end");
                    }
                    case 12: 
                    case 15: {
                        Token t;
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 15: {
                                t = this.jj_consume_token(15);
                                break;
                            }
                            case 12: {
                                t = this.jj_consume_token(12);
                                break;
                            }
                            default: {
                                this.jj_la1[114] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        block.addElement(t.image);
                        continue block27;
                    }
                }
                this.jj_la1[115] = this.jj_gen;
                if (this.jj_2_22(Integer.MAX_VALUE) && this.lookahead_not_breaking_subd()) {
                    this.Directive(block);
                    continue;
                }
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 13: {
                    this.jj_consume_token(13);
                    block.eatOneWs();
                    break;
                }
                default: {
                    this.jj_la1[116] = this.jj_gen;
                }
            }
        }
        this.blockStack.pop();
        return block;
    }

    public final BlockBuilder WMDocument() throws ParseException {
        ParserBlockBuilder block;
        block14: {
            block = new ParserBlockBuilder(this.templateName);
            block13: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: 
                    case 17: 
                    case 20: 
                    case 21: 
                    case 22: 
                    case 23: {
                        break;
                    }
                    default: {
                        this.jj_la1[117] = this.jj_gen;
                        break block14;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 11: 
                    case 17: 
                    case 20: 
                    case 21: 
                    case 22: 
                    case 23: {
                        this.WMContent(block);
                        continue block13;
                    }
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: {
                        Token t;
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 14: {
                                t = this.jj_consume_token(14);
                                break;
                            }
                            case 13: {
                                t = this.jj_consume_token(13);
                                break;
                            }
                            case 15: {
                                t = this.jj_consume_token(15);
                                break;
                            }
                            case 12: {
                                t = this.jj_consume_token(12);
                                break;
                            }
                            default: {
                                this.jj_la1[118] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        block.addElement(t.image);
                        continue block13;
                    }
                }
                break;
            }
            this.jj_la1[119] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        this.jj_consume_token(0);
        return block;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_3(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_3();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(2, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_4(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_4();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(3, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_5(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_5();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(4, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_6(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_6();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(5, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_7(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_7();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(6, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_8(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_8();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(7, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_9(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_9();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(8, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_10(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_10();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(9, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_11(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_11();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(10, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_12(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_12();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(11, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_13(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_13();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(12, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_14(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_14();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(13, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_15(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_15();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(14, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_16(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_16();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(15, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_17(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_17();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(16, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_18(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_18();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(17, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_19(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_19();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(18, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_20(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_20();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(19, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_21(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_21();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(20, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_22(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_22();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(21, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_23(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_23();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(22, xla);
        }
    }

    private boolean jj_3_5() {
        if (this.jj_scan_token(30)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(14)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(15)) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_28() {
        return this.jj_3R_26();
    }

    private boolean jj_3_19() {
        return this.jj_scan_token(20);
    }

    private boolean jj_3R_52() {
        return this.jj_scan_token(15);
    }

    private boolean jj_3_6() {
        if (this.jj_scan_token(54)) {
            return true;
        }
        return this.jj_scan_token(32);
    }

    private boolean jj_3R_57() {
        return this.jj_3R_61();
    }

    private boolean jj_3R_56() {
        return this.jj_3R_60();
    }

    private boolean jj_3R_55() {
        return this.jj_scan_token(22);
    }

    private boolean jj_3R_54() {
        return this.jj_scan_token(21);
    }

    private boolean jj_3_2() {
        return this.jj_scan_token(31);
    }

    private boolean jj_3_11() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(30)) {
            this.jj_scanpos = xsp;
        }
        xsp = this.jj_scanpos;
        if (this.jj_scan_token(47)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(48)) {
                return true;
            }
        }
        xsp = this.jj_scanpos;
        if (this.jj_scan_token(30)) {
            this.jj_scanpos = xsp;
        }
        return this.jj_3R_25();
    }

    private boolean jj_3_18() {
        return this.jj_scan_token(20);
    }

    private boolean jj_3R_53() {
        return this.jj_scan_token(11);
    }

    private boolean jj_3_15() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(30)) {
            this.jj_scanpos = xsp;
        }
        if (this.jj_scan_token(50)) {
            return true;
        }
        xsp = this.jj_scanpos;
        if (this.jj_scan_token(30)) {
            this.jj_scanpos = xsp;
        }
        return this.jj_3R_30();
    }

    private boolean jj_3R_47() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_53()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_54()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_55()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_56()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_57()) {
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_26() {
        return this.jj_3R_25();
    }

    private boolean jj_3_4() {
        return this.jj_scan_token(30);
    }

    private boolean jj_3R_46() {
        return this.jj_scan_token(46);
    }

    private boolean jj_3_10() {
        return this.jj_scan_token(20);
    }

    private boolean jj_3_3() {
        return this.jj_scan_token(31);
    }

    private boolean jj_3R_45() {
        return this.jj_scan_token(55);
    }

    private boolean jj_3R_44() {
        return this.jj_scan_token(51);
    }

    private boolean jj_3R_43() {
        return this.jj_scan_token(29);
    }

    private boolean jj_3_14() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(30)) {
            this.jj_scanpos = xsp;
        }
        if (this.jj_scan_token(49)) {
            return true;
        }
        xsp = this.jj_scanpos;
        if (this.jj_scan_token(30)) {
            this.jj_scanpos = xsp;
        }
        return this.jj_3R_29();
    }

    private boolean jj_3R_42() {
        return this.jj_scan_token(28);
    }

    private boolean jj_3R_41() {
        return this.jj_scan_token(27);
    }

    private boolean jj_3R_40() {
        return this.jj_scan_token(26);
    }

    private boolean jj_3R_39() {
        return this.jj_3R_52();
    }

    private boolean jj_3_9() {
        return this.jj_scan_token(20);
    }

    private boolean jj_3R_30() {
        return this.jj_3R_29();
    }

    private boolean jj_3_22() {
        return this.jj_scan_token(23);
    }

    private boolean jj_3R_38() {
        return this.jj_3R_51();
    }

    private boolean jj_3_17() {
        if (this.jj_scan_token(20)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(20)) {
            this.jj_scanpos = xsp;
        }
        xsp = this.jj_scanpos;
        if (this.jj_scan_token(32)) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(54);
    }

    private boolean jj_3R_37() {
        return this.jj_3R_50();
    }

    private boolean jj_3R_36() {
        return this.jj_scan_token(32);
    }

    private boolean jj_3_1() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(30)) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(31);
    }

    private boolean jj_3R_35() {
        return this.jj_3R_49();
    }

    private boolean jj_3R_63() {
        return this.jj_scan_token(20);
    }

    private boolean jj_3R_59() {
        return this.jj_scan_token(25);
    }

    private boolean jj_3R_25() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_35()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_36()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_37()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_38()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_39()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_40()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3R_41()) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_3R_42()) {
                                        this.jj_scanpos = xsp;
                                        if (this.jj_3R_43()) {
                                            this.jj_scanpos = xsp;
                                            if (this.jj_3R_44()) {
                                                this.jj_scanpos = xsp;
                                                if (this.jj_3R_45()) {
                                                    this.jj_scanpos = xsp;
                                                    if (this.jj_3R_46()) {
                                                        return true;
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_34() {
        return this.jj_3R_48();
    }

    private boolean jj_3R_62() {
        return this.jj_3R_49();
    }

    private boolean jj_3R_33() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(15)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(12)) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_32() {
        return this.jj_scan_token(0);
    }

    private boolean jj_3R_61() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_62()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_63()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_21() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_31()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_32()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_33()) {
                    this.jj_scanpos = xsp;
                    this.jj_lookingAhead = true;
                    this.jj_semLA = this.lookahead_not_breaking_subd();
                    this.jj_lookingAhead = false;
                    if (!this.jj_semLA || this.jj_3R_34()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_31() {
        return this.jj_3R_47();
    }

    private boolean jj_3R_58() {
        return this.jj_scan_token(24);
    }

    private boolean jj_3_23() {
        return this.jj_scan_token(15);
    }

    private boolean jj_3_13() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(30)) {
            this.jj_scanpos = xsp;
        }
        if (this.jj_3R_27()) {
            return true;
        }
        xsp = this.jj_scanpos;
        if (this.jj_scan_token(30)) {
            this.jj_scanpos = xsp;
        }
        return this.jj_3R_28();
    }

    private boolean jj_3R_50() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_58()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_59()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_29() {
        return this.jj_3R_28();
    }

    private boolean jj_3R_60() {
        return this.jj_scan_token(17);
    }

    private boolean jj_3_16() {
        return this.jj_scan_token(54);
    }

    private boolean jj_3R_27() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(42)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(43)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(44)) {
                    this.jj_scanpos = xsp;
                    if (this.jj_scan_token(40)) {
                        this.jj_scanpos = xsp;
                        if (this.jj_scan_token(41)) {
                            this.jj_scanpos = xsp;
                            if (this.jj_scan_token(39)) {
                                this.jj_scanpos = xsp;
                                if (this.jj_scan_token(38)) {
                                    return true;
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3_20() {
        return this.jj_scan_token(15);
    }

    private boolean jj_3R_51() {
        return this.jj_scan_token(34);
    }

    private boolean jj_3R_48() {
        return this.jj_scan_token(23);
    }

    private boolean jj_3_8() {
        if (this.jj_scan_token(54)) {
            return true;
        }
        return this.jj_scan_token(53);
    }

    private boolean jj_3R_49() {
        return this.jj_scan_token(20);
    }

    private boolean jj_3_7() {
        if (this.jj_scan_token(37)) {
            return true;
        }
        return this.jj_scan_token(54);
    }

    private boolean jj_3_12() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(30)) {
            this.jj_scanpos = xsp;
        }
        xsp = this.jj_scanpos;
        if (this.jj_scan_token(45)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(46)) {
                return true;
            }
        }
        xsp = this.jj_scanpos;
        if (this.jj_scan_token(30)) {
            this.jj_scanpos = xsp;
        }
        return this.jj_3R_26();
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{0x40000000, -1073741824, 0x40000000, Integer.MIN_VALUE, 0x40000000, Integer.MIN_VALUE, 0x40000000, -1073741824, -1073741824, 0x40000000, 0x40000000, 0x40000000, 0x40000000, 0x40000000, 0x40000000, 0x40000000, 0x40000000, 0x40000000, 0x40000000, 0x40000000, 0x40000000, 0x40000000, 0x40000000, 0x40000000, 0x40000000, 0x40000000, 0x40000000, 0x40000000, 0, 0, 0x100000, 0, 0x700000, 0x600000, 0x700000, 0x600000, 0x3000000, 0x3100000, -1073741824, -1073741824, -1073741824, -1073741824, -1073741824, -1073741824, -1073741824, -1073741824, -1073741824, 0, -1073741824, -1073741824, -1073741824, -1073741824, -1073741824, -1073741824, -1073741824, -1073741824, -1073741824, -1073741824, -1073741824, -1073741824, 1058045952, -1073741824, -1073741824, -1073741824, 0x40000000, 0x40000000, 0, 0x40000000, 0x40000000, 2131787776, 0x40000000, 0x40000000, 0, 0x40000000, 0x40000000, 0x40100000, 0, 0, 0x40000000, 0x40000000, 0x40000000, 1058045952, 0x40000000, 0, 0x40000000, 0x40000000, 0, 0x40000000, 0, 0x40000000, 0x40000000, 0x40000000, 0x40000000, 0x40000000, 0x40000000, 0x40000000, 262144, 0x100000, 14813184, 6424576, 13764608, 15861760, 15886336, 24576, 15886336, 16384, 15898624, 36864, 15898624, 15923200, 15886336, 24576, 15886336, 16384, 36864, 7510017, 8192, 15923200, 61440, 15923200};
    }

    private static void jj_la1_init_1() {
        jj_la1_1 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x400000, 1, 0, 0x400001, 0x2000000, 0x2000000, 0x4000000, 0x4000000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x100000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8929285, 0, 0, 0, 0, 0, 0x100000, 0, 0, 8929285, 0, 0, 0x100000, 0, 0, 0, 1, 1, 0, 0, 0, 8929285, 0, 98304, 0, 0, 24576, 0, 8128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    }

    public WMParser_impl(CharStream stream) {
        int i;
        this.token_source = new WMParser_implTokenManager(stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 120; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(CharStream stream) {
        int i;
        this.token_source.ReInit(stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_lookingAhead = false;
        this.jj_gen = 0;
        for (i = 0; i < 120; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public WMParser_impl(WMParser_implTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 120; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(WMParser_implTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 120; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.jj_lookingAhead ? this.jj_scanpos : this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            Iterator it = this.jj_expentries.iterator();
            block1: while (it.hasNext()) {
                int[] oldentry = (int[])it.next();
                if (oldentry.length != this.jj_expentry.length) continue;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] != this.jj_expentry[i]) continue block1;
                }
                this.jj_expentries.add(this.jj_expentry);
                break;
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[59];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 120; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) == 0) continue;
                la1tokens[32 + j] = true;
            }
        }
        for (i = 0; i < 59; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = (int[])this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 23; ++i) {
            try {
                JJCalls p = this.jj_2_rtns[i];
                do {
                    if (p.gen <= this.jj_gen) continue;
                    this.jj_la = p.arg;
                    this.jj_lastpos = this.jj_scanpos = p.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                            break;
                        }
                        case 1: {
                            this.jj_3_2();
                            break;
                        }
                        case 2: {
                            this.jj_3_3();
                            break;
                        }
                        case 3: {
                            this.jj_3_4();
                            break;
                        }
                        case 4: {
                            this.jj_3_5();
                            break;
                        }
                        case 5: {
                            this.jj_3_6();
                            break;
                        }
                        case 6: {
                            this.jj_3_7();
                            break;
                        }
                        case 7: {
                            this.jj_3_8();
                            break;
                        }
                        case 8: {
                            this.jj_3_9();
                            break;
                        }
                        case 9: {
                            this.jj_3_10();
                            break;
                        }
                        case 10: {
                            this.jj_3_11();
                            break;
                        }
                        case 11: {
                            this.jj_3_12();
                            break;
                        }
                        case 12: {
                            this.jj_3_13();
                            break;
                        }
                        case 13: {
                            this.jj_3_14();
                            break;
                        }
                        case 14: {
                            this.jj_3_15();
                            break;
                        }
                        case 15: {
                            this.jj_3_16();
                            break;
                        }
                        case 16: {
                            this.jj_3_17();
                            break;
                        }
                        case 17: {
                            this.jj_3_18();
                            break;
                        }
                        case 18: {
                            this.jj_3_19();
                            break;
                        }
                        case 19: {
                            this.jj_3_20();
                            break;
                        }
                        case 20: {
                            this.jj_3_21();
                            break;
                        }
                        case 21: {
                            this.jj_3_22();
                            break;
                        }
                        case 22: {
                            this.jj_3_23();
                        }
                    }
                } while ((p = p.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static {
        WMParser_impl.jj_la1_init_0();
        WMParser_impl.jj_la1_init_1();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends Error {
        private static final long serialVersionUID = 1L;

        private LookaheadSuccess() {
        }
    }
}

