/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.resource;

import java.io.File;
import org.webmacro.ResourceException;
import org.webmacro.Template;
import org.webmacro.resource.AbstractTemplateLoader;
import org.webmacro.resource.CacheElement;

public class FileTemplateLoader
extends AbstractTemplateLoader {
    private String path;

    public void setConfig(String config) {
        this.path = config;
        File f = new File(this.path);
        if (!f.exists()) {
            this.log.warning("FileTemplateLoader: " + f.getAbsolutePath() + " does not exist.");
        } else if (!f.isDirectory()) {
            this.log.warning("FileTemplateLoader: " + f.getAbsolutePath() + " is not a directory.");
        }
    }

    public final Template load(String query, CacheElement ce) throws ResourceException {
        File tFile = new File(this.path, query);
        if (tFile.isFile() && tFile.canRead()) {
            if (this.log.loggingDebug()) {
                this.log.debug("FileTemplateProvider: Found template " + tFile.getAbsolutePath());
            }
            return this.helper.load(tFile, ce);
        }
        return null;
    }
}

