/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.resource;

import java.util.HashMap;
import java.util.Map;
import org.webmacro.Broker;
import org.webmacro.InitException;
import org.webmacro.Log;
import org.webmacro.resource.CacheReloadContext;
import org.webmacro.resource.TimedReloadContext;
import org.webmacro.util.Settings;

public class ReloadDelayDecorator {
    private Map reloadDelays = new HashMap(11);
    private long defaultDelay;
    private Log log;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(Broker b, Settings config) throws InitException {
        this.defaultDelay = 0L;
        Map map = this.reloadDelays;
        synchronized (map) {
            config.processListSetting("CheckForReloadDelay", new Settings.ListSettingHandler(){

                public void processSetting(String key, String value) {
                    if (key == null || key.length() == 0) {
                        ReloadDelayDecorator.this.defaultDelay = Long.parseLong(value);
                    } else {
                        ReloadDelayDecorator.this.reloadDelays.put(key, Long.valueOf(value));
                    }
                }
            });
        }
        this.log = b.getLog("resource", "ReloadDelayDecorator");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheReloadContext decorate(String protocol, CacheReloadContext reloadContext) {
        long delay;
        Long l;
        Map map = this.reloadDelays;
        synchronized (map) {
            l = (Long)this.reloadDelays.get(protocol);
        }
        long l2 = delay = l != null ? l : this.defaultDelay;
        if (delay > 0L) {
            if (this.log.loggingDebug()) {
                this.log.debug("Returning timed reload context with delay " + delay);
            }
            return new TimedReloadContext(reloadContext, delay);
        }
        if (this.log.loggingDebug()) {
            this.log.debug("Returning unmodified reload context");
        }
        return reloadContext;
    }
}

