/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.resource;

import EDU.oswego.cs.dl.util.concurrent.ClockDaemon;
import EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
import EDU.oswego.cs.dl.util.concurrent.ThreadFactory;
import java.lang.ref.SoftReference;
import org.webmacro.Broker;
import org.webmacro.InitException;
import org.webmacro.Log;
import org.webmacro.ResourceException;
import org.webmacro.resource.CacheElement;
import org.webmacro.resource.CacheManager;
import org.webmacro.resource.CacheReloadContext;
import org.webmacro.resource.ResourceLoader;
import org.webmacro.resource.TimedReloadContext;
import org.webmacro.util.Settings;
import org.webmacro.util.SubSettings;

public class ReloadingCacheManager
implements CacheManager {
    private static final String NAME = "ReloadingCacheManager";
    private final ConcurrentHashMap _cache = new ConcurrentHashMap();
    private int _cacheDuration;
    private String _resourceType;
    private boolean _reloadOnChange = true;
    private boolean _useSoftReferences = true;
    private boolean _delayReloadChecks = false;
    private long _checkForReloadDelay;
    private ClockDaemon _clockDaemon;
    private Log _log;

    public void init(Broker b, Settings config, String resourceType) throws InitException {
        this._clockDaemon = new ClockDaemon();
        this._clockDaemon.setThreadFactory(new ThreadFactory(){

            public Thread newThread(Runnable runnable) {
                ReloadingCacheManager.this._log.info("Creating new ClockDaemon thread");
                Thread t = new Thread(runnable);
                t.setDaemon(true);
                return t;
            }
        });
        this._log = b.getLog("resource", "Object loading and caching");
        this._resourceType = resourceType;
        SubSettings ourSettings = new SubSettings(config, "ReloadingCacheManager." + this._resourceType);
        SubSettings defaultSettings = new SubSettings(config, "ReloadingCacheManager.*");
        this._cacheDuration = ourSettings.getIntegerSetting("ExpireTime", defaultSettings.getIntegerSetting("ExpireTime", config.getIntegerSetting("TemplateExpireTime", 0)));
        boolean bl = ((Settings)ourSettings).containsKey("UseSoftReferences") ? ourSettings.getBooleanSetting("UseSoftReferences") : (this._useSoftReferences = ((Settings)defaultSettings).containsKey("UseSoftReferences") ? defaultSettings.getBooleanSetting("UseSoftReferences") : true);
        this._reloadOnChange = ((Settings)ourSettings).containsKey("ReloadOnChange") ? ourSettings.getBooleanSetting("ReloadOnChange") : (((Settings)defaultSettings).containsKey("ReloadOnChange") ? defaultSettings.getBooleanSetting("ReloadOnChange") : true);
        this._checkForReloadDelay = ourSettings.getIntegerSetting("CheckForReloadDelay", defaultSettings.getIntegerSetting("CheckForReloadDelay", -1));
        this._delayReloadChecks = this._checkForReloadDelay > 0L;
        this._log.info("ReloadingCacheManager." + this._resourceType + ": " + "; expireTime=" + this._cacheDuration + "; reload=" + this._reloadOnChange + "; softReference=" + this._useSoftReferences + "; checkForReloadDelay=" + this._checkForReloadDelay);
    }

    private MyCacheElement newCacheElement() {
        if (this._useSoftReferences) {
            return new SoftScmCacheElement();
        }
        return new DirectScmCacheElement();
    }

    public void flush() {
        this._cache.clear();
    }

    public void destroy() {
        this._cache.clear();
        this._clockDaemon.shutDown();
    }

    public boolean supportsReload() {
        return this._reloadOnChange;
    }

    private final void scheduleRemoval(final Object key) {
        this._clockDaemon.executeAfterDelay((long)this._cacheDuration, new Runnable(){

            public void run() {
                ReloadingCacheManager.this._cache.remove(key);
                if (ReloadingCacheManager.this._log.loggingDebug()) {
                    ReloadingCacheManager.this._log.debug("cache expired: " + key);
                }
            }
        });
    }

    public Object get(Object query, ResourceLoader helper) throws ResourceException {
        Object o = null;
        boolean reload = false;
        MyCacheElement r = (MyCacheElement)this._cache.get(query);
        if (r != null && (o = r.getObject()) != null && r.reloadContext != null && this._reloadOnChange) {
            reload = r.reloadContext.shouldReload();
        }
        if ((o == null || reload) && (o = helper.load(query, (CacheElement)(r = this.newCacheElement()))) != null) {
            r.setObject(o);
            this._cache.put(query, (Object)r);
            if (this._log.loggingDebug()) {
                this._log.debug("cached: " + query + " for " + this._cacheDuration);
            }
            try {
                if (this._cacheDuration >= 0) {
                    this.scheduleRemoval(query);
                }
            }
            catch (Exception e) {
                this._log.error("CachingProvider caught an exception", e);
            }
        }
        return o;
    }

    public Object get(Object query) {
        MyCacheElement r = (MyCacheElement)this._cache.get(query);
        if (r != null) {
            return r.getObject();
        }
        return null;
    }

    public void put(Object query, Object resource) {
        MyCacheElement r = this.newCacheElement();
        r.setObject(resource);
        this._cache.put(query, (Object)r);
        if (this._cacheDuration >= 0) {
            if (this._log.loggingDebug()) {
                this._log.debug("cached: " + query + " for " + this._cacheDuration);
            }
            this.scheduleRemoval(query);
        }
    }

    public void invalidate(Object query) {
        this._cache.remove(query);
    }

    public String toString() {
        return "ReloadingCacheManager(type = " + this._resourceType + ")";
    }

    private final class DirectScmCacheElement
    extends MyCacheElement {
        private Object object;

        private DirectScmCacheElement() {
        }

        public Object getObject() {
            return this.object;
        }

        public void setObject(Object o) {
            this.object = o;
        }
    }

    private final class SoftScmCacheElement
    extends MyCacheElement {
        private SoftReference reference;

        private SoftScmCacheElement() {
        }

        public Object getObject() {
            return this.reference.get();
        }

        public void setObject(Object o) {
            this.reference = new SoftReference<Object>(o);
        }
    }

    private abstract class MyCacheElement
    extends CacheElement
    implements Cloneable {
        private CacheReloadContext reloadContext = null;

        private MyCacheElement() {
        }

        public void setReloadContext(CacheReloadContext rc) {
            this.reloadContext = ReloadingCacheManager.this._delayReloadChecks && rc != null ? new TimedReloadContext(rc, ReloadingCacheManager.this._checkForReloadDelay) : rc;
        }

        public abstract Object getObject();

        public abstract void setObject(Object var1);
    }
}

