/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.servlet;

import java.util.Map;
import java.util.Properties;
import java.util.WeakHashMap;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import org.webmacro.Broker;
import org.webmacro.InitException;
import org.webmacro.servlet.Servlet20Broker;
import org.webmacro.servlet.Servlet22Broker;
import org.webmacro.servlet.ServletLog;
import org.webmacro.util.Settings;

public abstract class ServletBroker
extends Broker {
    protected ServletContext _servletContext;
    private static Map servletContextsWithLogTargets = new WeakHashMap();

    protected ServletBroker(ServletContext sc) throws InitException {
        super(null, sc.toString());
        this._servletContext = sc;
    }

    public void initLog(Settings config) {
        String logFile = config.getSetting("LogFile");
        if ((logFile == null || logFile.equals("")) && this._config.getBooleanSetting("LogUsingServletLog")) {
            this.addLogTarget();
        } else {
            this.initLog();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addLogTarget() {
        Map map = servletContextsWithLogTargets;
        synchronized (map) {
            if (!servletContextsWithLogTargets.containsKey(this._servletContext)) {
                this._ls.addTarget(new ServletLog(this._servletContext, this._config));
                servletContextsWithLogTargets.put(this._servletContext, Boolean.TRUE);
            }
        }
    }

    public static Broker getBroker(Servlet s, Properties additionalProperties) throws InitException {
        int minorVersion;
        int majorVersion;
        ServletContext sc = s.getServletConfig().getServletContext();
        try {
            majorVersion = sc.getMajorVersion();
            minorVersion = sc.getMinorVersion();
        }
        catch (NoSuchMethodError e) {
            majorVersion = 2;
            minorVersion = 0;
        }
        Broker b = majorVersion > 2 || majorVersion == 2 && minorVersion >= 2 ? Servlet22Broker.getBroker(s, additionalProperties) : Servlet20Broker.getBroker(s, additionalProperties);
        return b;
    }

    public static Broker getBroker(ServletContext sc, ClassLoader cl, Properties additionalProperties) throws InitException {
        int minorVersion;
        int majorVersion;
        try {
            majorVersion = sc.getMajorVersion();
            minorVersion = sc.getMinorVersion();
        }
        catch (NoSuchMethodError e) {
            majorVersion = 2;
            minorVersion = 0;
        }
        Broker b = majorVersion > 2 || majorVersion == 2 && minorVersion >= 2 ? Servlet22Broker.getBroker(sc, cl, additionalProperties) : Servlet20Broker.getBroker(sc, cl, additionalProperties);
        return b;
    }

    public static Broker getBroker(Servlet s) throws InitException {
        return ServletBroker.getBroker(s, null);
    }

    public ServletContext getServletContext() {
        return this._servletContext;
    }

    protected static final class PropertiesPair {
        private final Object obj;
        private final Properties p;

        public PropertiesPair(Object s, Properties p) {
            this.obj = s;
            this.p = p;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof PropertiesPair)) {
                return false;
            }
            PropertiesPair servletPropertiesPair = (PropertiesPair)o;
            if (!this.p.equals(servletPropertiesPair.p)) {
                return false;
            }
            return this.obj.equals(servletPropertiesPair.obj);
        }

        public int hashCode() {
            int result = this.obj.hashCode();
            result = 29 * result + this.p.hashCode();
            return result;
        }
    }
}

