/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.servlet;

import java.util.ArrayList;
import java.util.Map;
import org.webmacro.Context;
import org.webmacro.ContextTool;
import org.webmacro.PropertyException;
import org.webmacro.ResourceException;
import org.webmacro.Template;
import org.webmacro.engine.StringTemplate;

public class TemplateTool
extends ContextTool {
    private Context _context = null;

    public Object init(Context c) throws PropertyException {
        this._context = c;
        return new MacroTemplateFactory(this._context);
    }

    public class MacroTemplate {
        private Template _template;
        private Context _context;
        private Context _origContext;

        public MacroTemplate(Context c, Template t) {
            this._template = t;
            this._origContext = c;
            this._context = c.cloneContext();
        }

        public MacroTemplate(Context c, String src) {
            this(c, new StringTemplate(c.getBroker(), src));
        }

        public Context getArgs() {
            return this._context;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object eval() throws PropertyException {
            Context context = this._context;
            synchronized (context) {
                return this._template.evaluateAsString(this._context);
            }
        }

        public Object eval(Object[] args) throws PropertyException {
            if (args != null) {
                for (int i = 0; i < args.length; ++i) {
                    this._context.put((Object)("arg" + (i + 1)), args[i]);
                }
                this._context.put((Object)"args", args);
            }
            return this.eval();
        }

        public Object eval(Object[] args, Object[] names) throws PropertyException {
            if (args == null || names == null || args.length != names.length) {
                throw new PropertyException("Usage error: both args must be arrays of equal length!");
            }
            for (int i = 0; i < args.length; ++i) {
                this._context.put(names[i], args[i]);
            }
            this._context.put((Object)"args", args);
            return this.eval();
        }

        public Object eval(Map map) throws PropertyException {
            this._context.putAll(map);
            return this.eval();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void copyCurrentContext() {
            Context context = this._context;
            synchronized (context) {
                this._context.putAll((Map)this._origContext);
            }
        }
    }

    public class MacroTemplateFactory {
        private Context _context;
        private ArrayList _macros = new ArrayList(10);

        public MacroTemplateFactory(Context ctx) {
            this._context = ctx;
        }

        public MacroTemplate fromString(String s) {
            MacroTemplate mt = new MacroTemplate(this._context, s);
            this._macros.add(mt);
            return mt;
        }

        public MacroTemplate fromFile(String fileRef) throws ResourceException {
            Template t = (Template)this._context.getBroker().getProvider("template").get(fileRef);
            MacroTemplate mt = new MacroTemplate(this._context, t);
            this._macros.add(mt);
            return mt;
        }
    }
}

