/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.servlet;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpUtils;
import org.webmacro.Context;
import org.webmacro.ContextTool;
import org.webmacro.PropertyException;
import org.webmacro.servlet.WebContext;

public class URLTool
extends ContextTool {
    public Object init(Context context) throws PropertyException {
        try {
            WebContext wc = (WebContext)context;
            return new URLToolImpl(wc);
        }
        catch (ClassCastException ce) {
            throw new PropertyException("URLTool only works with WebContext", ce);
        }
    }

    public class URLToolImpl {
        private final WebContext context;

        public URLToolImpl(WebContext context) {
            this.context = context;
        }

        public String getRequestURL() {
            return HttpUtils.getRequestURL((HttpServletRequest)this.context.getRequest()).toString();
        }

        public String getCompleteRequestURL() {
            HttpServletRequest req = this.context.getRequest();
            StringBuffer b = HttpUtils.getRequestURL((HttpServletRequest)req);
            String query = req.getQueryString();
            if (query != null) {
                b.append("?");
                b.append(query);
            }
            return b.toString();
        }

        public String encode(String url) {
            return this.context.getResponse().encodeURL(url);
        }
    }
}

