/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.servlet;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Locale;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.webmacro.Broker;
import org.webmacro.Context;
import org.webmacro.FastWriter;
import org.webmacro.InitException;
import org.webmacro.Log;
import org.webmacro.NotFoundException;
import org.webmacro.PropertyException;
import org.webmacro.ResourceException;
import org.webmacro.Template;
import org.webmacro.WM;
import org.webmacro.WebMacro;
import org.webmacro.engine.StringTemplate;
import org.webmacro.servlet.HandlerException;
import org.webmacro.servlet.WebContext;
import org.webmacro.util.LogSystem;

public abstract class WMServlet
extends HttpServlet
implements WebMacro {
    private WebMacro _wm = null;
    private Broker _broker = null;
    private boolean _started = false;
    static final String ERROR_VARIABLE = "ErrorVariable";
    static final String ERROR_TEMPLATE = "ErrorTemplate";
    static final String ERROR_TEMPLATE_DEFAULT = "error.wm";
    static final String ERROR_VARIABLE_DEFAULT = "error";
    protected Log _log;
    private String _problem = "Not yet initialized: Your servlet API tried to access WebMacro without first calling init()!!!";
    private static final String DEFAULT_ERROR_TEXT = "<HTML><HEAD><TITLE>Error</TITLE></HEAD>\n#set $Response.ContentType = \"text/html\"\n<BODY><H1>Error</H1><HR>$error</BODY></HTML>";
    private Template _errorTemplate = null;

    public synchronized void init(ServletConfig sc) throws ServletException {
        super.init(sc);
        this.init();
    }

    public synchronized void init() {
        if (this._started) {
            return;
        }
        if (this._wm == null) {
            try {
                this._wm = this.initWebMacro();
                this._broker = this._wm.getBroker();
            }
            catch (InitException e) {
                this._problem = "Could not initialize the broker!\n\n*** Check that WebMacro.properties was in your servlet\n*** classpath, in a similar place to webmacro.jar \n*** and that all values were set correctly.\n\n" + e.getMessage();
                Log sysLog = LogSystem.getSystemLog("servlet");
                sysLog.error(this._problem, e);
                return;
            }
        }
        this._log = this._broker.getLog("servlet", "WMServlet lifecycle information");
        try {
            if (this._log.loggingDebug()) {
                URL url = this.getBroker().getResource("WebMacro.properties");
                if (url != null) {
                    this._log.debug("Using properties from " + url.toExternalForm());
                } else {
                    this._log.debug("No WebMacro.properties file was found.");
                }
            }
            this.start();
            this._problem = null;
        }
        catch (ServletException e) {
            this._problem = "WebMacro application code failed to initialize: \n" + (Object)((Object)e) + "\n" + "This error is the result of a failure in the\n" + "code supplied by the application programmer.\n";
            this._log.error(this._problem, e);
        }
        this._log.notice("started: " + this);
        this._started = true;
    }

    public synchronized void destroy() {
        this.stop();
        this._wm.destroy();
        this._log.notice("stopped: " + this);
        this._wm = null;
        this._started = false;
        super.destroy();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doRequest(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doRequest(req, resp);
    }

    private final void doRequest(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        WebContext context = null;
        if (this._problem != null) {
            this.init();
            if (this._problem != null) {
                try {
                    resp.setContentType("text/html");
                    PrintWriter out = resp.getWriter();
                    ((Writer)out).write("<html><head><title>WebMacro Error</title></head>");
                    ((Writer)out).write("<body><h1><font color=\"red\">WebMacro Error: ");
                    ((Writer)out).write("</font></h1><pre>");
                    ((Writer)out).write(this._problem);
                    ((Writer)out).write("</pre>");
                    ((Writer)out).write("Please contact the server administrator");
                    ((Writer)out).flush();
                    ((Writer)out).close();
                }
                catch (Exception e) {
                    this._log.error(this._problem, e);
                }
                return;
            }
        }
        context = this.newWebContext(req, resp);
        try {
            Template t = this.handle(context);
            if (t != null) {
                this.execute(t, context);
            }
            this.destroyContext(context);
        }
        catch (HandlerException e) {
            this._log.error("Your handler failed to handle the request:" + this, e);
            Template tmpl = this.error(context, "Your handler was unable to process the request successfully for some reason. Here are the details:<p><pre>" + e + "</pre>");
            this.execute(tmpl, context);
        }
        catch (Exception e) {
            this._log.error("Your handler failed to handle the request:" + this, e);
            Template tmpl = this.error(context, "The handler WebMacro used to handle this request failed for some reason. This is likely a bug in the handler written for this application. Here are the details:<p><pre>" + e + "</pre>");
            this.execute(tmpl, context);
        }
    }

    protected Template error(WebContext context, String error) {
        Template tmpl = null;
        try {
            context.put((Object)this.getErrorVariableName(), error);
            tmpl = this.getErrorTemplate();
        }
        catch (Exception e2) {
            this._log.error("Unable to use ErrorHandler", e2);
        }
        return tmpl;
    }

    protected String getErrorVariableName() {
        return this.getConfig(ERROR_VARIABLE, ERROR_VARIABLE_DEFAULT);
    }

    public Broker getBroker() {
        return this._broker;
    }

    public Log getLog(String type, String description) {
        return this._broker.getLog(type, description);
    }

    public Log getLog(String type) {
        return this._broker.getLog(type, type);
    }

    public Template getTemplate(String key) throws ResourceException {
        return this._wm.getTemplate(key);
    }

    public String getURL(String url) throws ResourceException {
        return this._wm.getURL(url);
    }

    public String getConfig(String key) throws NotFoundException {
        return this._wm.getConfig(key);
    }

    public String getConfig(String key, String defaultValue) {
        try {
            return this._wm.getConfig(key);
        }
        catch (NotFoundException e) {
            return defaultValue;
        }
    }

    public Context getContext() {
        return this._wm.getContext();
    }

    public WebContext getWebContext(HttpServletRequest req, HttpServletResponse res) {
        return this._wm.getWebContext(req, res);
    }

    public void writeTemplate(String templateName, OutputStream out, Context context) throws IOException, ResourceException, PropertyException {
        this.writeTemplate(templateName, out, this.getConfig("TemplateOutputEncoding"), context);
    }

    public void writeTemplate(String templateName, OutputStream out, String encoding, Context context) throws IOException, ResourceException, PropertyException {
        if (encoding == null) {
            encoding = this.getConfig("TemplateOutputEncoding");
        }
        Template tmpl = this.getTemplate(templateName);
        tmpl.write(out, encoding, context);
    }

    protected void execute(Template tmpl, WebContext c) throws IOException {
        try {
            String encoding;
            HttpServletResponse resp = c.getResponse();
            Locale locale = (Locale)tmpl.getParam("TemplateLocale");
            if (this._log.loggingDebug()) {
                this._log.debug("TemplateLocale=" + locale);
            }
            if (locale != null) {
                this.setLocale(resp, locale);
            }
            if ((encoding = (String)tmpl.getParam("TemplateOutputEncoding")) == null) {
                encoding = resp.getCharacterEncoding();
            }
            if (this._log.loggingDebug()) {
                this._log.debug("Using output encoding " + encoding);
            }
            byte[] bytes = tmpl.evaluateAsBytes(encoding, c);
            this.writeResponseBytes(resp, bytes, encoding);
        }
        catch (UnsupportedEncodingException e) {
            this._log.error("tried to use an unsupported encoding", e);
            throw e;
        }
        catch (IOException e) {
        }
        catch (Exception e) {
            String error = "WebMacro encountered an error while executing a template:\n" + (tmpl != null ? tmpl + ": " + e + "\n" : "The template failed to load; double check the TemplatePath in your webmacro.properties file.");
            this._log.error(error, e);
            try {
                Template errorTemplate = this.error(c, "WebMacro encountered an error while executing a template:\n" + (tmpl != null ? tmpl + ": " : "The template failed to load; double check the TemplatePath in your webmacro.properties file.") + "\n<pre>" + e + "</pre>\n");
                String err = errorTemplate.evaluateAsString(c);
                c.getResponse().getWriter().write(err);
            }
            catch (Exception errExcept) {
                this._log.error("Error writing error template!", errExcept);
            }
        }
    }

    private void writeResponseBytes(HttpServletResponse response, byte[] bytes, String encoding) throws IOException {
        ServletOutputStream out;
        try {
            out = response.getOutputStream();
        }
        catch (IllegalStateException e) {
            out = null;
            this._log.debug("Using Writer instead of OutputStream");
        }
        response.setContentLength(bytes.length);
        if (out != null) {
            out.write(bytes);
        } else {
            response.getWriter().write(new String(bytes, encoding));
        }
    }

    public WebContext newContext(HttpServletRequest req, HttpServletResponse resp) throws HandlerException {
        return this._wm.getWebContext(req, resp);
    }

    public abstract Template handle(WebContext var1) throws HandlerException;

    public void destroyContext(WebContext wc) throws HandlerException {
    }

    protected void start() throws ServletException {
    }

    protected void stop() {
    }

    public WebMacro initWebMacro() throws InitException {
        return new WM((Servlet)this);
    }

    public final WebContext initWebContext() throws InitException {
        return null;
    }

    public WebContext newWebContext(HttpServletRequest req, HttpServletResponse resp) {
        return new WebContext(this._broker, req, resp);
    }

    protected void setLocale(HttpServletResponse resp, Locale locale) {
        block3: {
            try {
                Method m = HttpServletResponse.class.getMethod("setLocale", Locale.class);
                m.invoke((Object)resp, (Object[])new Locale[]{locale});
                if (this._log.loggingDebug()) {
                    this._log.debug("Successfully set locale to " + locale);
                }
            }
            catch (Exception e) {
                if (!this._log.loggingDebug()) break block3;
                this._log.debug("Error set locale to " + locale + ": " + e.getClass());
            }
        }
    }

    public FastWriter getFastWriter(OutputStream out, String enctype) throws UnsupportedEncodingException {
        return this._wm.getFastWriter(out, enctype);
    }

    public Template getErrorTemplate() {
        String templateName = this.getErrorTemplateName();
        try {
            this._errorTemplate = (Template)this._broker.get("template", templateName);
        }
        catch (ResourceException e) {
            this._errorTemplate = new StringTemplate(this._broker, DEFAULT_ERROR_TEXT, "WebMacro default error template");
        }
        return this._errorTemplate;
    }

    protected String getErrorTemplateName() {
        String templateName;
        try {
            templateName = (String)this._broker.get("config", ERROR_TEMPLATE);
        }
        catch (ResourceException e) {
            templateName = ERROR_TEMPLATE_DEFAULT;
        }
        return templateName;
    }
}

