/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.servlet;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.webmacro.Broker;
import org.webmacro.Context;
import org.webmacro.Log;
import org.webmacro.servlet.CGI_Impersonator;
import org.webmacro.servlet.CookieJar;
import org.webmacro.servlet.Form;
import org.webmacro.util.Bag;

public class WebContext
extends Context {
    private final Log _log;
    private HttpServletRequest _request = null;
    private HttpServletResponse _response = null;

    public WebContext(Broker broker, HttpServletRequest req, HttpServletResponse resp) {
        super(broker);
        this._request = req;
        this._response = resp;
        this._log = broker.getLog("WebContext");
    }

    public void clear() {
        this._request = null;
        this._response = null;
        super.clear();
    }

    public final HttpServletRequest getRequest() {
        return this._request;
    }

    public final HttpServletResponse getResponse() {
        return this._response;
    }

    public final Object getPossibleForm(String strKey) {
        try {
            Form obForm = (Form)this.getProperty("Form");
            return obForm.getPossibleForm(strKey);
        }
        catch (Exception e) {
            this._log.error("Could not load Form tool", e);
            return null;
        }
    }

    public final String getForm(String field) {
        try {
            Bag ct = (Bag)this.getProperty("Form");
            return (String)ct.get(field);
        }
        catch (Exception e) {
            this._log.error("Could not load Form tool", e);
            return null;
        }
    }

    public final String[] getFormList(String field) {
        try {
            Bag ct = (Bag)this.getProperty("FormList");
            return (String[])ct.get(field);
        }
        catch (Exception e) {
            this._log.error("Could not load FormList tool", e);
            return null;
        }
    }

    public final CGI_Impersonator getCGI() {
        try {
            return (CGI_Impersonator)this.getProperty("CGI");
        }
        catch (Exception e) {
            this._log.error("Could not load CGI tool", e);
            return null;
        }
    }

    public final Cookie getCookie(String name) {
        try {
            CookieJar cj = (CookieJar)this.getProperty("Cookie");
            return (Cookie)cj.get(name);
        }
        catch (Exception e) {
            this._log.error("Could not load Cookie tool", e);
            return null;
        }
    }

    public final void setCookie(String name, String value) {
        try {
            CookieJar cj = (CookieJar)this.getProperty("Cookie");
            cj.set(name, value);
        }
        catch (Exception e) {
            this._log.error("Could not load Cookie tool", e);
        }
    }

    public final HttpSession getSession() {
        try {
            return (HttpSession)this.getProperty("Session");
        }
        catch (Exception e) {
            this._log.error("Could not load Session tool", e);
            return null;
        }
    }
}

