/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.util;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.webmacro.util.LogSystem;
import org.webmacro.util.LogTarget;
import org.webmacro.util.Settings;
import org.webmacro.util.SubSettings;

public abstract class AbstractLogFile
implements LogTarget {
    protected Map _levels = new HashMap();
    protected boolean _trace = false;
    protected int _defaultLevel = 2;
    protected String _defaultFormatString;
    protected String _formatString = this._defaultFormatString = "{0,time}\t{1}\t{2}\t{3}";
    protected MessageFormat _mf;
    protected List _observers = new LinkedList();
    protected String _name;

    public AbstractLogFile(Settings s) {
        this._trace = s.getBooleanSetting("LogTraceExceptions");
        String slevel = s.getSetting("LogLevel", "NOTICE");
        this._defaultLevel = LogSystem.getLevel(slevel);
        String format = s.getSetting("LogFormat");
        if (format != null) {
            this._formatString = format;
        }
        this._mf = new MessageFormat(this._formatString);
        SubSettings levels = new SubSettings(s, "LogLevel");
        String[] keys = ((Settings)levels).getKeys();
        for (int i = 0; i < keys.length; ++i) {
            this._levels.put(keys[i], new Integer(LogSystem.getLevel(((Settings)levels).getSetting(keys[i]))));
        }
    }

    public AbstractLogFile() {
        this._mf = new MessageFormat(this._formatString);
    }

    public String toString() {
        return "LogFile(name=" + this._name + ", level=" + this._defaultLevel + ", trace=" + this._trace + ")";
    }

    public void setLogLevel(int level) {
        this._defaultLevel = level;
        Iterator i = this._observers.iterator();
        while (i.hasNext()) {
            LogSystem ls = (LogSystem)i.next();
            ls.update(this, null);
        }
    }

    public void setLogLevel(String name, int level) {
        this._levels.put(name, new Integer(level));
        Iterator i = this._observers.iterator();
        while (i.hasNext()) {
            LogSystem ls = (LogSystem)i.next();
            ls.update(this, name);
        }
    }

    public void setTraceExceptions(boolean trace) {
        this._trace = trace;
    }

    public boolean subscribe(String category, String name, int level) {
        Integer ilevel = (Integer)this._levels.get(name);
        boolean sub = ilevel != null ? ilevel <= level : this._defaultLevel <= level;
        return sub;
    }

    public void addObserver(LogSystem ls) {
        this._observers.add(ls);
    }

    public void removeObserver(LogSystem ls) {
        this._observers.remove(ls);
    }
}

