/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.util;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public final class ByteBufferOutputStream
extends OutputStream {
    private byte[] _buf;
    private int _pos;

    public ByteBufferOutputStream(int size) {
        this._buf = new byte[size];
        this._pos = 0;
    }

    public void reset() {
        this._pos = 0;
    }

    public void write(int i) {
        this.write((byte)i);
    }

    public void write(byte[] b) {
        int len = b.length;
        this.ensureCapacity(len);
        System.arraycopy(b, 0, this._buf, this._pos, len);
        this._pos += len;
    }

    public void write(byte[] b, int offset, int len) {
        this.ensureCapacity(len);
        System.arraycopy(b, 0, this._buf, this._pos, len);
        this._pos += len;
    }

    public void write(byte b) {
        this.ensureCapacity(1);
        this._buf[this._pos] = b;
        ++this._pos;
    }

    public final void ensureCapacity(int len) {
        if (this._buf.length < this._pos + len) {
            int blen;
            for (blen = this._buf.length; blen < this._pos + len; blen *= 2) {
            }
            byte[] tmp = new byte[blen];
            System.arraycopy(this._buf, 0, tmp, 0, this._pos);
            this._buf = tmp;
        }
    }

    public int size() {
        return this._pos;
    }

    public byte[] getBuffer() {
        return this._buf;
    }

    public byte[] getBytes() {
        byte[] ret = new byte[this._pos];
        System.arraycopy(this._buf, 0, ret, 0, this._pos);
        return ret;
    }

    public String toString() {
        return new String(this._buf, 0, this._pos);
    }

    public String toString(String encoding) throws UnsupportedEncodingException {
        return new String(this._buf, 0, this._pos, encoding);
    }

    public void writeTo(OutputStream out) throws IOException {
        out.write(this._buf, 0, this._pos);
    }

    public static void main(String[] arg) {
        try {
            ByteBufferOutputStream bb = new ByteBufferOutputStream(5);
            bb.write((byte)84);
            bb.write((byte)104);
            bb.write((byte)105);
            bb.write((byte)115);
            bb.write((byte)32);
            bb.write((byte)105);
            bb.write((byte)115);
            bb.write((byte)32);
            bb.write((byte)97);
            bb.write((byte)32);
            bb.write((byte)116);
            bb.write((byte)101);
            bb.write((byte)115);
            bb.write((byte)116);
            bb.write((byte)10);
            bb.write("This is the second line of the byte buffer".getBytes());
            bb.write((byte)10);
            bb.write("This is the third line\n".getBytes());
            bb.write("This is the fourth line\n".getBytes());
            bb.write((byte)69);
            bb.write((byte)78);
            bb.write((byte)68);
            bb.write((byte)46);
            bb.write((byte)10);
            System.out.println("Byte buffer as a string: [" + bb + "]");
            System.out.print("Byte buffer written to a stream: [");
            bb.writeTo(System.out);
            System.out.print("]");
            System.out.println("DONE");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

