/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.util;

import java.io.UnsupportedEncodingException;
import org.webmacro.Broker;
import org.webmacro.InitException;
import org.webmacro.Log;
import org.webmacro.ResourceException;
import org.webmacro.resource.CacheElement;
import org.webmacro.resource.CacheManager;
import org.webmacro.resource.ResourceLoader;
import org.webmacro.resource.TrivialCacheManager;
import org.webmacro.util.Settings;

public class Encoder
implements ResourceLoader {
    private String _encoding;
    private CacheManager _cache;
    private Log _log;

    public Encoder(String encoding) throws UnsupportedEncodingException {
        if (encoding == null || encoding.equalsIgnoreCase("UNICODE") || encoding.equalsIgnoreCase("UNICODEBIG") || encoding.equalsIgnoreCase("UNICODELITTLE") || encoding.equalsIgnoreCase("UTF16")) {
            String err = "The encoding you specified is invalid: " + encoding + ". Note that the UNICODE and UTF16 encodings " + "are not supported by WebMacro because they prefix the " + "stream with a marker indicating whether the stream is " + "big endian or little endian. Instead choose the byte " + "ordering yourself by using the UTF-16BE or UTF-16LE " + "encodings.";
            throw new UnsupportedEncodingException(err);
        }
        "some test string".getBytes(encoding);
        this._encoding = encoding;
    }

    public void init(Broker b, Settings config) throws InitException {
        this._log = b.getLog("resource", "Object loading and caching");
        String cacheManager = b.getSetting("Encoder." + this._encoding + ".CacheManager");
        if (cacheManager == null) {
            cacheManager = b.getSetting("Encoder.*.CacheManager");
        }
        if (cacheManager == null || cacheManager.equals("")) {
            this._log.info("No cache manager specified for encoding " + this._encoding + ", using TrivialCacheManager");
            this._cache = new TrivialCacheManager();
        } else {
            try {
                Class c = b.classForName(cacheManager);
                this._cache = (CacheManager)c.newInstance();
            }
            catch (Exception e) {
                this._log.warning("Unable to load cache manager " + cacheManager + " for encoding type " + this._encoding + ", using TrivialCacheManager.  Reason:\n" + e);
                this._cache = new TrivialCacheManager();
            }
        }
        this._cache.init(b, config, this._encoding);
    }

    public Object load(Object query, CacheElement ce) throws ResourceException {
        try {
            if (query instanceof Block) {
                String[] source = ((Block)query).text;
                byte[][] encoded = new byte[source.length][];
                for (int i = 0; i < source.length; ++i) {
                    encoded[i] = source[i].getBytes(this._encoding);
                }
                return encoded;
            }
            if (query instanceof String) {
                return ((String)query).getBytes(this._encoding);
            }
            return query.toString().getBytes(this._encoding);
        }
        catch (UnsupportedEncodingException uee) {
            throw new ResourceException("Unable to encode: " + uee);
        }
    }

    public Object load(String query, CacheElement ce) throws ResourceException {
        try {
            return query.getBytes(this._encoding);
        }
        catch (UnsupportedEncodingException uee) {
            throw new ResourceException("Unable to encode: " + uee);
        }
    }

    public final byte[] encode(String source) throws UnsupportedEncodingException {
        try {
            return (byte[])this._cache.get(source, this);
        }
        catch (ResourceException e) {
            throw new UnsupportedEncodingException("Encoder: Could not encode; " + e);
        }
    }

    public final byte[][] encode(Block source) throws UnsupportedEncodingException {
        try {
            return (byte[][])this._cache.get(source, this);
        }
        catch (ResourceException e) {
            throw new UnsupportedEncodingException("Encoder: Could not encode; " + e);
        }
    }

    public static class Block {
        public String[] text;
        protected int _hashCode;

        public Block(String[] text) {
            this.text = text;
            long strhash = 0L;
            for (int i = 0; i < text.length; ++i) {
                strhash = (strhash + (long)text[i].hashCode()) % Integer.MAX_VALUE;
            }
            this._hashCode = (int)strhash;
        }

        public int hashCode() {
            return this._hashCode;
        }

        public boolean equals(Object other) {
            if (!(other instanceof Block)) {
                return false;
            }
            Block ob = (Block)other;
            if (this == ob || this.text == ob.text) {
                return true;
            }
            if (this.text == null || ob.text == null) {
                return false;
            }
            if (ob.text.length != this.text.length) {
                return false;
            }
            for (int i = 0; i < this.text.length; ++i) {
                if (this.text[i].equals(ob.text[i])) continue;
                return false;
            }
            return true;
        }
    }
}

