/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.util;

import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import org.webmacro.Broker;
import org.webmacro.InitException;
import org.webmacro.NotFoundException;
import org.webmacro.Provider;
import org.webmacro.ResourceException;
import org.webmacro.util.Encoder;
import org.webmacro.util.Settings;

public class EncoderProvider
implements Provider {
    private Map _encoders = new HashMap();
    private Broker _broker;
    private Settings _config;
    public static final String TYPE = "encoder";

    public String getType() {
        return TYPE;
    }

    public void init(Broker b, Settings config) throws InitException {
        this._broker = b;
        this._config = config;
    }

    public synchronized void flush() {
        this._encoders.clear();
    }

    public synchronized void destroy() {
        this._encoders = null;
    }

    public synchronized Object get(String encoding) throws ResourceException {
        Encoder encoder = null;
        if (this._encoders != null && (encoder = (Encoder)this._encoders.get(encoding)) == null) {
            try {
                encoder = new Encoder(encoding);
                encoder.init(this._broker, this._config);
                this._encoders.put(encoding, encoder);
            }
            catch (InitException e) {
                throw new ResourceException("Unable to initialize Encoder for " + encoding + "; " + e);
            }
            catch (UnsupportedEncodingException uee) {
                throw new NotFoundException("Unsupported encoding: " + uee.getMessage());
            }
        }
        return encoder;
    }
}

