/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.util;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import org.webmacro.util.ArrayBucket;
import org.webmacro.util.Bucket;

public final class EncodingCache {
    private final String _encoding;
    private final Bucket[] _cache;
    private final ArrayBucket[] _acache;
    private final int _size;
    private static final Map _ecCache = new HashMap();

    public EncodingCache(String encoding) throws UnsupportedEncodingException {
        this(encoding, 1001);
    }

    public EncodingCache(String encoding, int buckets) throws UnsupportedEncodingException {
        this._size = buckets;
        this._cache = new Bucket[this._size];
        this._acache = new ArrayBucket[this._size];
        for (int i = 0; i < this._size; ++i) {
            this._cache[i] = new Bucket();
            this._acache[i] = new ArrayBucket();
        }
        if (encoding == null || encoding.equalsIgnoreCase("UNICODE") || encoding.equalsIgnoreCase("UNICODEBIG") || encoding.equalsIgnoreCase("UNICODELITTLE") || encoding.equalsIgnoreCase("UTF16")) {
            throw new UnsupportedEncodingException("The encoding you specified is invalid: " + encoding + ". " + "Note that the UNICODE and UTF16 encodings are not " + "supported by WebMacro because " + "they prefix the stream with a marker indicating " + "whether the stream is big endian or little endian. " + "Instead choose the byte ordering yourself by using " + "the UTF-16BE or UTF-16LE encodings.");
        }
        this._encoding = encoding;
        "some test string".getBytes(encoding);
    }

    public String getEncodingName() {
        return this._encoding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] encode(String s) {
        Bucket b;
        if (s == null) {
            return null;
        }
        int hash = s.hashCode() % this._size;
        if (hash < 0) {
            hash = -hash;
        }
        Bucket bucket = b = this._cache[hash];
        synchronized (bucket) {
            if (b.string1 == s) {
                return b.bytes1;
            }
            if (b.string2 == s) {
                return b.bytes2;
            }
            if (b.string3 == s) {
                return b.bytes3;
            }
            if (b.string4 == s) {
                return b.bytes4;
            }
            if (b.string5 == s) {
                return b.bytes5;
            }
            try {
                byte[] buf = s.getBytes(this._encoding);
                b.string5 = b.string4;
                b.string4 = b.string3;
                b.string3 = b.string2;
                b.string2 = b.string1;
                b.string1 = s;
                b.bytes5 = b.bytes4;
                b.bytes4 = b.bytes3;
                b.bytes3 = b.bytes2;
                b.bytes2 = b.bytes1;
                b.bytes1 = buf;
                return buf;
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
                return null;
            }
        }
    }

    public byte[][] encode(String[] s) {
        return this.encode(s, System.identityHashCode(s));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[][] encode(String[] s, int hash) {
        ArrayBucket b;
        if (hash < 0) {
            hash = -hash;
        }
        ArrayBucket arrayBucket = b = this._acache[hash %= this._size];
        synchronized (arrayBucket) {
            if (b.string1 == s) {
                return b.bytes1;
            }
            if (b.string2 == s) {
                return b.bytes2;
            }
            if (b.string3 == s) {
                return b.bytes3;
            }
            if (b.string4 == s) {
                return b.bytes4;
            }
            if (b.string5 == s) {
                return b.bytes5;
            }
            if (s == null) {
                return null;
            }
            try {
                byte[][] buf = new byte[s.length][];
                for (int i = 0; i < buf.length; ++i) {
                    if (s[i] == null) continue;
                    buf[i] = s[i].getBytes(this._encoding);
                }
                b.string5 = b.string4;
                b.string4 = b.string3;
                b.string3 = b.string2;
                b.string2 = b.string1;
                b.string1 = s;
                b.bytes5 = b.bytes4;
                b.bytes4 = b.bytes3;
                b.bytes3 = b.bytes2;
                b.bytes2 = b.bytes1;
                b.bytes1 = buf;
                return buf;
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EncodingCache getInstance(String encoding) throws UnsupportedEncodingException {
        Map map = _ecCache;
        synchronized (map) {
            EncodingCache ec = (EncodingCache)_ecCache.get(encoding);
            if (ec == null) {
                ec = new EncodingCache(encoding);
                _ecCache.put(encoding, ec);
            }
            return ec;
        }
    }

    public static void main(String[] arg) {
        try {
            String s;
            EncodingCache ec = new EncodingCache("UTF-16LE", 11);
            BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
            while ((s = in.readLine()) != null) {
                String s1 = s.intern();
                byte[] b = ec.encode(s1);
                String s2 = new String(b, "UTF-16LE");
                System.out.print("Encoding string: " + s1 + " --> [");
                System.out.print(s2);
                System.out.println("]");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

