/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.webmacro.Log;
import org.webmacro.util.LogFile;
import org.webmacro.util.LogSource;
import org.webmacro.util.LogTarget;

public final class LogSystem {
    public static final int ALL = 0;
    public static final int DEBUG = 0;
    public static final int INFO = 1;
    public static final int NOTICE = 2;
    public static final int WARNING = 3;
    public static final int ERROR = 4;
    public static final int NONE = 5;
    protected static final String[] LEVELS = new String[]{"DEBUG", "INFO", "NOTICE", "WARNING", "ERROR"};
    private static final LogSystem _singleton;
    private static final Log _log;
    private static final LogFile _defaultTarget;
    private final String _category;
    private final Map _logs = new HashMap();
    private final Set _targets = new HashSet();

    public static int getLevel(String levelName) {
        for (int i = 0; i < LEVELS.length; ++i) {
            if (!LEVELS[i].equalsIgnoreCase(levelName)) continue;
            return i;
        }
        if ("NONE".equalsIgnoreCase(levelName)) {
            return 5;
        }
        if ("ALL".equalsIgnoreCase(levelName)) {
            return 0;
        }
        return 1;
    }

    public static LogSystem getInstance() {
        return _singleton;
    }

    public static Log getSystemLog(String type) {
        return _singleton.getLog(type, type);
    }

    public static Log getSystemLog(String type, String description) {
        return _singleton.getLog(type, description);
    }

    public LogSystem(String category) {
        this._category = category;
        this._targets.add(_defaultTarget);
    }

    public Log getLog(String type) {
        return this.getLog(type, type);
    }

    public synchronized Log getLog(String type, String description) {
        LogSource l = (LogSource)this._logs.get(type);
        if (l != null) {
            return l;
        }
        l = new LogSource(this._category, type, description);
        this._logs.put(type, l);
        Iterator i = this._targets.iterator();
        while (i.hasNext()) {
            LogTarget lt = (LogTarget)i.next();
            for (int level = 0; level < 5; ++level) {
                if (!lt.subscribe(this._category, type, level)) continue;
                l.addTarget(lt, level);
            }
        }
        if (_log != null) {
            _log.info("Started log " + l.getType() + ": " + l.getDescription());
        }
        return l;
    }

    public synchronized void addTarget(LogTarget t) {
        if (t == null) {
            return;
        }
        if (this._targets.contains(_defaultTarget)) {
            this.removeTarget(_defaultTarget);
        }
        Iterator i = this._logs.values().iterator();
        while (i.hasNext()) {
            LogSource l = (LogSource)i.next();
            for (int level = 0; level < 5; ++level) {
                if (!t.subscribe(this._category, l.getType(), level)) continue;
                l.addTarget(t, level);
            }
        }
        this._targets.add(t);
        t.addObserver(this);
    }

    public synchronized void removeTarget(LogTarget t) {
        if (t == null) {
            return;
        }
        Iterator i = this._logs.values().iterator();
        while (i.hasNext()) {
            LogSource l = (LogSource)i.next();
            for (int level = 0; level < 5; ++level) {
                if (!t.subscribe(this._category, l.getType(), level)) continue;
                l.removeTarget(t, level);
            }
        }
        this._targets.remove(t);
        if (t != _defaultTarget && this._targets.size() == 0) {
            this.addTarget(_defaultTarget);
        }
        t.removeObserver(this);
    }

    public synchronized void update(LogTarget target, String type) {
        if (target == null) {
            return;
        }
        if (type != null) {
            LogSource l = (LogSource)this._logs.get(type);
            if (l != null) {
                this.update(target, type, l);
            }
        } else {
            Iterator i = this._logs.values().iterator();
            while (i.hasNext()) {
                LogSource l = (LogSource)i.next();
                this.update(target, l.getType(), l);
            }
        }
    }

    private void update(LogTarget lt, String type, LogSource l) {
        for (int level = 0; level < 5; ++level) {
            if (lt.subscribe(this._category, type, level)) {
                l.addTarget(lt, level);
                continue;
            }
            l.removeTarget(lt, level);
        }
    }

    public synchronized void flush() {
        Iterator i = this._targets.iterator();
        while (i.hasNext()) {
            LogTarget t = (LogTarget)i.next();
            t.flush();
        }
    }

    public static void main(String[] arg) throws Exception {
        System.out.println("-------- starting main -----------");
        Log l = LogSystem.getInstance().getLog("test", "just a test");
        l.debug("1:testing debug");
        l.info("1:testing info");
        l.notice("1:testing notice");
        l.warning("1:testing warning");
        l.error("1:testing error");
        LogFile lf = new LogFile("test.log");
        System.out.println("Adding new log target: " + lf);
        LogSystem.getInstance().addTarget(lf);
        l.debug("2:testing debug");
        l.info("2:testing info");
        l.notice("2:testing notice");
        l.warning("2:testing warning");
        l.error("2:testing error");
        LogSystem.getInstance().flush();
    }

    static {
        _defaultTarget = new LogFile(System.err);
        _defaultTarget.setLogLevel(2);
        _defaultTarget.setTraceExceptions(true);
        _singleton = new LogSystem("system");
        _log = _singleton.getLog("log", "information about the logging system");
    }
}

