/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.util;

import java.lang.reflect.Constructor;
import org.webmacro.Broker;
import org.webmacro.WebMacroException;
import org.webmacro.util.LogTarget;
import org.webmacro.util.Settings;

public final class LogTargetFactory {
    private static LogTargetFactory _instance = new LogTargetFactory();

    private LogTargetFactory() {
    }

    public static final LogTargetFactory getInstance() {
        return _instance;
    }

    public final LogTarget createLogTarget(Broker broker, String classname, Settings settings) throws LogCreationException {
        LogTarget lt = null;
        try {
            Class targetClass = broker.classForName(classname);
            Class[] args = new Class[]{Settings.class};
            try {
                Constructor constr = targetClass.getConstructor(args);
                lt = (LogTarget)constr.newInstance(settings);
            }
            catch (NoSuchMethodException nsme) {
                lt = (LogTarget)targetClass.newInstance();
            }
        }
        catch (Exception e) {
            throw new LogCreationException("Cannot create LogTarget " + classname, e);
        }
        return lt;
    }

    public static class LogCreationException
    extends WebMacroException {
        private static final long serialVersionUID = 1L;

        public LogCreationException(String message, Throwable throwable) {
            super(message, throwable);
        }
    }
}

