/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.util;

import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class PrimitiveArrayIterator
implements Iterator {
    private final Object a;
    private int _size;
    private int pos;

    public PrimitiveArrayIterator(Object array) {
        if (!array.getClass().isArray()) {
            throw new IllegalArgumentException(array.getClass().getName() + " is not an array.");
        }
        this.a = array;
        this._size = Array.getLength(this.a);
        this.pos = 0;
    }

    public final boolean hasNext() {
        return this.pos < this._size;
    }

    public final Object next() {
        if (this.pos < this._size) {
            return Array.get(this.a, this.pos++);
        }
        throw new NoSuchElementException("Advanced beyond end of array");
    }

    public final void remove() {
        throw new UnsupportedOperationException();
    }

    public static void main(String[] arg) {
        try {
            PrimitiveArrayIterator i = new PrimitiveArrayIterator(arg);
            while (i.hasNext()) {
                System.out.println("item: " + i.next());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

