/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.util;

import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.webmacro.Context;
import org.webmacro.Log;
import org.webmacro.Template;
import org.webmacro.WM;
import org.webmacro.WebMacro;
import org.webmacro.engine.StreamTemplate;
import org.webmacro.servlet.WebContext;
import org.webmacro.util.Settings;

public class WMEval {
    private WebMacro wm;
    private Log log;
    private Template currentTemplate;
    private Context context;
    public static final String outputContextKey = "OutputFileName";

    public WMEval() {
        try {
            this.wm = new WM();
            this.init();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public WMEval(String templateName) {
        try {
            this.wm = new WM();
            this.init();
            this.parseLocalTemplate(templateName);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public WMEval(Servlet servlet) {
        try {
            this.wm = servlet == null ? new WM() : new WM(servlet);
            this.init();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private void init() {
        this.context = this.wm.getContext();
        this.log = this.wm.getBroker().getBrokerLog();
    }

    public Settings getSettings() {
        return this.wm.getBroker().getSettings();
    }

    public Log getLog() {
        return this.log;
    }

    public Template init(InputStream template) throws Exception {
        StreamTemplate t = new StreamTemplate(this.wm.getBroker(), template);
        t.parse();
        this.currentTemplate = t;
        return t;
    }

    public void error(String msg, Exception e) {
        this.wm.getLog("ERROR").error(msg, e);
    }

    public Context getNewContext() {
        Context c;
        this.context = c = this.wm.getContext();
        return c;
    }

    public WebContext getNewContext(HttpServletRequest req, HttpServletResponse resp) {
        WebContext c = this.wm.getWebContext(req, resp);
        this.context = c;
        return c;
    }

    public Context getCurrentContext() {
        return this.context;
    }

    public Template getCurrentTemplate() {
        return this.currentTemplate;
    }

    public Template parseLocalTemplate(String templateName) throws Exception {
        Template t;
        this.currentTemplate = t = this.wm.getTemplate(templateName);
        return t;
    }

    public void setCurrentTemplate(Template parsedTemplate) {
        this.currentTemplate = parsedTemplate;
    }

    public void setCurrentContext(Context c) {
        this.context = c;
    }

    public String eval() throws Exception {
        return this.eval(this.context, this.currentTemplate);
    }

    public String eval(Context context) throws Exception {
        return this.eval(context, this.currentTemplate);
    }

    public String eval(Context context, Template template) throws Exception {
        return template.evaluateAsString(context);
    }

    public String eval(String templateName) throws Exception {
        return this.eval(this.context, templateName, null, null);
    }

    public String eval(Context context, String templateName, OutputStream out) throws Exception {
        return this.eval(context, templateName, out, null);
    }

    public String eval(Context context, String templateName, OutputStream out, String encoding) throws Exception {
        String outputFileName;
        Template t = this.wm.getTemplate(templateName);
        String value = t.evaluateAsString(context);
        if (out == null && (outputFileName = (String)context.get(outputContextKey)) != null) {
            out = new FileOutputStream(outputFileName);
        }
        if (out != null) {
            if (encoding == null) {
                out.write(value.getBytes());
            } else {
                out.write(value.getBytes(encoding));
            }
            out.close();
        }
        this.currentTemplate = t;
        this.context = context;
        return value;
    }

    public String eval(WebContext context, String templateName, HttpServletResponse resp) throws ServletException {
        String value = null;
        try {
            resp.setContentType("text/html");
            String encoding = this.wm.getConfig("TemplateOutputEncoding");
            value = this.eval(context, templateName, (OutputStream)resp.getOutputStream(), encoding);
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
        return value;
    }

    public String eval(Context context, String templateName, String outputFileName, boolean append, String encoding) throws Exception {
        FileOutputStream out = new FileOutputStream(outputFileName, append);
        return this.eval(context, templateName, out, encoding);
    }

    public void destroy() {
        this.wm = null;
        this.currentTemplate = null;
        this.context = null;
    }
}

