/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database.global;

import com.mckoi.database.global.ByteLongObject;
import com.mckoi.database.global.NullObject;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;

public class ObjectTransfer {
    public static int size(Object object) throws IOException {
        if (object == null || object instanceof NullObject) {
            return 9;
        }
        if (object instanceof String) {
            return object.toString().length() * 2 + 9;
        }
        if (object instanceof BigDecimal) {
            return 24;
        }
        if (object instanceof Date) {
            return 17;
        }
        if (object instanceof Boolean) {
            return 11;
        }
        if (object instanceof ByteLongObject) {
            return ((ByteLongObject)object).length() + 9;
        }
        throw new IOException("Unrecognised type.");
    }

    public static void writeTo(DataOutputStream dataOutputStream, Object object) throws IOException {
        if (object == null || object instanceof NullObject) {
            dataOutputStream.writeByte(1);
        } else if (object instanceof String) {
            String string = (String)object;
            dataOutputStream.writeByte(18);
            dataOutputStream.writeInt(string.length());
            dataOutputStream.writeChars(string);
        } else if (object instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)object;
            dataOutputStream.writeByte(6);
            dataOutputStream.writeInt(bigDecimal.scale());
            BigInteger bigInteger = bigDecimal.movePointRight(bigDecimal.scale()).toBigInteger();
            byte[] byArray = bigInteger.toByteArray();
            dataOutputStream.writeInt(byArray.length);
            dataOutputStream.write(byArray);
        } else if (object instanceof Date) {
            Date date = (Date)object;
            dataOutputStream.writeByte(9);
            dataOutputStream.writeLong(date.getTime());
        } else if (object instanceof Boolean) {
            Boolean bl = (Boolean)object;
            dataOutputStream.writeByte(12);
            dataOutputStream.writeBoolean(bl);
        } else if (object instanceof ByteLongObject) {
            ByteLongObject byteLongObject = (ByteLongObject)object;
            dataOutputStream.writeByte(15);
            byte[] byArray = byteLongObject.getByteArray();
            dataOutputStream.writeLong(byArray.length);
            dataOutputStream.write(byArray);
        } else {
            throw new IOException("Unrecognised type.");
        }
    }

    public static Object readFrom(DataInputStream dataInputStream) throws IOException {
        byte by = dataInputStream.readByte();
        if (by == 1) {
            return NullObject.NULL_OBJ;
        }
        if (by == 3) {
            return dataInputStream.readUTF();
        }
        if (by == 6) {
            int n = dataInputStream.readInt();
            int n2 = dataInputStream.readInt();
            byte[] byArray = new byte[n2];
            dataInputStream.readFully(byArray);
            BigInteger bigInteger = new BigInteger(byArray);
            return new BigDecimal(bigInteger, n);
        }
        if (by == 9) {
            long l = dataInputStream.readLong();
            return new Date(l);
        }
        if (by == 12) {
            return new Boolean(dataInputStream.readBoolean());
        }
        if (by == 15) {
            long l = dataInputStream.readLong();
            byte[] byArray = new byte[(int)l];
            dataInputStream.read(byArray, 0, (int)l);
            return new ByteLongObject(byArray);
        }
        if (by == 18) {
            int n = dataInputStream.readInt();
            StringBuffer stringBuffer = new StringBuffer();
            while (n > 0) {
                stringBuffer.append(dataInputStream.readChar());
                --n;
            }
            return new String(stringBuffer);
        }
        throw new IOException("Unrecognised type.");
    }
}

