/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database.jdbc;

import com.mckoi.database.control.DefaultDBConfig;
import com.mckoi.database.jdbc.DatabaseInterface;
import com.mckoi.database.jdbc.LocalBootable;
import com.mckoi.database.jdbc.MConnection;
import com.mckoi.database.jdbc.TCPStreamDatabaseInterface;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;

public class MDriver
implements Driver {
    static final int DRIVER_MAJOR_VERSION = 0;
    static final int DRIVER_MINOR_VERSION = 70;
    static final String DRIVER_NAME = "Mckoi JDBC Driver";
    static final String DRIVER_VERSION = "0.70-beta";
    private static final String mckoi_protocol_url = "jdbc:mckoi:";
    private static boolean registered = false;
    static int QUERY_TIMEOUT = 60;
    private LocalBootable local_bootable;

    public static synchronized void register() {
        if (!registered) {
            try {
                DriverManager.registerDriver(new MDriver());
                registered = true;
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
        }
    }

    private static void parseEncodedVariables(String string, Properties properties) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "&");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim().toLowerCase();
            int n = string2.indexOf("=");
            if (n > 0) {
                String string3 = string2.substring(0, n);
                String string4 = string2.substring(n + 1);
                ((Hashtable)properties).put(string3, string4);
                continue;
            }
            System.err.println("Ignoring url variable: '" + string2 + "'");
        }
    }

    private synchronized Object[] connectToLocal(String string, String string2, Properties properties) throws SQLException {
        Object object;
        DatabaseInterface databaseInterface;
        int n;
        int n2;
        String string3 = "APP";
        if (this.local_bootable == null) {
            try {
                Class<?> clazz = Class.forName("com.mckoi.database.jdbcserver.DefaultLocalBootable");
                this.local_bootable = (LocalBootable)clazz.newInstance();
            }
            catch (Throwable throwable) {
                throw new SQLException("Unable to create interface to local database.");
            }
        }
        if ((n2 = string2.indexOf("?")) == -1) {
            n2 = string2.length();
        }
        String string4 = string2.substring(8, n2);
        File file = new File(string4 = string4.replace('\\', '/'));
        if (!file.exists() && (n = string4.lastIndexOf(47)) > 0) {
            string3 = string4.substring(n + 1);
            string4 = string4.substring(0, n);
        }
        String string5 = "";
        if (n2 < string2.length()) {
            string5 = string2.substring(n2 + 1).trim();
        }
        if (this.local_bootable.isBooted()) {
            databaseInterface = this.local_bootable.connectToJVM();
        } else {
            if (string4 == null) {
                string4 = "./db.conf";
            }
            object = new File(new File(string4).getAbsolutePath());
            File file2 = new File(((File)object).getParent());
            DefaultDBConfig defaultDBConfig = new DefaultDBConfig(file2);
            try {
                defaultDBConfig.loadFromFile(new File(string4));
            }
            catch (IOException iOException) {
                throw new SQLException("Unable to find configuration file: " + string4);
            }
            MDriver.parseEncodedVariables(string5, properties);
            boolean bl = false;
            boolean bl2 = false;
            bl = properties.getProperty("create", "").equals("true");
            bl2 = properties.getProperty("boot_or_create", "").equals("true");
            Enumeration enumeration = ((Hashtable)properties).keys();
            while (enumeration.hasMoreElements()) {
                String string6 = enumeration.nextElement().toString();
                if (string6.equals("user") || string6.equals("password")) continue;
                defaultDBConfig.setValue(string6, (String)((Hashtable)properties).get(string6));
            }
            boolean bl3 = this.local_bootable.checkExists(defaultDBConfig);
            if (bl2 && !bl3) {
                bl = true;
            }
            if (bl && bl3) {
                throw new SQLException("Can not create database because a database already exists.");
            }
            if (!bl && !bl3) {
                throw new SQLException("Can not find a database to start.  Either the database needs to be created or the 'database_path' property of the configuration must be set to located of the data files.");
            }
            if (bl) {
                String string7 = properties.getProperty("user", "");
                String string8 = properties.getProperty("password", "");
                databaseInterface = this.local_bootable.create(string7, string8, defaultDBConfig);
            } else {
                databaseInterface = this.local_bootable.boot(defaultDBConfig);
            }
        }
        object = new Object[]{databaseInterface, string3};
        return object;
    }

    public Connection connect(String string, Properties properties) throws SQLException {
        int n;
        int n2;
        Object object;
        Object object2;
        if (!this.acceptsURL(string)) {
            return null;
        }
        String string2 = "APP";
        String string3 = string.substring(string.indexOf(mckoi_protocol_url) + mckoi_protocol_url.length());
        if (string3.startsWith("local://")) {
            object2 = this.connectToLocal(string, string3, properties);
            object = (DatabaseInterface)object2[0];
            string2 = (String)object2[1];
            n2 = 43;
            n = 4092000;
        } else {
            Object object3;
            int n3 = 9157;
            String string4 = "127.0.0.1";
            if (string3.startsWith("//")) {
                String string5;
                int n4;
                int n5;
                object3 = "";
                int n6 = string3.indexOf(63, 2);
                if (n6 != -1) {
                    object3 = string3.substring(n6 + 1);
                    string3 = string3.substring(0, n6);
                }
                if ((n5 = string3.indexOf("/", 2)) == -1) {
                    n5 = string3.length();
                }
                if ((n4 = (string5 = string3.substring(2, n5)).indexOf(58)) == -1) {
                    n4 = string5.length();
                }
                string4 = string5.substring(0, n4);
                if (n4 < string5.length() - 1) {
                    n3 = Integer.parseInt(string5.substring(n4 + 1));
                }
                String string6 = "";
                if (n5 < string3.length()) {
                    string6 = string3.substring(n5 + 1);
                }
                String string7 = string6;
                int n7 = string6.indexOf(47);
                if (n7 != -1) {
                    string7 = string6.substring(0, n7);
                } else {
                    n7 = string6.indexOf(63);
                    if (n7 != -1) {
                        string7 = string6.substring(0, n7);
                    }
                }
                if (!((String)object3).equals("")) {
                    MDriver.parseEncodedVariables((String)object3, properties);
                }
                if (string7.length() > 0) {
                    string2 = string7;
                }
            } else if (string3.trim().length() > 0) {
                throw new SQLException("Malformed URL: " + string3);
            }
            try {
                Thread.sleep(85L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            object3 = new TCPStreamDatabaseInterface(string4, n3);
            ((TCPStreamDatabaseInterface)object3).connectToDatabase();
            object = object3;
            n2 = 4111;
            n = 0x7D0000;
        }
        object2 = new MConnection(string, (DatabaseInterface)object, n2, n);
        ((MConnection)object2).login(properties, string2);
        return object2;
    }

    public boolean acceptsURL(String string) throws SQLException {
        return string.startsWith(mckoi_protocol_url) || string.startsWith(":jdbc:mckoi:");
    }

    public DriverPropertyInfo[] getPropertyInfo(String string, Properties properties) throws SQLException {
        return new DriverPropertyInfo[0];
    }

    public int getMajorVersion() {
        return 0;
    }

    public int getMinorVersion() {
        return 70;
    }

    public boolean jdbcCompliant() {
        return false;
    }
}

