/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database.jdbc;

import com.mckoi.database.global.ByteLongObject;
import com.mckoi.database.global.ColumnDescription;
import com.mckoi.database.global.NullObject;
import com.mckoi.database.global.ObjectTranslator;
import com.mckoi.database.jdbc.AsciiInputStream;
import com.mckoi.database.jdbc.MBlob;
import com.mckoi.database.jdbc.MConnection;
import com.mckoi.database.jdbc.MResultSetMetaData;
import com.mckoi.database.jdbc.MStatement;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;

public final class MResultSet
implements ResultSet {
    private static final int DEFAULT_FETCH_SIZE = 32;
    private static final int MAXIMUM_FETCH_SIZE = 512;
    private static int unique_id_key = 1;
    private static BigDecimal BD_ZERO = new BigDecimal(0.0);
    private int unique_id;
    private MConnection connection;
    private MStatement statement;
    private SQLWarning head_warning;
    private int result_id;
    private ColumnDescription[] col_list;
    private int query_time_ms;
    private int result_row_count;
    private int max_row_count = Integer.MAX_VALUE;
    private int block_top_row;
    private int block_row_count;
    private int fetch_size;
    private Vector result_block;
    private int real_index = Integer.MAX_VALUE;
    private int real_index_offset = -1;
    private boolean last_was_null = false;
    private Hashtable column_hash;
    private boolean closed_on_server;

    MResultSet(MConnection mConnection, MStatement mStatement) {
        this.connection = mConnection;
        this.statement = mStatement;
        this.unique_id = unique_id_key++;
        this.result_id = -1;
        this.result_block = new Vector();
    }

    void addSQLWarning(SQLWarning sQLWarning) {
        if (this.head_warning == null) {
            this.head_warning = sQLWarning;
        } else {
            this.head_warning.setNextWarning(sQLWarning);
        }
    }

    boolean verboseColumnNames() {
        return this.connection.verboseColumnNames();
    }

    void connSetup(int n, ColumnDescription[] columnDescriptionArray, int n2) {
        this.result_id = n;
        this.col_list = columnDescriptionArray;
        this.result_row_count = n2;
        this.block_top_row = -1;
        this.result_block.removeAllElements();
        this.real_index = -1;
        this.fetch_size = 32;
        this.closed_on_server = false;
    }

    void setQueryTime(int n) {
        this.query_time_ms = n;
    }

    void setMaxRowCount(int n) {
        this.max_row_count = n == 0 ? Integer.MAX_VALUE : n;
    }

    void storeResultLocally() throws SQLException {
        if (this.rowCount() > 0) {
            this.updateResultPart(0, this.rowCount());
        }
        this.connection.disposeResult(this.result_id);
        this.closed_on_server = true;
    }

    void updateResultPart(int n, int n2) throws SQLException {
        if (n + n2 < 0) {
            throw new SQLException("ResultSet row index is before the start of the set.");
        }
        if (n < 0) {
            n = 0;
            n2 += n;
        }
        if (n >= this.rowCount()) {
            throw new SQLException("ResultSet row index is after the end of the set.");
        }
        if (n + n2 > this.rowCount()) {
            n2 = this.rowCount() - n;
        }
        if (this.result_id == -1) {
            throw new SQLException("result_id == -1.  No result to get from.");
        }
        try {
            this.result_block = this.connection.getRowCache().getResultPart(this.result_block, this.connection, this.result_id, n, n2, this.columnCount(), this.rowCount());
            this.block_top_row = n;
            this.block_row_count = n2;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new SQLException("IO Error: " + iOException.getMessage());
        }
    }

    void closeCurrentResult() throws SQLException {
        if (this.getResultID() != -1) {
            if (!this.closed_on_server) {
                this.connection.disposeResult(this.result_id);
                this.closed_on_server = true;
            }
            this.result_id = -1;
            this.real_index = Integer.MAX_VALUE;
            if (this.column_hash != null) {
                this.column_hash.clear();
            }
        }
    }

    int getResultID() {
        return this.result_id;
    }

    int rowCount() {
        return Math.min(this.result_row_count, this.max_row_count);
    }

    int columnCount() {
        return this.col_list.length;
    }

    ColumnDescription getColumn(int n) {
        return this.col_list[n];
    }

    boolean isUpdate() {
        return this.columnCount() == 1 && this.rowCount() == 1 && this.getColumn(0).getName().equals("@aresult");
    }

    int intValue() throws SQLException {
        if (this.isUpdate()) {
            BigDecimal bigDecimal = (BigDecimal)this.result_block.elementAt(0);
            return bigDecimal.intValue();
        }
        throw new SQLException("Looking for a DML result in a DQL instruction.");
    }

    void dispose() {
        try {
            this.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.connection = null;
        this.statement = null;
        this.col_list = null;
        this.result_block = null;
    }

    void ensureIndexLoaded() throws SQLException {
        if (this.real_index == -1) {
            throw new SQLException("Row index out of bounds.");
        }
        int n = this.real_index - this.block_top_row;
        if (n >= this.block_row_count) {
            this.updateResultPart(this.real_index, this.fetch_size);
            n = this.real_index - this.block_top_row;
            this.real_index_offset = n * this.columnCount();
        } else if (n < 0) {
            int n2 = Math.min(this.fetch_size, 8);
            this.updateResultPart(this.real_index - this.fetch_size + n2, this.fetch_size);
            n = this.real_index - this.block_top_row;
            this.real_index_offset = n * this.columnCount();
        }
    }

    int findColumnIndex(String string) throws SQLException {
        Integer n;
        boolean bl;
        if (this.column_hash == null) {
            this.column_hash = new Hashtable();
        }
        if (bl = this.connection.isCaseInsensitiveIdentifiers()) {
            string = string.toUpperCase();
        }
        if ((n = (Integer)this.column_hash.get(string)) == null) {
            String string2;
            int n2 = this.columnCount();
            String[] stringArray = new String[n2];
            int n3 = 0;
            while (n3 < n2) {
                String string3 = this.col_list[n3].getName();
                if (string3.startsWith("\"")) {
                    string3 = string3.substring(1, string3.length() - 1);
                }
                if (string3.startsWith("@")) {
                    string3 = string3.substring(2);
                }
                if (bl) {
                    string3 = string3.toUpperCase();
                }
                stringArray[n3] = string3;
                ++n3;
            }
            int n4 = 0;
            while (n4 < n2) {
                string2 = stringArray[n4];
                if (string2.equals(string)) {
                    this.column_hash.put(string, new Integer(n4 + 1));
                    return n4 + 1;
                }
                ++n4;
            }
            string2 = "." + string;
            int n5 = 0;
            while (n5 < n2) {
                String string4 = stringArray[n5];
                if (string4.endsWith(string2)) {
                    this.column_hash.put(string, new Integer(n5 + 1));
                    return n5 + 1;
                }
                ++n5;
            }
            throw new SQLException("Couldn't find column with name: " + string);
        }
        return n;
    }

    Object getRawColumn(int n) throws SQLException {
        if (n < 1 || n > this.columnCount()) {
            throw new SQLException("Column index out of bounds: 1 > " + n + " > " + this.columnCount());
        }
        this.ensureIndexLoaded();
        Object object = this.result_block.elementAt(this.real_index_offset + (n - 1));
        if (object != null && !(object instanceof NullObject)) {
            this.last_was_null = false;
            if (this.getColumn(n - 1).getSQLType() == 2000) {
                object = ObjectTranslator.deserialize((ByteLongObject)object);
            }
            return object;
        }
        this.last_was_null = true;
        return null;
    }

    Object getRawColumn(String string) throws SQLException {
        return this.getRawColumn(this.findColumnIndex(string));
    }

    private void realIndexUpdate() throws SQLException {
        int n = this.real_index - this.block_top_row;
        this.real_index_offset = n * this.columnCount();
        this.clearWarnings();
    }

    private Object jdbcObjectCast(Object object, int n) {
        switch (n) {
            case -7: {
                return object;
            }
            case -6: {
                return new Integer(((BigDecimal)object).intValue());
            }
            case 5: {
                return new Integer(((BigDecimal)object).intValue());
            }
            case 4: {
                return new Integer(((BigDecimal)object).intValue());
            }
            case -5: {
                return new Long(((BigDecimal)object).longValue());
            }
            case 6: {
                return new Double(((BigDecimal)object).doubleValue());
            }
            case 7: {
                return new Float(((BigDecimal)object).floatValue());
            }
            case 8: {
                return new Double(((BigDecimal)object).doubleValue());
            }
            case 2: {
                return (BigDecimal)object;
            }
            case 3: {
                return (BigDecimal)object;
            }
            case 1: {
                return (String)object;
            }
            case 12: {
                return (String)object;
            }
            case -1: {
                return (String)object;
            }
            case 91: {
                return new Date(((java.util.Date)object).getTime());
            }
            case 92: {
                return new Time(((java.util.Date)object).getTime());
            }
            case 93: {
                return new Timestamp(((java.util.Date)object).getTime());
            }
            case -2: {
                return ((ByteLongObject)object).getByteArray();
            }
            case -3: {
                return ((ByteLongObject)object).getByteArray();
            }
            case -4: {
                return ((ByteLongObject)object).getByteArray();
            }
            case 0: {
                return object;
            }
            case 1111: {
                return object;
            }
            case 2000: {
                return object;
            }
            case 2001: {
                return object;
            }
            case 2002: {
                return object;
            }
            case 2003: {
                return object;
            }
            case 2004: {
                return new MBlob((ByteLongObject)object);
            }
            case 2005: {
                return object;
            }
            case 2006: {
                return object;
            }
        }
        return object;
    }

    public int extQueryTimeMillis() {
        return this.query_time_ms;
    }

    public java.util.Date extGetDate(int n) throws SQLException {
        return (java.util.Date)this.getRawColumn(n);
    }

    public java.util.Date extGetDate(String string) throws SQLException {
        return this.extGetDate(this.findColumnIndex(string));
    }

    public boolean next() throws SQLException {
        int n = this.rowCount();
        if (this.real_index < n) {
            ++this.real_index;
            if (this.real_index < n) {
                this.realIndexUpdate();
            }
        }
        return this.real_index < n;
    }

    public void close() throws SQLException {
        this.closeCurrentResult();
    }

    public boolean wasNull() throws SQLException {
        return this.last_was_null;
    }

    public String getString(int n) throws SQLException {
        Object object = this.getRawColumn(n);
        if (object == null) {
            return null;
        }
        if (object instanceof java.util.Date) {
            int n2 = this.getColumn(n - 1).getSQLType();
            return this.jdbcObjectCast(object, n2).toString();
        }
        return object.toString();
    }

    public boolean getBoolean(int n) throws SQLException {
        Object object = this.getRawColumn(n);
        if (object == null) {
            return false;
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof BigDecimal) {
            return !object.equals(BD_ZERO);
        }
        if (object instanceof String) {
            return ((String)object).equalsIgnoreCase("true");
        }
        throw new SQLException("Unable to cast value in ResultSet to boolean");
    }

    public byte getByte(int n) throws SQLException {
        BigDecimal bigDecimal = this.getBigDecimal(n);
        return bigDecimal == null ? (byte)0 : bigDecimal.byteValue();
    }

    public short getShort(int n) throws SQLException {
        BigDecimal bigDecimal = this.getBigDecimal(n);
        return bigDecimal == null ? (short)0 : bigDecimal.shortValue();
    }

    public int getInt(int n) throws SQLException {
        BigDecimal bigDecimal = this.getBigDecimal(n);
        return bigDecimal == null ? 0 : bigDecimal.intValue();
    }

    public long getLong(int n) throws SQLException {
        BigDecimal bigDecimal = this.getBigDecimal(n);
        return bigDecimal == null ? 0L : bigDecimal.longValue();
    }

    public float getFloat(int n) throws SQLException {
        BigDecimal bigDecimal = this.getBigDecimal(n);
        return bigDecimal == null ? 0.0f : bigDecimal.floatValue();
    }

    public double getDouble(int n) throws SQLException {
        BigDecimal bigDecimal = this.getBigDecimal(n);
        return bigDecimal == null ? 0.0 : bigDecimal.doubleValue();
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        throw new SQLException("Deprecated method not supported");
    }

    public byte[] getBytes(int n) throws SQLException {
        Object object = this.getRawColumn(n);
        if (object == null) {
            return null;
        }
        if (object instanceof ByteLongObject) {
            ByteLongObject byteLongObject = (ByteLongObject)object;
            byte[] byArray = new byte[byteLongObject.length()];
            System.arraycopy(byteLongObject.getByteArray(), 0, byArray, 0, byteLongObject.length());
            return byArray;
        }
        throw new SQLException("Unable to cast value in ResultSet to byte[]");
    }

    public Date getDate(int n) throws SQLException {
        java.util.Date date = this.extGetDate(n);
        if (date != null) {
            return new Date(date.getTime());
        }
        return null;
    }

    public Time getTime(int n) throws SQLException {
        java.util.Date date = this.extGetDate(n);
        if (date != null) {
            return new Time(date.getTime());
        }
        return null;
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        java.util.Date date = this.extGetDate(n);
        if (date != null) {
            return new Timestamp(date.getTime());
        }
        return null;
    }

    public InputStream getAsciiStream(int n) throws SQLException {
        String string = this.getString(n);
        if (string != null) {
            return new AsciiInputStream(string);
        }
        return null;
    }

    public InputStream getUnicodeStream(int n) throws SQLException {
        throw new SQLException("Deprecated method not supported");
    }

    public InputStream getBinaryStream(int n) throws SQLException {
        Object object = this.getRawColumn(n);
        if (object == null) {
            return null;
        }
        if (object instanceof ByteLongObject) {
            ByteLongObject byteLongObject = (ByteLongObject)object;
            return new ByteArrayInputStream(byteLongObject.getByteArray());
        }
        throw new SQLException("Unable to cast value in ResultSet to binary stream");
    }

    public String getString(String string) throws SQLException {
        return this.getString(this.findColumnIndex(string));
    }

    public boolean getBoolean(String string) throws SQLException {
        return this.getBoolean(this.findColumnIndex(string));
    }

    public byte getByte(String string) throws SQLException {
        return this.getByte(this.findColumnIndex(string));
    }

    public short getShort(String string) throws SQLException {
        return this.getShort(this.findColumnIndex(string));
    }

    public int getInt(String string) throws SQLException {
        return this.getInt(this.findColumnIndex(string));
    }

    public long getLong(String string) throws SQLException {
        return this.getLong(this.findColumnIndex(string));
    }

    public float getFloat(String string) throws SQLException {
        return this.getFloat(this.findColumnIndex(string));
    }

    public double getDouble(String string) throws SQLException {
        return this.getDouble(this.findColumnIndex(string));
    }

    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        return this.getBigDecimal(this.findColumnIndex(string));
    }

    public byte[] getBytes(String string) throws SQLException {
        return this.getBytes(this.findColumnIndex(string));
    }

    public Date getDate(String string) throws SQLException {
        return this.getDate(this.findColumnIndex(string));
    }

    public Time getTime(String string) throws SQLException {
        return this.getTime(this.findColumnIndex(string));
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        return this.getTimestamp(this.findColumnIndex(string));
    }

    public InputStream getAsciiStream(String string) throws SQLException {
        return this.getAsciiStream(this.findColumnIndex(string));
    }

    public InputStream getUnicodeStream(String string) throws SQLException {
        return this.getUnicodeStream(this.findColumnIndex(string));
    }

    public InputStream getBinaryStream(String string) throws SQLException {
        return this.getBinaryStream(this.findColumnIndex(string));
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.head_warning;
    }

    public void clearWarnings() throws SQLException {
        this.head_warning = null;
    }

    public String getCursorName() throws SQLException {
        throw new SQLException("Not Supported");
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return new MResultSetMetaData(this);
    }

    public Object getObject(int n) throws SQLException {
        Object object = this.getRawColumn(n);
        if (object == null) {
            return object;
        }
        if (this.connection.isStrictGetObject()) {
            ColumnDescription columnDescription = this.getColumn(n - 1);
            int n2 = columnDescription.getSQLType();
            return this.jdbcObjectCast(object, n2);
        }
        if (object instanceof ByteLongObject) {
            return new MBlob((ByteLongObject)object);
        }
        return object;
    }

    public Object getObject(String string) throws SQLException {
        return this.getObject(this.findColumnIndex(string));
    }

    public int findColumn(String string) throws SQLException {
        return this.findColumnIndex(string);
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        Object object = this.getRawColumn(n);
        if (object == null) {
            return null;
        }
        if (object instanceof BigDecimal) {
            return (BigDecimal)object;
        }
        return new BigDecimal(object.toString());
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        return this.getBigDecimal(this.findColumnIndex(string));
    }

    public void setFetchSize(int n) throws SQLException {
        this.fetch_size = n > 0 ? Math.min(n, 512) : 32;
    }

    public int getFetchSize() throws SQLException {
        return this.fetch_size;
    }

    public Reader getCharacterStream(int n) throws SQLException {
        return new StringReader(this.getString(n));
    }

    public Reader getCharacterStream(String string) throws SQLException {
        return this.getCharacterStream(this.findColumnIndex(string));
    }

    public boolean isBeforeFirst() throws SQLException {
        return this.real_index < 0;
    }

    public boolean isAfterLast() throws SQLException {
        return this.real_index >= this.rowCount();
    }

    public boolean isFirst() throws SQLException {
        return this.real_index == 0;
    }

    public boolean isLast() throws SQLException {
        return this.real_index == this.rowCount() - 1;
    }

    public void beforeFirst() throws SQLException {
        this.real_index = -1;
    }

    public void afterLast() throws SQLException {
        this.real_index = this.rowCount();
    }

    public boolean first() throws SQLException {
        this.real_index = 0;
        this.realIndexUpdate();
        return this.real_index < this.rowCount();
    }

    public boolean last() throws SQLException {
        this.real_index = this.rowCount() - 1;
        this.realIndexUpdate();
        return this.real_index >= 0;
    }

    public int getRow() throws SQLException {
        return this.real_index + 1;
    }

    public boolean absolute(int n) throws SQLException {
        if (n > 0) {
            this.real_index = n - 1;
        } else if (n < 0) {
            this.real_index = this.rowCount() + n;
        }
        this.realIndexUpdate();
        return this.real_index >= 0 && this.real_index < this.rowCount();
    }

    public boolean relative(int n) throws SQLException {
        this.real_index += n;
        int n2 = this.rowCount();
        if (this.real_index < -1) {
            this.real_index = -1;
        }
        if (this.real_index > n2) {
            this.real_index = n2;
        }
        this.realIndexUpdate();
        return this.real_index >= 0 && this.real_index < this.rowCount();
    }

    public boolean previous() throws SQLException {
        if (this.real_index >= 0) {
            --this.real_index;
            this.realIndexUpdate();
        }
        return this.real_index >= 0;
    }

    public void setFetchDirection(int n) throws SQLException {
    }

    public int getFetchDirection() throws SQLException {
        return 1002;
    }

    public int getType() throws SQLException {
        return 1004;
    }

    public int getConcurrency() throws SQLException {
        return 1007;
    }

    public boolean rowUpdated() throws SQLException {
        throw new SQLException("Not Supported");
    }

    public boolean rowInserted() throws SQLException {
        throw new SQLException("Not Supported");
    }

    public boolean rowDeleted() throws SQLException {
        throw new SQLException("Not Supported");
    }

    public void updateNull(int n) throws SQLException {
        throw new SQLException("Not Supported");
    }

    public void updateBoolean(int n, boolean bl) throws SQLException {
        throw new SQLException("Not Supported");
    }

    public void updateByte(int n, byte by) throws SQLException {
        throw new SQLException("Not Supported");
    }

    public void updateShort(int n, short s) throws SQLException {
        throw new SQLException("Not Supported");
    }

    public void updateInt(int n, int n2) throws SQLException {
        throw new SQLException("Not Supported");
    }

    public void updateLong(int n, long l) throws SQLException {
        throw new SQLException("Not Supported");
    }

    public void updateFloat(int n, float f) throws SQLException {
        throw new SQLException("Not Supported");
    }

    public void updateDouble(int n, double d) throws SQLException {
        throw new SQLException("Not Supported");
    }

    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        throw new SQLException("Not Supported");
    }

    public void updateString(int n, String string) throws SQLException {
        throw new SQLException("Not Supported");
    }

    public void updateBytes(int n, byte[] byArray) throws SQLException {
        throw new SQLException("Not Supported");
    }

    public void updateDate(int n, Date date) throws SQLException {
        throw new SQLException("Not Supported");
    }

    public void updateTime(int n, Time time) throws SQLException {
        throw new SQLException("Not Supported");
    }

    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        throw new SQLException("Not Supported");
    }

    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        throw new SQLException("Not Supported");
    }

    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        throw new SQLException("Not Supported");
    }

    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        throw new SQLException("Not Supported");
    }

    public void updateObject(int n, Object object, int n2) throws SQLException {
        throw new SQLException("Not Supported");
    }

    public void updateObject(int n, Object object) throws SQLException {
        throw new SQLException("Not Supported");
    }

    public void updateNull(String string) throws SQLException {
        throw new SQLException("Not Supported");
    }

    public void updateBoolean(String string, boolean bl) throws SQLException {
        throw new SQLException("Not Supported");
    }

    public void updateByte(String string, byte by) throws SQLException {
        throw new SQLException("Not Supported");
    }

    public void updateShort(String string, short s) throws SQLException {
        throw new SQLException("Not Supported");
    }

    public void updateInt(String string, int n) throws SQLException {
        throw new SQLException("Not Supported");
    }

    public void updateLong(String string, long l) throws SQLException {
        throw new SQLException("Not Supported");
    }

    public void updateFloat(String string, float f) throws SQLException {
        throw new SQLException("Not Supported");
    }

    public void updateDouble(String string, double d) throws SQLException {
        throw new SQLException("Not Supported");
    }

    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        throw new SQLException("Not Supported");
    }

    public void updateString(String string, String string2) throws SQLException {
        throw new SQLException("Not Supported");
    }

    public void updateBytes(String string, byte[] byArray) throws SQLException {
        throw new SQLException("Not Supported");
    }

    public void updateDate(String string, Date date) throws SQLException {
        throw new SQLException("Not Supported");
    }

    public void updateTime(String string, Time time) throws SQLException {
        throw new SQLException("Not Supported");
    }

    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        throw new SQLException("Not Supported");
    }

    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        throw new SQLException("Not Supported");
    }

    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        throw new SQLException("Not Supported");
    }

    public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        throw new SQLException("Not Supported");
    }

    public void updateObject(String string, Object object, int n) throws SQLException {
        throw new SQLException("Not Supported");
    }

    public void updateObject(String string, Object object) throws SQLException {
        throw new SQLException("Not Supported");
    }

    public void insertRow() throws SQLException {
        throw new SQLException("Not Supported");
    }

    public void updateRow() throws SQLException {
        throw new SQLException("Not Supported");
    }

    public void deleteRow() throws SQLException {
        throw new SQLException("Not Supported");
    }

    public void refreshRow() throws SQLException {
        throw new SQLException("Not Supported");
    }

    public void cancelRowUpdates() throws SQLException {
        throw new SQLException("Not Supported");
    }

    public void moveToInsertRow() throws SQLException {
        throw new SQLException("Not Supported");
    }

    public void moveToCurrentRow() throws SQLException {
        throw new SQLException("Not Supported");
    }

    public Statement getStatement() throws SQLException {
        return this.statement;
    }

    public Object getObject(int n, Map map) throws SQLException {
        return this.getObject(n);
    }

    public Ref getRef(int n) throws SQLException {
        throw new SQLException("Not Supported");
    }

    public Blob getBlob(int n) throws SQLException {
        Object object = this.getRawColumn(n);
        if (object != null) {
            if (object instanceof ByteLongObject) {
                return new MBlob((ByteLongObject)object);
            }
            throw new SQLException("Column " + n + " is not a binary column.");
        }
        return null;
    }

    public Clob getClob(int n) throws SQLException {
        throw new SQLException("Not Supported");
    }

    public Array getArray(int n) throws SQLException {
        throw new SQLException("Not Supported");
    }

    public Object getObject(String string, Map map) throws SQLException {
        return this.getObject(string);
    }

    public Ref getRef(String string) throws SQLException {
        throw new SQLException("Not Supported");
    }

    public Blob getBlob(String string) throws SQLException {
        return this.getBlob(this.findColumnIndex(string));
    }

    public Clob getClob(String string) throws SQLException {
        throw new SQLException("Not Supported");
    }

    public Array getArray(String string) throws SQLException {
        throw new SQLException("Not Supported");
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        return this.getDate(n);
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        return this.getDate(string);
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        return this.getTime(n);
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        return this.getTime(string);
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        return this.getTimestamp(n);
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        return this.getTimestamp(string);
    }

    public URL getURL(int n) throws SQLException {
        throw new SQLException("Not Supported");
    }

    public URL getURL(String string) throws SQLException {
        throw new SQLException("Not Supported");
    }

    public void updateRef(int n, Ref ref) throws SQLException {
        throw new SQLException("Not Supported");
    }

    public void updateRef(String string, Ref ref) throws SQLException {
        throw new SQLException("Not Supported");
    }

    public void updateBlob(int n, Blob blob) throws SQLException {
        throw new SQLException("Not Supported");
    }

    public void updateBlob(String string, Blob blob) throws SQLException {
        throw new SQLException("Not Supported");
    }

    public void updateClob(int n, Clob clob) throws SQLException {
        throw new SQLException("Not Supported");
    }

    public void updateClob(String string, Clob clob) throws SQLException {
        throw new SQLException("Not Supported");
    }

    public void updateArray(int n, Array array) throws SQLException {
        throw new SQLException("Not Supported");
    }

    public void updateArray(String string, Array array) throws SQLException {
        throw new SQLException("Not Supported");
    }

    public void finalize() {
        this.dispose();
    }
}

