/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database.jdbc;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.SQLException;

public class MSQLException
extends SQLException {
    private String server_error_msg;
    private String server_stack_trace;

    public MSQLException(String string, String string2, int n) {
        super(string, string2, n);
    }

    public MSQLException(String string, String string2) {
        super(string, string2);
    }

    public MSQLException(String string) {
        super(string);
    }

    public MSQLException() {
    }

    public MSQLException(String string, String string2, int n, Throwable throwable) {
        super(string, null, n);
        this.server_error_msg = string2;
        if (throwable != null) {
            StringWriter stringWriter = new StringWriter();
            throwable.printStackTrace(new PrintWriter(stringWriter));
            this.server_stack_trace = stringWriter.toString();
        } else {
            this.server_stack_trace = "<< NO SERVER STACK TRACE >>";
        }
    }

    public MSQLException(String string, String string2, int n, String string3) {
        super(string, null, n);
        this.server_error_msg = string2;
        this.server_stack_trace = string3;
    }

    public String getServerErrorMsg() {
        return this.server_error_msg;
    }

    public String getServerErrorStackTrace() {
        return this.server_stack_trace;
    }

    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace(PrintStream printStream) {
        PrintStream printStream2 = printStream;
        synchronized (printStream2) {
            super.printStackTrace(printStream);
            if (this.server_stack_trace != null) {
                printStream.print("CAUSE: ");
                printStream.println(this.server_stack_trace);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace(PrintWriter printWriter) {
        PrintWriter printWriter2 = printWriter;
        synchronized (printWriter2) {
            super.printStackTrace(printWriter);
            if (this.server_stack_trace != null) {
                printWriter.print("CAUSE: ");
                printWriter.println(this.server_stack_trace);
            }
        }
    }
}

