/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database.jdbc;

import com.mckoi.database.global.ColumnDescription;
import com.mckoi.database.global.ObjectTransfer;
import com.mckoi.database.jdbc.DatabaseCallBack;
import com.mckoi.database.jdbc.DatabaseInterface;
import com.mckoi.database.jdbc.MDriver;
import com.mckoi.database.jdbc.MSQLException;
import com.mckoi.database.jdbc.ProtocolConstants;
import com.mckoi.database.jdbc.QueryResponse;
import com.mckoi.database.jdbc.ResultPart;
import com.mckoi.database.jdbc.SQLLoginException;
import com.mckoi.database.jdbc.SQLQuery;
import com.mckoi.util.ByteArrayUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Vector;

abstract class RemoteDatabaseInterface
implements DatabaseInterface,
ProtocolConstants {
    private ConnectionThread connection_thread;
    private DatabaseCallBack database_call_back;

    RemoteDatabaseInterface() {
    }

    private static void logException(Throwable throwable) {
        PrintWriter printWriter = null;
        printWriter = DriverManager.getLogWriter();
        if (printWriter != null) {
            throwable.printStackTrace(printWriter);
        } else {
            throwable.printStackTrace(System.err);
        }
    }

    abstract void writeCommandToServer(byte[] var1, int var2, int var3) throws IOException;

    abstract byte[] nextCommandFromServer(int var1) throws IOException;

    abstract void closeConnection() throws IOException;

    public boolean login(String string, String string2, String string3, DatabaseCallBack databaseCallBack) throws SQLException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeInt(13553671);
            dataOutputStream.writeInt(0);
            dataOutputStream.writeInt(70);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            this.writeCommandToServer(byArray, 0, byArray.length);
            byte[] byArray2 = this.nextCommandFromServer(0);
            int n = ByteArrayUtil.getInt(byArray2, 0);
            if (n == 5) {
                int n2 = 0;
                if (byArray2.length > 4 && byArray2[4] == 1) {
                    n2 = ByteArrayUtil.getInt(byArray2, 5);
                }
                byteArrayOutputStream.reset();
                dataOutputStream.writeUTF(string);
                dataOutputStream.writeUTF(string2);
                dataOutputStream.writeUTF(string3);
                byArray = byteArrayOutputStream.toByteArray();
                this.writeCommandToServer(byArray, 0, byArray.length);
                byArray2 = this.nextCommandFromServer(0);
                int n3 = ByteArrayUtil.getInt(byArray2, 0);
                if (n3 == 10) {
                    this.database_call_back = databaseCallBack;
                    this.connection_thread = new ConnectionThread();
                    this.connection_thread.start();
                    return true;
                }
                if (n3 == 15) {
                    throw new SQLLoginException("User Authentication failed.");
                }
                throw new SQLException("Unexpected response.");
            }
            throw new SQLException("No acknowledgement received from server.");
        }
        catch (IOException iOException) {
            RemoteDatabaseInterface.logException(iOException);
            throw new SQLException("IOException: " + iOException.getMessage());
        }
    }

    public QueryResponse execQuery(SQLQuery sQLQuery) throws SQLException {
        try {
            int n = this.connection_thread.executeQuery(sQLQuery);
            ServerCommand serverCommand = this.connection_thread.getCommand(MDriver.QUERY_TIMEOUT, n);
            if (serverCommand == null) {
                throw new SQLException("Query timed out after " + MDriver.QUERY_TIMEOUT + " seconds.");
            }
            DataInputStream dataInputStream = new DataInputStream(serverCommand.getInputStream());
            int n2 = dataInputStream.readInt();
            if (n2 == 20) {
                final int n3 = dataInputStream.readInt();
                final int n4 = dataInputStream.readInt();
                final int n5 = dataInputStream.readInt();
                final int n6 = dataInputStream.readInt();
                final ColumnDescription[] columnDescriptionArray = new ColumnDescription[n6];
                int n7 = 0;
                while (n7 < n6) {
                    columnDescriptionArray[n7] = ColumnDescription.readFrom(dataInputStream);
                    ++n7;
                }
                return new QueryResponse(){

                    public int getResultID() {
                        return n3;
                    }

                    public int getQueryTimeMillis() {
                        return n4;
                    }

                    public int getRowCount() {
                        return n5;
                    }

                    public int getColumnCount() {
                        return n6;
                    }

                    public ColumnDescription getColumnDescription(int n) {
                        return columnDescriptionArray[n];
                    }

                    public String getWarnings() {
                        return "";
                    }
                };
            }
            if (n2 == 30) {
                int n8 = dataInputStream.readInt();
                String string = dataInputStream.readUTF();
                String string2 = dataInputStream.readUTF();
                throw new MSQLException(string, null, n8, string2);
            }
            if (n2 == 35) {
                String string = dataInputStream.readUTF();
                String string3 = dataInputStream.readUTF();
                throw new SQLException("User doesn't have enough privs to " + string + " table " + string3);
            }
            System.err.println(n2);
            int n9 = dataInputStream.available();
            int n10 = 0;
            while (n10 < n9) {
                System.err.print(dataInputStream.read() + ", ");
                ++n10;
            }
            throw new SQLException("Illegal response code from server.");
        }
        catch (IOException iOException) {
            RemoteDatabaseInterface.logException(iOException);
            throw new SQLException("IO Error: " + iOException.getMessage());
        }
    }

    public ResultPart getResultPart(int n, int n2, int n3) throws SQLException {
        try {
            int n4 = this.connection_thread.getResultPart(n, n2, n3);
            ServerCommand serverCommand = this.connection_thread.getCommand(MDriver.QUERY_TIMEOUT, n4);
            if (serverCommand == null) {
                throw new SQLException("Downloading result part timed out after " + MDriver.QUERY_TIMEOUT + " seconds.");
            }
            DataInputStream dataInputStream = new DataInputStream(serverCommand.getInputStream());
            int n5 = dataInputStream.readInt();
            if (n5 == 20) {
                int n6 = dataInputStream.readInt();
                int n7 = n3 * n6;
                ResultPart resultPart = new ResultPart(n7);
                int n8 = 0;
                while (n8 < n7) {
                    resultPart.addElement(ObjectTransfer.readFrom(dataInputStream));
                    ++n8;
                }
                return resultPart;
            }
            if (n5 == 30) {
                int n9 = dataInputStream.readInt();
                String string = dataInputStream.readUTF();
                String string2 = dataInputStream.readUTF();
                throw new SQLException(string, null, n9);
            }
            throw new SQLException("Illegal response code from server.");
        }
        catch (IOException iOException) {
            RemoteDatabaseInterface.logException(iOException);
            throw new SQLException("IO Error: " + iOException.getMessage());
        }
    }

    public void disposeResult(int n) throws SQLException {
        try {
            int n2 = this.connection_thread.disposeResult(n);
            ServerCommand serverCommand = this.connection_thread.getCommand(MDriver.QUERY_TIMEOUT, n2);
            if (serverCommand == null) {
                throw new SQLException("Dispose result timed out after " + MDriver.QUERY_TIMEOUT + " seconds.");
            }
            DataInputStream dataInputStream = new DataInputStream(serverCommand.getInputStream());
            int n3 = dataInputStream.readInt();
            if (n3 == 25) {
                throw new SQLException("Dispose failed: " + dataInputStream.readUTF());
            }
        }
        catch (IOException iOException) {
            RemoteDatabaseInterface.logException(iOException);
            throw new SQLException("IO Error: " + iOException.getMessage());
        }
    }

    public void dispose() throws SQLException {
        try {
            int n = this.connection_thread.sendCloseCommand();
            this.closeConnection();
        }
        catch (IOException iOException) {
            RemoteDatabaseInterface.logException(iOException);
            throw new SQLException("IO Error: " + iOException.getMessage());
        }
    }

    static class ServerCommand {
        private int dispatch_id;
        private byte[] buf;

        ServerCommand(int n, byte[] byArray) {
            this.dispatch_id = n;
            this.buf = byArray;
        }

        public int dispatchID() {
            return this.dispatch_id;
        }

        public byte[] getBuf() {
            return this.buf;
        }

        public ByteArrayInputStream getInputStream() {
            return new ByteArrayInputStream(this.buf, 4, this.buf.length - 4);
        }
    }

    static class MByteArrayOutputStream
    extends ByteArrayOutputStream {
        MByteArrayOutputStream() {
            super(256);
        }

        public byte[] getBuffer() {
            return this.buf;
        }

        public int size() {
            return this.count;
        }
    }

    private class ConnectionThread
    extends Thread {
        private MByteArrayOutputStream com_bytes = new MByteArrayOutputStream();
        private DataOutputStream com_data = new DataOutputStream(this.com_bytes);
        private int running_dispatch_id = 1;
        private boolean thread_closed = false;
        private Vector commands_list = new Vector();

        ConnectionThread() throws IOException {
        }

        private int nextDispatchID() {
            return this.running_dispatch_id++;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        ServerCommand getCommand(int n, int n2) throws SQLException {
            long l = System.currentTimeMillis();
            long l2 = l + (long)(n * 1000);
            if (this.commands_list == null) {
                throw new SQLException("Connection to server closed");
            }
            Vector vector = this.commands_list;
            synchronized (vector) {
                while (true) {
                    int n3 = 0;
                    while (n3 < this.commands_list.size()) {
                        ServerCommand serverCommand = (ServerCommand)this.commands_list.elementAt(n3);
                        if (serverCommand.dispatchID() == n2) {
                            this.commands_list.removeElementAt(n3);
                            return serverCommand;
                        }
                        ++n3;
                    }
                    if (n != 0 && System.currentTimeMillis() > l2) {
                        return null;
                    }
                    try {
                        this.commands_list.wait(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
            }
        }

        private synchronized void flushCommand() throws IOException {
            RemoteDatabaseInterface.this.writeCommandToServer(this.com_bytes.getBuffer(), 0, this.com_bytes.size());
            this.com_bytes.reset();
        }

        synchronized int executeQuery(SQLQuery sQLQuery) throws IOException {
            int n = this.nextDispatchID();
            this.com_data.writeInt(50);
            this.com_data.writeInt(n);
            sQLQuery.writeTo(this.com_data);
            this.flushCommand();
            return n;
        }

        synchronized int disposeResult(int n) throws IOException {
            int n2 = this.nextDispatchID();
            this.com_data.writeInt(55);
            this.com_data.writeInt(n2);
            this.com_data.writeInt(n);
            this.flushCommand();
            return n2;
        }

        synchronized int getResultPart(int n, int n2, int n3) throws IOException {
            int n4 = this.nextDispatchID();
            this.com_data.writeInt(60);
            this.com_data.writeInt(n4);
            this.com_data.writeInt(n);
            this.com_data.writeInt(n2);
            this.com_data.writeInt(n3);
            this.flushCommand();
            return n4;
        }

        synchronized int sendCloseCommand() throws IOException {
            int n = this.nextDispatchID();
            this.com_data.writeInt(70);
            this.com_data.writeInt(n);
            this.flushCommand();
            return n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            Vector vector;
            Vector vector2;
            try {
                try {
                    while (!this.thread_closed) {
                        byte[] byArray = RemoteDatabaseInterface.this.nextCommandFromServer(0);
                        int n = ByteArrayUtil.getInt(byArray, 0);
                        if (n == -1) {
                            this.processEvent(byArray);
                        }
                        Vector vector3 = this.commands_list;
                        synchronized (vector3) {
                            this.commands_list.addElement(new ServerCommand(n, byArray));
                            this.commands_list.notifyAll();
                        }
                    }
                }
                catch (IOException iOException) {
                    Vector vector22;
                    Object var6_6 = null;
                    Vector vector3 = vector22 = this.commands_list;
                    synchronized (vector3) {
                        this.commands_list = null;
                        vector22.notifyAll();
                        return;
                    }
                }
                Object var6_5 = null;
                vector = vector2 = this.commands_list;
            }
            catch (Throwable throwable) {
                Vector vector6;
                Object var6_7 = null;
                Vector vector7 = vector6 = this.commands_list;
                synchronized (vector7) {
                    this.commands_list = null;
                    vector6.notifyAll();
                    throw throwable;
                }
            }
            synchronized (vector) {
                this.commands_list = null;
                vector2.notifyAll();
                return;
            }
        }

        private void processEvent(byte[] byArray) throws IOException {
            int n = ByteArrayUtil.getInt(byArray, 4);
            if (n != 65) {
                if (n == 75) {
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray, 8, byArray.length - 8);
                    DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
                    int n2 = dataInputStream.readInt();
                    String string = dataInputStream.readUTF();
                    RemoteDatabaseInterface.this.database_call_back.databaseEvent(n2, string);
                } else {
                    System.err.println("[RemoteDatabaseInterface] Received unrecognised server side event: " + n);
                }
            }
        }
    }
}

