/*
 * $Source: /usr/cvsroot/melati/melati/src/main/java/org/melati/test/TemplateServletTestOverride.java,v $
 * $Revision: 1.13 $
 *
 * Copyright (C) 2000 Tim Joyce
 *
 * Part of Melati (http://melati.org), a framework for the rapid
 * development of clean, maintainable web applications.
 *
 * Melati is free software; Permission is granted to copy, distribute
 * and/or modify this software under the terms either:
 *
 * a) the GNU General Public License as published by the Free Software
 *    Foundation; either version 2 of the License, or (at your option)
 *    any later version,
 *
 *    or
 *
 * b) any version of the Melati Software License, as published
 *    at http://melati.org
 *
 * You should have received a copy of the GNU General Public License and
 * the Melati Software License along with this program;
 * if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA to obtain the
 * GNU General Public License and visit http://melati.org to obtain the
 * Melati Software License.
 *
 * Feel free to contact the Developers of Melati (http://melati.org),
 * if you would like to work out a different arrangement than the options
 * outlined here.  It is our intention to allow Melati to be used by as
 * wide an audience as possible.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * Contact details for copyright holder:
 *
 *     Tim Joyce <timj@paneris.org>
 *     http://paneris.org/
 *     68 Sandbanks Rd, Poole, Dorset. BH14 8BY. UK
 */

package org.melati.test;


import org.melati.MelatiConfig;
import org.melati.login.HttpBasicAuthenticationAccessHandler;

/**
 * Illustrate overridden authentication handling.
 * AccessHandler is initialsed from MelatiConfig, whis is assumed 
 * to set to 
 * <code>org.melati.login.HttpSessionAccessHandler</code> in 
 * <code>org.melati.MelatiConfig.properties</code>;
 * we then override that configuration.
 *
 * @author Tim Joyce
 * $Revision: 1.13 $
 */
public class TemplateServletTestOverride extends TemplateServletTest {

  private static final long serialVersionUID = -6816954042196744208L;

/**
 * Override the default (set) authentication method.
 * Demonstrates how to override individual set properties.
 */
  protected MelatiConfig melatiConfig() {
    MelatiConfig config = super.melatiConfig();
    config.setAccessHandler(new HttpBasicAuthenticationAccessHandler());
    return config;
  }

}






